/*
    libparted - a library for manipulating disk partitions
    Copyright (C) 1998-1999  Andrew Clausen and Lennert Buytenhek

	Andrew Clausen			<clausen@gnu.org>
	Lennert Buytenhek		<buytenh@gnu.org>
        Matt Wilson, Red Hat Inc.       <msw@redhat.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* should only be #included by files in libparted */

#ifndef PED_ENDIAN_H_INCLUDED
#define PED_ENDIAN_H_INCLUDED

#include <sys/types.h>
#include "config.h"

#define	_PED_SWAP16(x)		( (((x) & 0x00ff) << 8)		\
				+ (((x) & 0xff00) >> 8) )

#define	_PED_SWAP32(x)		( (((x) & 0x000000ff) << 24)	\
				+ (((x) & 0x0000ff00) << 8)	\
				+ (((x) & 0x00ff0000) >> 8)	\
				+ (((x) & 0xff000000) >> 24) )

#define PED_SWAP16(x)		((unsigned short)	\
					_PED_SWAP16( (unsigned short) x ))
#define PED_SWAP32(x)		((unsigned int)		\
					_PED_SWAP32( (unsigned int) x ))

#ifdef WORDS_BIGENDIAN

#define PED_CPU_TO_LE16(x)	PED_SWAP16(x)
#define PED_CPU_TO_BE16(x)	(x)
#define PED_CPU_TO_LE32(x)	PED_SWAP32(x)
#define PED_CPU_TO_BE32(x)	(x)

#define PED_LE16_TO_CPU(x)	PED_SWAP16(x)
#define PED_BE16_TO_CPU(x)	(x)
#define PED_LE32_TO_CPU(x)	PED_SWAP32(x)
#define PED_BE32_TO_CPU(x)	(x)

#else /* !WORDS_BIGENDIAN */

#define PED_CPU_TO_LE16(x)	(x)
#define PED_CPU_TO_BE16(x)	PED_SWAP16(x)
#define PED_CPU_TO_LE32(x)	(x)
#define PED_CPU_TO_BE32(x)	PED_SWAP32(x)

#define PED_LE16_TO_CPU(x)	(x)
#define PED_BE16_TO_CPU(x)	PED_SWAP16(x)
#define PED_LE32_TO_CPU(x)	(x)
#define PED_BE32_TO_CPU(x)	PED_SWAP32(x)

#endif /* !WORDS_BIGENDIAN */

#endif /* PED_ENDIAN_H_INCLUDED */

