/*
    parted - a frontend to libparted
    Copyright (C) 1999  Andrew Clausen, Lennert Buytenhek and Red Hat, Inc.

    Andrew Clausen		<clausen@gnu.org>
    Lennert Buytenhek		<buytenh@gnu.org>
    Matt Wilson, Red Hat Inc.	<msw@redhat.com>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#include "command.h"
#include "ui.h"

#include <stdlib.h>
#include <string.h>

Command*
command_create (const StrList* names,
		int (*method) (PedDevice* dev),
		const StrList* summary,
		const StrList* help)
{
	Command*	cmd;

	cmd = malloc (sizeof (Command));
	cmd->names = (StrList*) names;
	cmd->method = method;
	cmd->summary = (StrList*) summary;
	cmd->help = (StrList*) help;

	return cmd;
}

void
command_destroy (Command* cmd)
{
	str_list_destroy (cmd->names);
	str_list_destroy (cmd->summary);
	str_list_destroy (cmd->help);
	free (cmd);
}

void
command_register (Command** list, Command* cmd)
{
	int	i;

	for (i = 0; list [i]; i++);

	list [i] = cmd;
	list [i + 1] = (Command*) NULL;
}

Command*
command_get (Command** list, char* name)
{
	int		i;
	int		partial_match = -1;
	int		ambiguous = 0;

	if (!name)
		return NULL;

	for (i=0; list [i]; i++) {
		switch (str_list_match (list [i]->names, name)) {
		case 2:
			return list [i];

		case 1:
			if (!ambiguous) {
				if (partial_match == -1) {
					partial_match = i;
				} else {
					partial_match = -1;
					ambiguous = 1;
				}
			}
		}
	}

	if (partial_match == -1)
		return NULL;
	else
		return list [partial_match];
}

void
command_print_summary (Command* cmd)
{
	printf ("  ");
	str_list_print_wrap (cmd->summary, screen_width(), 2, 8);
	printf ("\n");
}

void
command_print_help (Command* cmd)
{
	command_print_summary (cmd);
	if (cmd->help) {
		printf ("\n\t");
		str_list_print_wrap (cmd->help, screen_width(), 8, 8);
	}
}

int
command_run (Command* cmd, PedDevice* dev)
{
	return cmd->method (dev);
}

