/*
 * Copyright (c) 2000 Dave Jones <dave@powertweak.com>
 *
 * Can be freely distributed and used under the terms of the GNU GPL.
 */

#include "cpudata.h"
#include "cpuid.c"
#include "cpu_amd.c"

#define CPU_VENDOR_UNKNOWN 	0
#define CPU_VENDOR_AMD		1
#define CPU_VENDOR_INTEL	2
#define CPU_VENDOR_CYRIX	3
#define CPU_VENDOR_CENTAURHAULS	4
#define CPU_VENDOR_IDT		4
#define CPU_VENDOR_NEXGEN	5
#define CPU_VENDOR_RISE		6
#define CPU_VENDOR_UMC		7


void identify_CPU(void)
{
	unsigned int eax,ebx,ecx,edx;

	/* Vendor ID and max CPUID level supported */
	cpuid(0, &eax,&ebx,&ecx,&edx);
	cpu0_data.MaxCPUID = eax;

	switch (ebx) {

		case 0x68747541:	/* 'htuA' AMD */
							Decode_AMD();
							cpu0_data.vendor = CPU_VENDOR_AMD;
							break;

		case 0x69727943:	/* 'iryC' Cyrix */
							cpu0_data.vendor = CPU_VENDOR_CYRIX;
							break;

		case 0x746e6543:	/* 'tneC' Centaur-Hauls */
							cpu0_data.vendor = CPU_VENDOR_CENTAURHAULS;
							break;

		case 0x756e6547:	/* 'uneG' Intel */
							cpu0_data.vendor = CPU_VENDOR_INTEL;
							break;

		case 0x4778654e:	/* 'GxeN' NexGen */
							cpu0_data.vendor = CPU_VENDOR_NEXGEN;
							break;

		case 0x73655269:	/* 'esiR' Rise */
							cpu0_data.vendor = CPU_VENDOR_RISE;
							break;

		case 0x20434d55:	/* ' CMU' UMC */
							cpu0_data.vendor = CPU_VENDOR_UMC;
							break;

		default:
							cpu0_data.vendor = CPU_VENDOR_UNKNOWN;
							break;
	}
}
