/*
 * Hardware tuning for the Intel 824xx PCI bridges.
 * This covers..
 *	82424 [Saturn]
 *	82430 [Aries]
 *	82434 [Mercury/Neptune]
 */

#define PCI_DEVICE_ID_Intel_82424 0x0483	/* Saturn */
#define PCI_DEVICE_ID_Intel_82430 0x0486	/* Aries */
#define PCI_DEVICE_ID_Intel_82434 0x04A3	/* Mercury/Neptune */

static Tweaks_t Intel_824xx_Tweaks[] = {
	{ "CPU2PCI_POSTED_WRITE",
		0x53,
		1<<1,
		1<<1,
		"CPU->PCI posted write",
		"1",
		0, 0 },

	{ "CPU2RAM_POSTED_WRITE",
		0x53,
		1<<0,
		1<<0,
		"CPU->RAM posted write",
		"1",
		0, 0 },

	{ "PCI2RAM_POSTED_WRITE",
		0x54,
		1<<0,
		1<<0,
		"PCI->RAM posted write",
		"1",
		0, 0 },

	{ "PCI_BURST",
		0x54,
		1<<1,
		1<<1,
		"PCI Burst",
		"1",
		0, 0 },

	{ 0, 0, 0, 0, 0, 0, 0, 0 }
};
