/*
 * Hardware tuning for the VIA 82C586_0 PCI-to-ISA bridge
 */

#include "82C586_0.h"

unsigned int getnumtweaks_VIA_586_0(struct pci_dev *current_dev)
{
	word revision_id;
	revision_id = pci_read_word (current_dev, PCI_REVISION_ID);

	switch (revision_id)  {

		case 0x00 ... 0x3e:
		case 0x3f:
		case 0x40 ... 0x4f:
			return (sizeof(VIA_82C586_0_Tweaks)/sizeof(Tweaks_t))-1;

		// FIXME:This curently detects but does nothing extra to 82C586B (3041 and 3040 silicon)
		default:
			return(0);
	}
}

void init_VIA_586_0(struct pci_dev *current_dev)
{
	unsigned int numtweaks;

	numtweaks = getnumtweaks_VIA_586_0(current_dev);
	if (numtweaks!=0)
		init_tweaks(numtweaks, VIA_82C586_0_Tweaks, current_dev);
}


void tune_VIA_586_0(GtkWidget *table, struct pci_dev *current_dev, unsigned int numbuttons)
{
	word revision_id;
	Tweaks_t *Tweaks;

	unsigned int index;
	int column=0;

	Tweaks = VIA_82C586_0_Tweaks;


	/* Subsystem id is programmable on VIA MVP3 so could be anything
	   so it looks as if we have to use the revision id */
	revision_id = pci_read_word (current_dev, PCI_REVISION_ID);

	switch (revision_id)  {

		case 0x00 ... 0x3e:
		case 0x3f:
		case 0x40 ... 0x4f:
			for (index=0;index<numbuttons;index++) {
				CreateButton(table, Tweaks, current_dev, column);
				column++;
				Tweaks++;
			}
			break;

		// FIXME:This curently detects but does nothing extra to 82C586B (3041 and 3040 silicon)
		default:
			break;
	}
}

void save_VIA_586_0(FILE *savehandle, struct pci_dev *current_dev)
{
	unsigned int numtweaks;

	numtweaks = getnumtweaks_VIA_586_0(current_dev);
	if (numtweaks!=0)
		write_tweaks(savehandle, numtweaks, VIA_82C586_0_Tweaks, current_dev);
}
