.TH Powertweak 8 "@TODAY@" "@VERSION@" "Powertweak Linux"
.IX Powertweak
.SH NAME
Powertweak \- Tune system to optimal performance.
.SH SYNOPSIS
.B Powertweak
.RB [ options ]

.SH DESCRIPTION
.PP
.B Powertweak
is a utility for tweaking your Linux system to peak performance.
It can tune many parts of your system.
 Tunes PCI devices to use optimal settings.
 Enables performance enhancing features.

To make use of all the features of this program, you need to have Linux kernel
2.1.82 or newer which supports the /proc/bus/pci interface. With older kernels,
direct hardware access is necessary, which is available only to root and suffers
from numerous race conditions and other problems.

This program was originally written to replace the Linux 2.2.x kernel
feature 'PCI bridge optimization'. With the advent of Powertweak, it is likely that this
feature will be removed in some future version of the kernel.
Powertweak will eventually contain all the performance tuning code from the Linux
kernel, and much more. Moving this from kernel space to user space has many advantages.
More space for new kernel features.
 Easier debugging of performance enhancers
 Easier user-configuration
 Increased functionality and flexability.

.SH PCILIB OPTIONS
Powertweak uses PCILIB (a portable library providing platform-independent
functions for PCI configuration space access) to talk to the PCI cards. The following
options control parameters of the library, especially what access method it uses.
By default, PCILIB uses the first available access method and displays no debugging
messages. Each switch is accompanied by a list of hardware/software configurations
it's supported in.

.TP
.B -P <dir>
Use Linux 2.1 style configuration access to directory
.B <dir>
instead of /proc/bus/pci. (Linux 2.1 or newer only)
.TP
.B -H1
Use direct hardware access via Intel configuration mechanism 1. (i386 and compatible only)
.TP
.B -H2
Use direct hardware access via Intel configuration mechanism 2. Warning: This method
is able to address only first 16 devices on any bus and it seems to be very
unrealiable in many cases. (i386 and compatible only)
.TP
.B -S
Use PCI access syscalls. (Linux on Alpha and UltraSparc only)
.TP
.B -F <file>
Extract all information from given file containing output of lspci -x. This is very
useful for analysis of user-supplied bug reports, because you can display the
hardware configuration in any way you want without disturbing the user with
requests for more dumps. (All systems)
.TP
.B -G
Increase debug level of the library. (All systems)

.SH LIMITATIONS
.PP
.I Powertweak
needs direct access to the PCI config registers which normal users don't have.
Therefore it only runs as root, or in a startup script.

.SH DISCLAIMER
.PP
.I Powertweak
is poking low level chipset registers. There exists the possibility that some flaky
hardware may be pushed beyond its limits. If this is the case, neither the author of
Powertweak or the author of PCILIB can be held responsible for any loss of data incurred,
or for any damage to hardware resulting from the use of Powertweak.

.SH EXAMPLES
.PP
`Powertweak' Finds all known PCI devices, and tunes them to optimal efficiency.

.SH SEE ALSO
.BR pciutils

.SH FILES
.BR /usr/share/powertweak/powertweak.config
This file stores the various configuration options that determine how Powertweak runs.

.SH AUTHOR
.PP
Powertweak-Linux is maintained by Dave Jones <dave@powertweak.com>
.PP
The Linux PCI Utilities are maintained by Martin Mares <mj@atrey.karlin.mff.cuni.cz>
