/* @(#)checkmount.c	1.8 98/05/31 Copyright 1991 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)checkmount.c	1.8 98/05/31 Copyright 1991 J. Schilling";
#endif
/*
 *	Check if disk or part of disk is mounted
 *
 *	Copyright (c) 1991 J. Schilling
 *
 *	XXX #ifdef HAVE_DKIO ist vorerst nur ein Hack
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <stdio.h>
#include <standard.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dsklabel.h>
#include <unixstd.h>
#include <device.h>
#ifdef	SVR4
#include <sys/mntent.h>
#include <sys/mnttab.h>
#else

#ifndef	__FreeBSD__
#include <mntent.h>
#ifndef	MNTTAB
#define	MNTTAB	MOUNTED
#endif

#endif
#define	mnt_special	mnt_fsname
#endif
#include "fmt.h"
#include "map.h"

extern	int	autoformat;

struct	dk_label *d_label;

EXPORT	BOOL	checkmount __PR((int, int, int, long, long));

EXPORT BOOL
checkmount(scsibus, target, lun, start, end)
	int	scsibus;
	int	target;
	int	lun;
	long	start;
	long	end;
{
#ifndef	HAVE_DKIO
	return (FALSE);
#else
	FILE	*mf;
	int	f;
	struct stat sb;
	struct dk_conf	conf;
	struct dk_map	*map;
	scgdrv	*scgmap;
#ifdef	SVR4
	struct	mnttab	_mnt;
	struct	mnttab	*mnt = &_mnt;
#else
	struct	mntent	*mnt;
#endif
	char	*dname;
	char	cdisk[128];
	char	rdisk[128];
	int	part;
	long	pstart;
	long	pend;
	BOOL	found = FALSE;

	dname = diskname(maptodisk(scsibus, target, lun));

	/*
	 * Open the mount table.
	 */
	mf = fopen(MNTTAB, "r");
	if (mf == NULL) {
		errmsgno(-1, "WARNING: Cannot open mount table.\n");
		return (found);
	}
#ifdef	SVR4
	while (getmntent(mf, mnt) != -1) {
#else
	while ((mnt = getmntent(mf)) != NULL) {
#endif

/*		printf("testing: %s\n", mnt->mnt_special);*/

		if (sscanf(mnt->mnt_special, "/dev/%s", cdisk) != 1)
			continue;

		strcatl(rdisk, "/dev/r", cdisk, 0);

		if ((f = open(rdisk, O_RDONLY|O_NDELAY)) < 0)
			continue;
		if (fstat(f, &sb) < 0) {
			close(f);
			continue;
		}
		if ((sb.st_mode & S_IFMT) != S_IFCHR) {
			close(f);
			continue;
		}
		if (ioctl(f, DKIOCGCONF, &conf) < 0) {
			close(f);
			continue;
		}
		close(f);

		scgmap = scg_getdrv(scsibus);
		if (scgmap->scg_cunit != conf.dkc_cnum ||
			 scgmap->scg_caddr != conf.dkc_addr ||
				!streql(scgmap->scg_cname, conf.dkc_cname))
			continue;

		if (conf.dkc_slave != target*8 + lun)
			continue;

		printf("disk: %s %s %s\n", dname, cdisk, mnt->mnt_special);

		if (start < 0) {
			found = TRUE;
			break;
		}
		part = PART(sb.st_rdev);
		map = &d_label->dkl_map[part];
		pstart = map->dkl_cylno*d_label->dkl_nhead*d_label->dkl_nsect;
		pend = pstart + map->dkl_nblk;
printf("pstart: %ld pend: %ld\n", pstart, pend);
		if ((start >= pend) || (end < pstart))
			continue;

		printf("disk part: %s %s %s\n", dname, cdisk, mnt->mnt_special);

		found = TRUE;
		break;
	}
	/*
	 * Close the mount table.
	 */
	(void) fclose(mf);

	if (autoformat && found)
		comerrno(-1, "Cannot format mounted disks.\n");

	return (found);
#endif
}
