/* # skkinput (Simple Kana-Kanji Input)
 * SkkInput.c --- Making SkkInputWidget.
 * This file is part of skkinput.
 * Copyright (C) 1997
 * Takashi SAKAMOTO (sakamoto@yajima.kuis.kyoto-u.ac.jp)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with skkinput; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <X11/Xos.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/IntrinsicP.h>
#include <X11/StringDefs.h>

#include "SkkInputP.h"
#include "config.h"

#define XtNgeometry		"geometry"
#define XtCGeometry		"Geometry"

#define offset(field) XtOffsetOf(SkkInputRec, skkinput.field)
#define goffset(field) XtOffsetOf(WidgetRec, core.field)

static XtResource resources[] = {
  /* Ȥ餢꥽*/
  { XtNwidth, XtCWidth, XtRDimension, sizeof(Dimension),
    goffset(width), XtRImmediate, (XtPointer) 400},
  { XtNheight, XtCHeight, XtRDimension, sizeof(Dimension),
    goffset(height), XtRImmediate, (XtPointer) 400},
  { XtNbackground, XtCBackground, XtRPixel, sizeof(Pixel),
    goffset(background_pixel), XtRString, XtDefaultBackground },
  /* ʬȤǺä꥽*/
  { XtNforeground, XtCForeground, XtRPixel, sizeof(Pixel),
    offset(puppixel), XtRString, XtDefaultForeground },
  { XtNreverseVideo, XtCReverseVideo, XtRBoolean, sizeof (Boolean),
    offset(reverse_video), XtRImmediate, (XtPointer) FALSE},
  { XtNfont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
    offset(fs_roman), XtRString, DEFAULT_ROMANFONT },
  { XtNkanjiFont, XtCFont, XtRFontStruct, sizeof(XFontStruct *),
    offset(fs_kanji), XtRString, DEFAULT_KANJIFONT },
  /* skkinput 뤬ĤѤ callback */
  { XtNendNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(endcallback), XtRCallback, (caddr_t)NULL },
  /* skkinput  client ʸѤ callback */
  { XtNfixNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(fixcallback), XtRCallback, (caddr_t)NULL },
  /* key event  client ֤Ѥ callback */
  { XtNkeybackNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(keybackcallback), XtRCallback, (caddr_t)NULL },
  /* ѴϻѤ callback */
  { XtNjhenkanNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(jhenkancallback), XtRCallback, (caddr_t)NULL },
  /* ѴλѤ callback */
  { XtNjhenkanendNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(jhenkanendcallback), XtRCallback, (caddr_t)NULL },
  /* 򥻡֤Ѥ callback */
  { XtNjsavejisyoNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(jsavejisyocallback), XtRCallback, (caddr_t)NULL },
  /* ñϿѤ callback */
  { XtNjtangotourokuNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(jtangotourokucallback), XtRCallback, (caddr_t)NULL },
  /* 񤫤ñ(purge)Ѥ callback */
  { XtNjtangosakujoNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(jtangosakujocallback), XtRCallback, (caddr_t)NULL },
  /* completion 򳫻Ϥ hit ꥹȤΤѤ * 
   * callback */
  { XtNjcompletionNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(jcompletioncallback), XtRCallback, (caddr_t)NULL },
  /* completion ˤäƽ褿ꥹȤäΤѤ callback */
  { XtNjcompletioncloseNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(jcompletionclosecallback), XtRCallback, (caddr_t)NULL },
  /* νե饰õ˻Ȥ callback */
  { XtNnotmodifiedNotify, XtCCallback, XtRCallback, sizeof(caddr_t), 
    offset(notmodifiedcallback), XtRCallback, (caddr_t)NULL },
  /* Shift-Space  skkinput Ĥ褦ˤ뤫ݤ*/
  { XtNcompatibleCloseSkkinputKey, XtCCompatibleCloseSkkinputKey,
    XtRBoolean, sizeof ( Boolean ),
    offset(compatible_close_skkinputkey), XtRImmediate, (XtPointer)TRUE },
  /* egg ߴ j-newline ݤ*/
  { XtNeggLikeNewline, XtCEggLikeNewline, XtRImmediate, sizeof (int),
    offset(egg_like_newline), XtRImmediate, (XtPointer) FALSE},
  /* chat-adapter-mode ݤ*/
  { XtNchatAdapter, XtCChatAdapter, XtRImmediate, sizeof (int),
    offset(chat_adapter), XtRImmediate, (XtPointer) FALSE},
  /* ĤΡ */
  { XtNwillBeDestroyed, XtCWillBeDestroyed, XtRImmediate, sizeof (int),
    offset(will_be_destroyed), XtRImmediate, (XtPointer) FALSE},
  /* date-ad */
  { XtNdateAd, XtCDateAd, XtRImmediate, sizeof (int),
    offset(date_ad), XtRImmediate, (XtPointer) FALSE},
  /* number-style */
  { XtNnumberStyle, XtCNumberStyle, XtRImmediate, sizeof (int),
    offset(number_style), XtRImmediate, (XtPointer) FALSE },
  /* delte_implies_kautei */
  { XtNdeleteImpliesKakutei, XtCDeleteImpliesKakutei,
    XtRImmediate, sizeof (int),
    offset(delete_implies_kakutei), XtRImmediate, (XtPointer) TRUE },
  { XtNuseNumericConversion, XtCUseNumericConversion,
    XtRImmediate, sizeof (int),
    offset(use_numeric_conversion), XtRImmediate, (XtPointer) TRUE },
  { XtNgeometry, XtCGeometry, XtRString, sizeof(char *),
    offset(geo_metry), 	XtRString, (XtPointer) NULL },
  { XtNjisyoDirty, XtCJisyoDirty, XtRImmediate, sizeof (int),
    offset(jisyo_dirty), XtRImmediate, (XtPointer) FALSE },
  { XtNkeySkkMap, XtCKeySkkMap, XtRImmediate, sizeof( int * ),
    offset(skkmap), XtRImmediate, ( XtPointer )NULL },
  { XtNkeyAbbrevMap, XtCKeyAbbrevMap, XtRImmediate, sizeof( int * ),
    offset(abbrevmap), XtRImmediate, ( XtPointer )NULL },
  { XtNkeyTwoMap, XtCKeyTwoMap, XtRImmediate,
    sizeof( struct skkinputTwokeys * ),
    offset( twokeymap ), XtRImmediate, ( XtPointer )NULL },
  { XtNinputVector, XtCInputVector, XtRImmediate,
    sizeof( unsigned char **),
    offset( skk_input_vector ), XtRImmediate, ( XtPointer )NULL },
  { XtNzenkakuVector, XtCZenkakuVector, XtRImmediate,
    sizeof( unsigned char **),
    offset( skk_zenkaku_vector ), XtRImmediate, ( XtPointer )NULL },
  { XtNromKanaRuleList, XtCRomKanaRuleList, XtRImmediate,
    sizeof( struct skk_rom_kana_rule * ),
    offset( rom_kana_rule_list ), XtRImmediate, ( XtPointer )NULL },
  { XtNtabWidth,     XtCTabWidth, XtRImmediate, sizeof (int),
    offset( tab_width ), XtRImmediate, (XtPointer) 8 },
  { XtNinitPosition, XtCInitPosition, XtRImmediate, sizeof (int),
    offset( iposflag ), XtRImmediate, (XtPointer) TRUE },
} ;

#undef offset
#undef goffset

static void Initialize
( Widget greq, Widget gnew, ArgList args, Cardinal *num_args ) ;
static void Realize
( Widget gw, XtValueMask *valueMask, XSetWindowAttributes *attrs ) ;
static void Redisplay
( Widget gw, XEvent *event, Region region ) ;
static void Destroy( Widget gw ) ;
static Boolean SetValues
( Widget current, Widget request, Widget new,
  ArgList args, Cardinal *num_args ) ;
static void KeyDownEventHandler
( Widget w, XEvent *event, String *params, Cardinal *num_params ) ;
static void ShiftSpaceKeyEventHandler
( Widget w, XEvent *event, String *params, Cardinal *num_params ) ;
static void ControlSpaceKeyEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params ) ;
static void FocusInEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params ) ;
static void FocusOutEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params ) ;
static void WMMessageHandler
( Widget w, XEvent *event, String *params, Cardinal *num_params ) ;

/*
 * ȤƤؿΥץȥ
 *-----
 * δؿ SkkInputP.h  include Ƥ륽ˤ롣
 */
/* skkkeymap.c */
static int do_function_by_reading_character
( Widget gw, struct SKKInputNode *node ) ;
/* skkwin.c */
static void skkinput_RedrawScreen( Widget gw ) ;
static void skkinput_DrawScreen( Widget gw ) ;
static void skkinput_ClearMinibuffer( Widget gw ) ;
/* skkmbuf.c */
static struct SKKInputNode *skkinput_AllocateMinibuffer( void ) ;
static void free_Minibuffer
( Widget gw, struct SKKInputNode *node ) ;

/*
 * Хѿ
 */
XtActionsRec skkinputActionsTable [] = {
  { "ShiftSpaceKeyEventHandler",   ShiftSpaceKeyEventHandler },
  { "ControlSpaceKeyEventHandler", ControlSpaceKeyEventHandler },
  { "KeyDownEventHandler",	   KeyDownEventHandler },
  { "FocusInEventHandler",	   FocusInEventHandler },
  { "FocusOutEventHandler",	   FocusOutEventHandler },
  { "WMMessageHandler",		   WMMessageHandler },
};

char defaultSkkinputTranslations[] =  
"Shift<Key>space:         ShiftSpaceKeyEventHandler()\n\
 Ctrl<Key>space:	  ControlSpaceKeyEventHandler()\n\
 <Key>:                   KeyDownEventHandler()\n\
 <FocusIn>:               FocusInEventHandler()\n\
 <FocusOut>:              FocusOutEventHandler()\n\
 <Message>WM_PROTOCOLS:   WMMessageHandler()\n" ;

SkkInputClassRec skkinputClassRec = {
    { /* core fields */
    /* superclass		*/	&widgetClassRec,
    /* class_name		*/	"SkkInput",
    /* size			*/	sizeof(SkkInputRec),
    /* class_initialize		*/	NULL,
    /* class_part_initialize	*/	NULL,
    /* class_inited		*/	FALSE,
    /* initialize		*/	Initialize,
    /* initialize_hook		*/	NULL,
    /* realize			*/	Realize,
    /* actions			*/	skkinputActionsTable,
    /* num_actions		*/	XtNumber( skkinputActionsTable ),
    /* resources		*/	resources,
    /* num_resources		*/	XtNumber( resources ),
    /* xrm_class		*/	NULLQUARK,
    /* compress_motion		*/	TRUE,
    /* compress_exposure	*/	TRUE,
    /* compress_enterleave	*/	TRUE,
    /* visible_interest		*/	FALSE,
    /* destroy			*/	Destroy,
    /* resize			*/	NULL,
    /* expose			*/	Redisplay,
    /* set_values		*/	SetValues,
    /* set_values_hook		*/	NULL,
    /* set_values_almost	*/	XtInheritSetValuesAlmost,
    /* get_values_hook		*/	NULL,
    /* accept_focus		*/	NULL,
    /* version			*/	XtVersion,
    /* callback_private		*/	NULL,
    /* tm_table			*/	defaultSkkinputTranslations,
    /* query_geometry		*/	XtInheritQueryGeometry,
    }
};

WidgetClass skkinputWidgetClass = ( WidgetClass )&skkinputClassRec ;

static void Initialize 
( Widget greq, Widget gnew, ArgList args, Cardinal *num_args )
{
  SkkInputWidget w = ( SkkInputWidget )gnew ;
  struct SKKInputNode *node ;
  XtGCMask	valuemask ;
  XGCValues	myXGCV ;
  int roman_width, roman_ascent, roman_height ;
  int kanji_width, kanji_ascent, kanji_height ;
  int fontwidth_sub1, fontwidth_sub2 ;
  
#if 0
  if( w->skkinput.reverse_video ){
    Pixel fg = w->skkinput.puppixel ;
    Pixel bg = w->core.background_pixel ;

    w->skkinput.puppixel = bg ;
    w->core.background_pixel = fg ;
  }
#endif

  /* եȤξɤ߽ФƤ*/
  roman_width  = w->skkinput.fs_roman->max_bounds.width ;
  roman_ascent = w->skkinput.fs_roman->max_bounds.ascent ;
  roman_height = roman_ascent + w->skkinput.fs_roman->max_bounds.descent ;
  kanji_width  = w->skkinput.fs_kanji->max_bounds.width ;
  kanji_ascent = w->skkinput.fs_kanji->max_bounds.ascent ;
  kanji_height = kanji_ascent + w->skkinput.fs_kanji->max_bounds.descent ;

  fontwidth_sub1 = ( roman_width << 1 ) ;
  fontwidth_sub2 = ( kanji_width >> 1 ) ;
  /* ߤΥեȤ礭δطѤʤΤ⤷ʤ*/
  if( fontwidth_sub1 != kanji_width ){
    /* ѿܤΤ礭 */
    if( fontwidth_sub1 > kanji_width ){
      kanji_width = fontwidth_sub1 ;
    } else {
      /* ѿܤΤϴϾ餷*/
      roman_width = fontwidth_sub2 ;
    }
  }
  w->skkinput.roman_width = roman_width ;
  w->skkinput.kanji_width = kanji_width ;

  w->skkinput.font_height = ( ( kanji_height > roman_height )?
    kanji_height : roman_height ) + 1 ;
  w->skkinput.font_ascent = ( ( kanji_ascent > roman_ascent )?
    kanji_ascent : roman_ascent ) + 1 ;

  /* ե٥åɽΤ GC 롣*/
  myXGCV.foreground = w->skkinput.puppixel ;
  myXGCV.background = w->core.background_pixel ;
  myXGCV.font       = w->skkinput.fs_roman->fid ;
  valuemask = GCForeground | GCBackground | GCFont ;
  w->skkinput.roman_ngc = XtGetGC( gnew, valuemask, &myXGCV ) ;

  myXGCV.foreground = w->core.background_pixel ;
  myXGCV.background = w->skkinput.puppixel ;
  myXGCV.font       = w->skkinput.fs_roman->fid ;
  valuemask = GCForeground | GCBackground | GCFont ;
  w->skkinput.roman_rgc = XtGetGC( gnew, valuemask, &myXGCV ) ;

  /* ʸ(Ҳ̾ʿ̾)Τ GC 롣*/
  myXGCV.foreground = w->skkinput.puppixel ;
  myXGCV.background = w->core.background_pixel ;
  myXGCV.font       = w->skkinput.fs_kanji->fid ;
  valuemask = GCForeground | GCBackground | GCFont ;
  w->skkinput.kanji_ngc = XtGetGC( gnew, valuemask, &myXGCV ) ;

  myXGCV.foreground = w->core.background_pixel ;
  myXGCV.background = w->skkinput.puppixel ;
  myXGCV.font       = w->skkinput.fs_kanji->fid ;
  valuemask = GCForeground | GCBackground | GCFont ;
  w->skkinput.kanji_rgc = XtGetGC( gnew, valuemask, &myXGCV ) ;

  /* ¾ν*/
  w->skkinput.pwrite_string[ 0 ] = '\0' ;
  w->skkinput.pmtextbuffer[ 0 ]  = '\0' ;
  w->skkinput.cutbuffer[ 0 ]  = '\0' ;
  w->skkinput.keybuf_use    = 0 ;
  w->skkinput.keybuf[ 0 ]   = '\0' ;
  w->skkinput.prev_modeline = 0 ;

  /* ҥȥϥꥢƤɸνɬפǤĤޤϰ */
  /* ⵯ줿ȤʤƤʤΤǴǤ롣*/
  if( w->skkinput.iposflag ){
    w->skkinput.historybuffer[ 0 ] = '\0' ;
    w->skkinput.hist_start = w->skkinput.hist_end = 0 ;
    w->skkinput.hist_cur   = -1 ;
  } else {
    w->skkinput.hist_cur   = -1 ;
  }
  /* ԽѤΥХåեγݡ*/
  node = skkinput_AllocateMinibuffer() ;
  node->cur_exist = True ;
  w->skkinput.topbuffer  = node ;
  w->skkinput.lastbuffer = node ;

  w->skkinput.prev_jisyo_dirty  = w->skkinput.jisyo_dirty = 0 ;
  w->skkinput.prev_chat_adapter = w->skkinput.chat_adapter ;
  w->skkinput.prev_eggnl        = w->skkinput.egg_like_newline ;
  w->skkinput.will_be_destroyed = False ;

  /* ޤFocus ϺǽϳƤȻפ衣*/
  w->skkinput.is_focus = False ;
  return ;
}

static void Realize
( Widget gw, XtValueMask *valueMask, XSetWindowAttributes *attrs )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  unsigned int winwidth, winheight, pr ;
  int xpos, ypos, cols, rows ;
  XSizeHints sizehints ;
  Display *display = XtDisplay( gw ) ;

  xpos = 1 ; 
  ypos = 1 ;
  winwidth = 80 ;
  winheight = 3 ;
  /* ȥβϡ*/
  pr = XParseGeometry ( w->skkinput.geo_metry,
			&xpos, &ypos, &winwidth, &winheight ) ;
  /* ȥ꤫֤ȴФ*/
  if( ( pr & XValue ) && ( XNegative & pr ) ) {
    xpos += DisplayWidth
      ( display, DefaultScreen( display ) )
      - ( w->core.parent->core.border_width * 2 ) ;
  }
  if( ( pr & YValue ) && ( YNegative & pr ) ){
    ypos += DisplayHeight
      ( display, DefaultScreen( display ) )
      - ( w->core.parent->core.border_width * 2 ) ;
  }
  /* ĲʸޤɽΡ */
  cols = ( ( WidthValue & pr  ) && winwidth > 0 )? winwidth : 80 ;
  rows = ( ( HeightValue & pr ) && winheight > 0 )? winheight : 3 ;
  /* ɥΥꥵ¾ꡣ*/
  sizehints.base_width = w->core.border_width * 2 ;
  sizehints.base_height= w->core.border_width * 2 ;
  sizehints.width_inc  = w->skkinput.roman_width ;
  sizehints.height_inc = w->skkinput.font_height ;
  sizehints.min_width  = w->skkinput.roman_width * 2 ;
  sizehints.min_height = w->skkinput.font_height * 3 ;
  sizehints.flags      = ( PBaseSize | PMinSize | PResizeInc ) ;

  /* ɸνġ*/
  if( w->skkinput.iposflag ){
    /* ɥ礭λꡣ*/
    sizehints.width  = winwidth ;
    sizehints.height = winheight ;
    if( ( WidthValue & pr ) || ( HeightValue & pr ) ) {
      sizehints.flags |= USSize ;
    } else {
      sizehints.flags |= PSize ;
    }
    /* Window 礭롣*/
    winwidth  = w->core.border_width * 2 + cols * w->skkinput.roman_width ;
    winheight = w->core.border_width * 2 + rows * w->skkinput.font_height ;

    if( ( pr & XValue ) || ( pr & YValue ) ){
      sizehints.flags |= USSize | USPosition ;
      sizehints.flags |= PWinGravity ;
    }
    switch( pr & ( XNegative | YNegative ) ){
    case 0 :
      /*sizehints.win_gravity = NorthWestGravity ;*/
      sizehints.x = xpos ;
      sizehints.y = ypos ;
      break ;
    case XNegative :
      /*sizehints.win_gravity = NorthEastGravity ;*/
      sizehints.x = xpos - winwidth ;
      sizehints.y = ypos ;
      break ;
    case YNegative :
      /*sizehints.win_gravity = SouthWestGravity ;*/
      sizehints.x = xpos ;
      sizehints.y = ypos - winheight ;
      break ;
    default:
      /*sizehints.win_gravity = SouthEastGravity ;*/
      sizehints.x = xpos - winwidth ;
      sizehints.y = ypos - winheight ;
      break ;
    }
  }
  if( w->skkinput.iposflag ){
    /* Ƥ˥ꥵäƤ롩 */
    (void) XtMakeResizeRequest
      ( (Widget)w->core.parent,
	(Dimension)winwidth, (Dimension)winheight,
	&w->core.parent->core.width,
	&w->core.parent->core.height ) ;
    /* ֤ꤹ롣*/
    if( sizehints.flags & USPosition ){
      XtMoveWidget( w->core.parent, sizehints.x, sizehints.y ) ;
      sizehints.flags &= ~USPosition ;
    }
    /* Window Manager ˥ҥȤäƤ롣*/
    XSetWMNormalHints
      ( XtDisplay( gw ), w->core.parent->core.window, &sizehints ) ;
  }
  XSync( display, False ) ;
  /* Window 롣*/
  *valueMask |= CWBitGravity ; 
  attrs->bit_gravity = ForgetGravity ;
  XtCreateWindow
    ( gw, (unsigned)InputOutput, (Visual *)CopyFromParent,
      *valueMask, attrs ) ;
  w->skkinput.iposflag = False ;
  return ;
}

/*
 * SIW  XtDestroyWidget 򤫤˸ƤӽФؿ
 *-----
 * SIW νλ·äƤ롣GC Ƥ顢malloc Ƥ
 * Ƥ롣
 */
static void Destroy( Widget gw )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  struct SKKInputNode *node, *pNode ;
  /*
   * XFreeFont( XtDisplay( gw ), w->skkinput.fs_kanji ) ;
   * XFreeFont( XtDisplay( gw ), w->skkinput.fs_roman ) ;
   * ɤ顢Widget ˳ݤƤ櫓ʤߤʤΤǡ
   * ȤϤޤߤ
   */
  /* Event ʤ֤ˤƤƤġ*/
  XSelectInput( XtDisplay( gw ), XtWindow( gw ), NoEventMask ) ;
  /* Event Queue եå夷Ƥ*/
  XSync( XtDisplay( gw ), True ) ;

  XtReleaseGC(gw, w->skkinput.roman_ngc ) ;
  XtReleaseGC(gw, w->skkinput.roman_rgc ) ;
  XtReleaseGC(gw, w->skkinput.kanji_ngc ) ;
  XtReleaseGC(gw, w->skkinput.kanji_rgc ) ;

  node = w->skkinput.lastbuffer ;
  while( node != NULL ){
    pNode = node->parentbuffer ;
    free_Minibuffer( gw, node ) ;
    node  = pNode ;
  }
  XtCallCallbacks( gw, XtNendNotify, NULL ) ;
  return ;
}

/*
 * ̤褹ؿ
 */
static void Redisplay( Widget gw, XEvent *event, Region region )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  /* ϲΥߥ󥰤Ǵְä Widget κ褬Ƥ롣*/
  if( w->skkinput.topbuffer == NULL || w->core.being_destroyed ){
#if 1
    fprintf( stderr, "Illegal Widget Exposure Event.\n" ) ;
#endif
    return ;
  }
  skkinput_RedrawScreen( gw ) ;
  XFlush( XtDisplay( gw ) ) ;
  return ;
}

static Boolean SetValues
( Widget current, Widget request, Widget new,
  ArgList args, Cardinal *num_args )
{
  SkkInputWidget curw = ( SkkInputWidget )current ;
  SkkInputWidget neww = ( SkkInputWidget )new ;

  /* 񤬽Ƥ顢ľ¹Ԥ롣*/
  if( curw->skkinput.jisyo_dirty != neww->skkinput.jisyo_dirty ){
    curw->skkinput.jisyo_dirty = neww->skkinput.jisyo_dirty ;
    return TRUE ;
  }
  return( FALSE ) ;
}

enum {
  SIW_DESTROYED = -1, SIW_PROCESSING = 0,
} ;

/*
 * 줿Ȥ٥ȤνԤؿ
 *----
 * Υ줿ȤԲǽʾ礬Τǡ줿Ȥ
 * Ǿ꤯ư褦˺ʤФʤʤ
 */
static void KeyDownEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  char inpstr[ STRBUFSIZE ] ;
  KeySym key ;
  struct SKKInputNode *node ;

  /* ٥Ȥ򵭲Ƥ*/
  w->skkinput.xevent = *xevent ;

  /* ߥ˥Хåե¸ߤƤΤʤСΰֺǸΤΤ򤹤롣*/
  node = w->skkinput.lastbuffer ;
  if( !node->cur_exist )
    node = w->skkinput.topbuffer ;

  /* ʸХåեν*/
  inpstr[ 0 ] = '\0' ;
  /* ʸ*/
  XLookupString( &( xevent->xkey ), inpstr, STRBUFSIZE, &key, NULL ) ;
  
  /* Ϥ줿ʸϰ̣ʸʤΤǤ */
  if( inpstr[ 0 ] != '\0' ){
    w->skkinput.keybuf[ w->skkinput.keybuf_use ++ ] = inpstr[ 0 ] ;
    /* ߥ˥Хåե¸ߤѤƤν*/
    if( do_function_by_reading_character( gw, node ) )
      return ;
  }
  skkinput_DrawScreen( gw ) ;
  XFlush( XtDisplay( gw ) ) ;
  return ;
}

/*
 * C-@ Ȥ̤ 0 ˤʤäƤޤ褦ᤷϤ虜虜ؿ
 */
static void ControlSpaceKeyEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  struct SKKInputNode *node ;

  /* ٥Ȥ򵭲Ƥ*/
  w->skkinput.xevent = *xevent ;

  /* ߥ˥Хåե¸ߤƤΤʤСΰֺǸΤΤ򤹤롣*/
  node = w->skkinput.lastbuffer ;
  if( !node->cur_exist )
    node = w->skkinput.topbuffer ;

  /* Ϥ줿ʸϰ̣ʸʤΤǤ */
  w->skkinput.keybuf[ w->skkinput.keybuf_use ++ ] = 0x00 ;
  /* ߥ˥Хåե¸ߤѤƤν*/
  if( do_function_by_reading_character( gw, node ) )
    return ;
  skkinput_DrawScreen( gw ) ;
  XFlush( XtDisplay( gw ) ) ;
  return ;
}

static void ShiftSpaceKeyEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  if( w->skkinput.compatible_close_skkinputkey ){
    /* Widget ˲Ĥƽλ롣*/
    w->skkinput.will_be_destroyed = True ;
  } else {
    /* ǤʤС̾ν롼Ƥ֡*/
    KeyDownEventHandler( gw, xevent, params, num_params ) ;
  }
  return ;
}

/*
 * ե줿νԤؿ
 */
static void FocusOutEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  /* ե줿Ȥã줿Τǡ򵭲Ƥ*/
  w->skkinput.is_focus = False ;
  /* ̤νĥηѲΤǡ*/
  skkinput_DrawScreen( gw ) ;
  return ;
}

/*
 * ե蘆줿νԤؿ
 */
static void FocusInEventHandler
( Widget gw, XEvent *xevent, String *params, Cardinal *num_params )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  /* ե줿Ȥã줿Τǡ򵭲Ƥ*/
  w->skkinput.is_focus = True ;
  /* ̤νĥηѲΤǡ*/
  skkinput_DrawScreen( gw ) ;
  return ;
}

/*
 * Window Manager 齪λ[x]ܥ򲡤줿Ȥåή
 * 褿νԤؿ
 */
static void WMMessageHandler
( Widget gw, XEvent *event, String *params, Cardinal *num_params )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  /* Widget ˲ƽ򽪤롣*/
  w->skkinput.will_be_destroyed = True ;
  return ;
}

/*
 * 򲡤᤹ΤѤؿ
 */
static void SKIW_SendbackKeyPress( Widget gw )
{
  SkkInputWidget w = ( SkkInputWidget )gw ;
  /* ХåϿƤʤнԤ*/
  if( w->skkinput.keybackcallback != NULL ){
    Window to_window, subwindow ;
    /* ࡩ ΤФƤġ*/
    to_window = w->skkinput.xevent.xkey.window ;
    subwindow = w->skkinput.xevent.xkey.subwindow ;
    /* ٥Ȥ򤯤äĤϤ*/
    XtCallCallbacks( gw, XtNkeybackNotify, &w->skkinput.xevent ) ;
    /* ᤷƤ롣*/
    w->skkinput.xevent.xkey.window    = to_window ;
    w->skkinput.xevent.xkey.subwindow = subwindow ;
  }
  return ;
}

/*
 * ʲΥեϡSkkInputWidget ΥΰǤ롣
 */
#include "skkmarker.c"
#include "skkel.c"
#include "skkkeymap.c"
#include "skkmbuf.c"
#include "skkwin.c"
