/* Uptimed 0.03 (uprecords)
   (c) Copyright 1998 Rob Kaper (cap@capsi.com)
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <unistd.h>
#include <sys/utsname.h>

#define	BOLD	"[1m"
#define	PLAIN	"[0m"

FILE	*f;
char	str[256], sys[32];
time_t	utime, btime, last, first, now, tmp;

int main(int, char**);
int displayrecords();
char *time2unix(time_t);
int readbootid();
int readsysinfo();

int main(int argc, char **argv)
{
	readbootid();
	readsysinfo();

	if (argv[1] && !strcasecmp(argv[1], "-f")) {  while(1) { displayrecords(1); sleep(5); } }
	else displayrecords(0);

	return 0;
}

int displayrecords(int cls)
{
	time_t	btime_arr[10], utime_arr[10];
	char	sys_arr[10][32];
	int	i=0, currentdone=0;

	now=time(0);

	f=fopen("/proc/uptime", "r");
	if (!f) { printf ("uprecords: error opening /proc file!\n"); return -1; }
	else
	{
		fgets(str, sizeof(str), f);
		if (str) utime=atoi(str);
		else { printf ("uprecords: error reading /proc file!\n"); return -1; }
		fclose(f);
	}
	
	f=fopen("/etc/uptimed.log", "r");
	if (!f)
	{
		printf("uprecords: cannot read log file, run uptimed as root first!\n");
		exit(-1);
	}

	for (i=0;i<10;i++)
	{
		fgets(str, sizeof(str), f);
		if (str && strstr(str, ":"))
		{
			utime_arr[i]=atoi(strtok(str, ":"));
			btime_arr[i]=atoi(strtok(NULL, ":"));
			strcpy(sys_arr[i], strtok(NULL, "\n"));
		}
	}
	fclose(f);

	if (cls) printf("[H[J");
	printf("   %3s %20s | %-18s %30s\n", "#", "Uptime", "System", "Boot up ");
	printf("----------------------------+-------------------------------------------------\n");
	for (i=0;i<10;i++)
	{
		if (btime_arr[i]!=0)
		{
			if (btime_arr[i]==btime)
			{
				printf(BOLD "-> %3d %20s " PLAIN "|" BOLD " %-18s %30s" PLAIN, i+1, time2unix(utime), sys_arr[i], ctime(&btime_arr[i]));
				currentdone++;
				if (i!=0) last=utime_arr[i-1];
				else first=0;
			}
			else
			{
				printf("   %3d %20s | %-18s %30s", i+1, time2unix(utime_arr[i]), sys_arr[i], ctime(&btime_arr[i]));
				if (i==0) first=utime_arr[i];
			}
		}
	}

	if (!currentdone)
	{
		printf("----------------------------+-------------------------------------------------\n");
		printf(BOLD "-> %3s %20s " PLAIN "|" BOLD " %-18s %30s" PLAIN, "now", time2unix(utime), sys, ctime(&btime));
		last=utime_arr[i-1];
	}

	printf("----------------------------+-------------------------------------------------\n");
	if (last && last!=first) { tmp=now+last-utime; printf("1up in %20s | %-18s %30s", time2unix(last-utime), "", ctime(&tmp)); }
	if (first) { tmp=now+first-utime; printf("no1 in %20s | %-18s %30s", time2unix(first-utime), "", ctime(&tmp)); }

	return 0;
}

char *time2unix (time_t t)
{
	static char	timebuf[20] = "";
	int		sec, min, hour, day;

	sec = t % 60;
	t /= 60;
	min = t % 60;
	t /= 60;
	hour = t % 24;
	t /= 24;
	day = t;

	sprintf(timebuf,"%d %s, %.2d:%.2d:%.2d", day, (day == 1 ? "day " : "days"), hour, min, sec); 
	return timebuf;
}

int readbootid()
{
	f=fopen("/var/run/uptimed.bootid", "r");
	if (!f) { printf("uprecords: cannot read boot id, exiting!\n");  exit(-1); }
	else
	{
		fgets(str, sizeof(str), f);
		if (str) btime=atoi(str);
		else { printf("uprecords: cannot read boot id, exiting!\n");  exit(-1); }
		fclose(f);
	}
	return 0;
}

int readsysinfo()
{
	struct utsname temp_uname;

	if (!uname(&temp_uname)) sprintf(sys, "%s %s", temp_uname.sysname, temp_uname.release);
	else sprintf(sys, "unknown");

	return 0;
}
