#include <stdio.h>
#include <unistd.h>
#include <signal.h>
#include <vslib.h>

#include "ftplib.h"

#define VER     "2.2"

#define MAXLINE 2048
#define MAXMSGLEN 77

int ftpopen = 0;
int quiet = 0;
char   cmd = 0; // command
String host; // host name
String user; // user name
String pass; // password
String tmpf; // temp file
String arcf; // archive file
PSZCluster  list;
PSZCluster  files;

///////////////////////////////////////////////////////////////////////////
//
// reads tring from the console
//
int gets( String &str )
{
  str = "";
  int ch = getchar();
  while( ch != 27 && ch != 13 && ch != 10 )
    {
    StrAddCh( str, ch );
    ch = getchar();
    };
  if ( ch == 27 ) str = "";
};

///////////////////////////////////////////////////////////////////////////
//
//
//
void say( const char* msg, int dontcr = 0 )
{
  if (quiet && quiet != 2) return;
  if (quiet == 2) dontcr = 1;
  String str = msg;
  str = "ftparc: " + str;
  StrSLeft( str,  MAXMSGLEN );
  StrPad  ( str, -MAXMSGLEN );
  str += "\r";
  if (!dontcr) str += "\n";
  fprintf( stderr, "%s", str.asis() );
  fflush( stderr );
};

///////////////////////////////////////////////////////////////////////////
//
//
//
int faOpen()
{
  PSZCluster tmplist;
  String msg;
  tmplist.create( 3, 3 );
  if( LoadFromFile( arcf, &tmplist, MAXLINE ) || tmplist.count() < 3 )
    {
    msg = arcf;
    msg = "error: cannot read file: " + msg + ", or it contains wrong data";
    say( msg );
    return 1;
    }
  host = tmplist[0];
  user = tmplist[1];
  pass = tmplist[2];
  if (user == "?")
    {
    say( " username? ( enter to confirm, esc+enter to cancel )");
    gets( user );
    }
  if (user == "-" || user == "") user = "anonymous";
  if (pass == "?")
    {
    say( " password? ( enter to confirm, esc+enter to cancel )");
    gets( pass );
    }
  if (pass == "-" || pass == "")
    {
    pass = "";
    if (getenv("USER"))
      pass += getenv("HOME");
    else
      pass += "anonymous";
    pass += "@";
    if (getenv("HOSTNAME"))
      pass += getenv("HOSTNAME");
    else
      pass += "unknown.org";
    msg = pass;
    };
  if (msg == "") msg = "(password)";
  msg = "arcf: " + arcf + ",  host: " + host + ",  user: " + user + ",  pass: " + msg + " ";
  say( msg );

  if(ftpOpen( host ) == 0)
    {
    msg = "error: open failed: ";
    msg += ftplib_lastresp;
    return 2;
    }
  ftpopen = 1;
  if(ftpLogin( user, pass ) == 0)
    {
    msg = "error: login failed: ";
    msg += ftplib_lastresp;
    return 3;
    }
  return 0;
};

///////////////////////////////////////////////////////////////////////////
//
//
//
int faRList( const char* path ) // recursive dir
{
  PSZCluster tmplist;
  String str;
  tmplist.create( 16, 16 );
  ftpDir( tmpf, path );
  LoadFromFile( tmpf, &tmplist, MAXLINE );
  int z;
  for( z = 0; z < tmplist.count(); z++ )
    {
    str = tmplist[z];
    StrCut( str, "\n\r" );
    if ( StrFind( str, "total " ) == 0 ) continue; // hack
    int i = StrRFind( str, ' ' );
    if ( i == -1 ) continue; // consider it error
    if ( str[0] == 'd' )
      { // directory
      StrTrimL( str, i+1 );
      if ( str == "." || str == ".." ) continue;
      StrInsert( str, 0, path );
      str += "/";
      faRList( str );
      }
    else
      { // file
      StrInsert( str, i+1, path );
      list.add( str );
      }
    };
  str = list.count();
  str = "entries read: " + str + " (" + path + ")";
  say( str, 1 );
};

int faList( const char* path )
{
  faRList( "./" );
  say( "list done" );
  unlink( tmpf );
  int z;
  for ( z = 0; z < list.count(); z++ )
    printf( "%s\n", (const char*)(list[z]) );
};

///////////////////////////////////////////////////////////////////////////
//
//
//
int faExtract( int fullpath )
{
  char path[MAX_PATH];
  int z;
  for ( z = 0; z < files.count(); z++ )
    {
    String str = files[z];
    String str2;
    if (StrFind( str, '/' ) == -1) str = "./" + str;
    path[0] = 0;
    FilePath( str, path );
    MakePath( path );
    str2 = str;
    if ( fullpath == 0 ) StrTrimL( str2, StrRFind( str2, '/' ) + 1 );
    if ( fullpath == 2 )
      ftpGet( NULL, str, 'I' ); // pipe to screen
    else
      ftpGet( str2, str, 'I' );
    };
  return 0;
};

///////////////////////////////////////////////////////////////////////////
//
//
//
int faAdd()
{
  return 0;
};

///////////////////////////////////////////////////////////////////////////
//
//
//
void faSig( int sig )
{
  if (ftpopen) ftpQuit();
  exit(100);
};

///////////////////////////////////////////////////////////////////////////
//
//
//
extern char ftplib_version[];
void credits()
{
  if (quiet) return;
  fprintf( stderr, "ftparc " VER " (c) Vladi Belperchinov-Shabanski <cade@biscom.net> 1999 (" __DATE__ ")\n" );
  fprintf( stderr, "%s\n", ftplib_version );
};

void usage()
{
  credits();
  printf(
  "\n"
  "FTParc is archive-like interface to FTP sites\n"
  "usage: ftparc command switches ftp_arc_file filenames @listfile\n"
  "command:\n"
  "   -l   -- list archive (recursively, it could be slow on large sites)\n"
  "   -x   -- extract (download) file(s) with full path\n"
  "   -e   -- extract (download) file(s) without path\n"
  "   -p   -- extract (download) and print file to console\n"
  "   -a   -- add (upload) file(s)\n"
  "   -h   -- help (this screen)\n"
  "switches:\n"
  "   -q   -- quiet mode\n"
  "   -Q   -- one line quiet mode (used by VFU)\n"
  "ftp_arc_file syntax:\n"
  "   it is recommended this file to have `.ftp' extension, content has to be:\n"
  "   line 1 -- host name\n"
  "   line 2 -- user name ( use `-' for `anonymous' or `?' to ask )\n"
  "   line 3 -- password ( use `-' for `loginid@localhost' or use `?' to ask )\n"
  "\n"
  );
  if (ftpopen) ftpQuit();
  exit(200);
};

///////////////////////////////////////////////////////////////////////////
//
//
//
int main( int argc, char* argv[] )
{
  ftpInit();
  signal( SIGINT , faSig );
  signal( SIGHUP , faSig );
  signal( SIGTERM, faSig );
  signal( SIGQUIT, faSig );

  list.create( 16, 16 );
  files.create( 16, 16 );
  tmpf = tmpnam( NULL );
  if (tmpf == "") tmpf = ".ftparc.tmp";

  GETOPT( "lxepahqQ" )
    {
    switch(optc)
      {
      case 'l' : cmd = optc; break;
      case 'e' : cmd = optc; break;
      case 'x' : cmd = optc; break;
      case 'a' : cmd = optc; break;
      case 'p' : cmd = optc; break;
      case 'q' : quiet = 1; break;
      case 'Q' : quiet = 2; break;
      case '+' :
                 if (arcf == "")
                   arcf = optarg;
                 else
                 if (optarg[0] == '@')
                   LoadFromFile( optarg+1, &files, MAXLINE );
                 else
                   files.add( optarg );
                 break;
      case 'h' :
      default  :
                 usage(); break;
      }
    };

  credits();

  if ( arcf != "" )
    {
    arcf += ".ftp";
    StrReplace( arcf, ".ftp.ftp", ".ftp" );
    };
  if(faOpen() == 0)
    switch(cmd)
      {
      case 'l' : faList( "./" ); break;
      case 'e' : faExtract( 0 ); break;
      case 'x' : faExtract( 1 ); break;
      case 'p' : faExtract( 2 ); break;
      case 'a' : faAdd(); break;
      default  : usage(); break;
      }
  say( "end" );
  if (ftpopen) ftpQuit();
  return 0;
};



