#include "arena.h"
#include "arenaXdefaults_types.h"
#include "defs.h"

#include <X11/Xlib.h>
#include <X11/Xresource.h>


/*
 * Command line options description structure.
 */
XrmOptionDescRec ArenaResOptDesc[] =
{
 {"-cache",    "cache",    XrmoptionSepArg, NULL},
 {"-editor",   "editor",   XrmoptionSepArg, NULL},
 {"-gamma",    "gamma",    XrmoptionSepArg, NULL},
 {"-geometry", "geometry", XrmoptionSepArg, "+0+0"},
 {"-icon",     "icon",     XrmoptionSepArg, NULL},
 {"-lens",     "lens",     XrmoptionSepArg, NULL},
 {"-printer",  "printer",  XrmoptionSepArg, NULL}
};
int ArenaResOptDescRecNum = sizeof(ArenaResOptDesc)/sizeof(ArenaResOptDesc[0]);


/*
 * Font defaults.
 */
ArenaFontsStruct ArenaFonts[] =
{
 { IDX_H1FONT,       "h1font",         { { H1FONT,       "variable"},
					 { H1FONTL,      "vg-20"},
					 { H1FONTG,      "vg-20"}}},
 { IDX_H2FONT,       "h2font",         { { H2FONT,       "variable"},
					 { H2FONTL,      "fg-16"},
					 { H2FONTG,      "fg-16"}}},
 { IDX_H3FONT,       "h3font",         { { H3FONT,       "variable"},
					 { H3FONTL,      "variable"},
					 { H3FONTG,      "variable"}}},
 { IDX_H4FONT,       "h4font",         { { H4FONT,       "variable"},
					 { H4FONTL,      "variable"},
					 { H4FONTG,      "variable"}}},
 { IDX_LABELFONT,    "labelfont",      { { LABELFONT,    "fixed"}, 
					 { LABELFONT,    "fixed"},    /* !!! */
					 { LABELFONT,    "fixed"}}},  /* !!! */
 { IDX_NORMALFONT,   "normalfont",     { { NORMALFONT,   "fixed"},
					 { NORMALFONTL,  "fixed"},
					 { NORMALFONTG,  "fixed"}}},
 { IDX_INORMALFONT,  "italicfont",     { { ITALICFONT,   "fixed"},
					 { ITALICFONTL,  "fixed"},
					 { ITALICFONTG,  "fixed"}}},
 { IDX_BNORMALFONT,  "boldfont",       { { BOLDFONT,     "fixed"},
					 { BOLDFONTL,    "fixed"},
					 { BOLDFONTG,    "fixed"}}},
 { IDX_BINORMALFONT, "bolditalicfont", { { BINORMFONT,   "fixed"},
					 { BINORMFONTL,  "fixed"},
					 { BINORMFONTG,  "fixed"}}},
 { IDX_FIXEDFONT,    "fixedfont",      { { RFIXEDFONT,   "fixed"},
					 { RFIXEDFONTL,  "fixed"},
					 { RFIXEDFONTG,  "fixed"}}},
 { IDX_IFIXEDFONT,   "ifixedfont",     { { IFIXEDFONT,   "fixed"},
					 { IFIXEDFONTL,  "fixed"},
					 { IFIXEDFONTG,  "fixed"}}},
 { IDX_BFIXEDFONT,   "bfixedfont",     { { BFIXEDFONT,   "fixed"},
					 { BFIXEDFONTL,  "fixed"},
					 { BFIXEDFONTG,  "fixed"}}},
 { IDX_BIFIXEDFONT,  "bifixedfont",    { { BIFIXEDFONT,  "fixed"},
					 { BIFIXEDFONTL, "fixed"},
					 { BIFIXEDFONTG, "fixed"}}},
 { IDX_SYMBOLFONT,   "symbolfont",     { { SYMFONT,      "grk-s30"},
					 { SYMFONTL,     "grk-s30"},
					 { SYMFONTG,     "grk30s25"}}},
 { IDX_SUBSYMFONT,   "subsymbolfont",  { { SUBSYMFONT,   "grk-s25"},
					 { SUBSYMFONTL,  "grk-s25"},
					 { SUBSYMFONTG,  "grk-s25"}}},
 { IDX_SMALLFONT,    "smallfont",      { { SUBSCRFONT,   "micro"},
					 { SUBSCRFONTL,  "micro"},
					 { SUBSCRFONTG,  "micro"}}}
};
int ArenaFontsNumber = sizeof(ArenaFonts)/sizeof(ArenaFonts[0]);



/*
 * Various defaults.
 */
ArenaXdefaultsStruct ArenaXdefaults[] =
{
 {"mailcaps",   MAILCAPS},
 {"DefaultURL", DEFAULT_URL},
 {"HelpURL",    HELP_URL},
 {"tmp",        ARENA_DEFAULT_TMP_ROOT},
 {"CacheRoot",  ARENA_DEFAULT_CACHE_ROOT}
};
int ArenaXdefaultsNumber = sizeof(ArenaXdefaults)/sizeof(ArenaXdefaults[0]);
