/*                                                 W3C Sample Code Library libwww HTTP Client
                 MULTI THREADED HYPERTEXT TRANFER PROTOCOL CLIENT MODULE
                                             
 */
/*
**      (c) COPYRIGHT MIT 1995.
**      Please first read the full copyright statement in the file COPYRIGH.
*/
/*

   This is the HTTP client module. This is actually a very small definition file as almost
   everything is set up elsewhere.
   
   This module is implemented by HTTP.c, and it is a part of the W3C Sample Code Library.
   
 */
#ifndef HTTP_H
#define HTTP_H

#include "HTProt.h"
#include "HTStream.h"
/*

  HTTP Client Connection Mode
  
   The HTTP client module supports various modes for communicating with HTTP servers. The
   mode are defined by the enumeration below.
   
 */
typedef enum _HTTPConnectionMode {
    HTTP_11_PIPELINING     = 0x1,
    HTTP_11_NO_PIPELINING  = 0x2,
    HTTP_11_MUX            = 0x4,
    HTTP_FORCE_10          = 0x8
} HTTPConnectionMode;

extern void HTTP_setConnectionMode (HTTPConnectionMode mode);
extern HTTPConnectionMode HTTP_connectionMode (void);
/*

  HTTP Event Handler
  
   The event handler is the actual HTTP client state machine taking care of the
   communication.
   
 */
extern HTProtCallback HTLoadHTTP;
extern HTConverter HTTPStatus_new;

#endif /* HTTP_H */
/*

   
   ___________________________________
   
                              @(#) $Id: HTTP.html,v 2.37 1998/02/07 23:59:28 frystyk Exp $
                                                                                          
   */
