/* Bluefish HTML Editor
 * commandline.c -> the parsing of command line options
 *
 * a replacement for cli.c to comply with POSIX, cli.c used a 
 * GNU libc extension
 *
 * Copyright (C) 1999 Olivier Sessink
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <unistd.h>
#include <stdio.h>

#include <locale.h>
#include <libintl.h>
#define _(STRING) gettext(STRING)

#include "debug.h"
#include "bluefish.h"

int root_override = 0;

int 
parse_commandline (int argc, char **argv)
{

  int c;

  opterr = 0;

  while ((c = getopt (argc, argv, "sv?")) != -1)
    switch (c)
      {
      case 's':
        root_override = 1;
        break;
      case 'v':
        g_print(CURRENT_VERSION_NAME);
		  g_print("\n");
        exit (1);
      break;
      case '?':
			g_print(CURRENT_VERSION_NAME);
			g_print(_("\nCurrently accepted options are:\n"));
			g_print(_("-s    skip root check\n"));
			g_print(_("-v    current version\n"));
         exit (1);
        break;
      default:
        abort ();
      }
  return 0;
}
