#include <stdio.h>
#include <strings.h>
#include <unistd.h>
#include <gtk/gtk.h>
#include "pipedialog.h"
#include "alerts.h"


guint pipedialog_get_type(void);
static void pipedialog_class_init (PipeDialogClass *class);
static void pipedialog_init (PipeDialog *b);
GtkWidget* pipedialog_new ();
void pipedialog_dismiss(GtkWidget *widget, gpointer data);
void pipedialog_ok_callback(GtkWidget *widget, gpointer data);

guint
pipedialog_get_type ()
{
  static guint b_type = 0;

  if (!b_type)
    {
      GtkTypeInfo b_info =
      {
        "PipeDialog",
        sizeof (PipeDialog),
        sizeof (PipeDialogClass),
        (GtkClassInitFunc) pipedialog_class_init,
        (GtkObjectInitFunc) pipedialog_init,
        (GtkArgSetFunc) NULL,
        (GtkArgGetFunc) NULL,
      };

      b_type = gtk_type_unique (gtk_window_get_type(), &b_info);
    }

  return b_type;
}
enum {
  LAST_SIGNAL
};

/* static gint pipedialog_signals[LAST_SIGNAL] = { 0 };*/

static void
pipedialog_class_init (PipeDialogClass *class)
{
  GtkObjectClass *object_class;

  object_class = (GtkObjectClass*) class;
  
/*
  gtk_object_class_add_signals (object_class, pipedialog_signals, LAST_SIGNAL);
*/

  class->pipedialog = NULL;
}

static void
pipedialog_init (PipeDialog *a)
{
#if 0
  GtkWidget *ok_button;
  GtkWidget *msg_label;

  msg_label = gtk_label_new(a->msg);
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a)->vbox), msg_label,
                     TRUE, TRUE, 0);
  gtk_widget_show(msg_label);

  ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(GTK_DIALOG(a)->action_area), ok_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok_button), "pressed",
                      GTK_SIGNAL_FUNC (pipedialog_dismiss), a);
  gtk_widget_show(ok_button);
#endif
}

GtkWidget*
pipedialog_new (char *msg, char *src)
{
  PipeDialog *pipedialog;
  GtkWidget *vbox;
  GtkWidget *hbox;
  GtkWidget *msg_label;
  GtkWidget *separator;
  GtkWidget *ok_button;
  GtkWidget *cancel_button;

  pipedialog = gtk_type_new(pipedialog_get_type());
  strcpy(pipedialog->msg, msg);
  strcpy(pipedialog->src, src);

  vbox = gtk_vbox_new(FALSE, 5);
  gtk_container_add(GTK_CONTAINER(pipedialog), vbox);
  gtk_container_border_width(GTK_CONTAINER(vbox), 10);
  gtk_widget_show(vbox);

  msg_label = gtk_label_new(pipedialog->msg);
  gtk_box_pack_start(GTK_BOX(vbox), msg_label,
                     TRUE, TRUE, 0);
  gtk_widget_show(msg_label);

  pipedialog->cmdentry = gtk_entry_new();
  gtk_box_pack_start(GTK_BOX(vbox), pipedialog->cmdentry, TRUE, TRUE, 0);
  gtk_widget_show(pipedialog->cmdentry);

  separator = gtk_hseparator_new();
  gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, TRUE, 0);
  gtk_widget_show(separator);

  hbox = gtk_hbox_new(TRUE, 5);
  gtk_container_add(GTK_CONTAINER(vbox), hbox);
  gtk_container_border_width(GTK_CONTAINER(hbox), 4);
  gtk_widget_show(hbox);

  ok_button = gtk_button_new_with_label("OK");
  gtk_box_pack_start(GTK_BOX(hbox), ok_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (ok_button), "pressed",
                      GTK_SIGNAL_FUNC (pipedialog_ok_callback), pipedialog);
  gtk_widget_show(ok_button);

  cancel_button = gtk_button_new_with_label("Cancel");
  gtk_box_pack_start(GTK_BOX(hbox), cancel_button, TRUE, TRUE, 0);
  gtk_signal_connect (GTK_OBJECT (cancel_button), "pressed",
                      GTK_SIGNAL_FUNC (pipedialog_dismiss), pipedialog);
  gtk_widget_show(cancel_button);

  return GTK_WIDGET (pipedialog);
}

void pipedialog_dismiss(GtkWidget *widget, gpointer data)
{
  gtk_widget_destroy(GTK_WIDGET(data));
}

void pipedialog_ok_callback(GtkWidget *widget, gpointer data)
{
  FILE *p;
  char *s;
  char *cmd;

  cmd = gtk_entry_get_text(GTK_ENTRY(PIPEDIALOG(data)->cmdentry));
  if((p=popen(cmd, "w")) == NULL) {
    make_alert(widget, "Unable to open pipe");
    return;
  }

  s = PIPEDIALOG(data)->src;
  fwrite(s, strlen(s), sizeof(char), p);

  pclose(p);

  gtk_widget_destroy(GTK_WIDGET(data));
}

