#ifndef __PIPEDIALOG_H__
#define __PIPEDIALOG_H__

#include <gdk/gdk.h>
#include <gtk/gtkwindow.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define MSG_LEN 1024
#define SRC_LEN 8192

#define PIPEDIALOG(obj)          GTK_CHECK_CAST (obj, pipedialog_get_type (), PipeDialog)
#define PIPEDIALOG_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, pipedialog_get_type (), PipeDialogClass)
#define IS_PIPEDIALOG(obj)       GTK_CHECK_TYPE (obj, pipedialog_get_type ())


typedef struct _PipeDialog       PipeDialog;
typedef struct _PipeDialogClass  PipeDialogClass;

struct _PipeDialog
{
  GtkWindow window;

  GtkWidget *cmdentry;
  
  char msg[MSG_LEN];
  char src[SRC_LEN];
};

struct _PipeDialogClass
{
  GtkVBoxClass parent_class;

  void (* pipedialog) (PipeDialog *a);
};

guint          pipedialog_get_type        (void);
GtkWidget*     pipedialog_new             (char *msg, char *src);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* __PIPEDIALOG_H__ */
