#ifndef __URL_H__
#define __URL_H__

#define LINELEN	128
#define URL_LEN 1024
#define BUF_LEN 16384
#define HOST_LEN 128
#define PATH_LEN 1024

enum {
  URL_FILE,
  URL_HTTP,
  URL_FTP
};

typedef struct _URL {
  char url[URL_LEN];
  char host[HOST_LEN];
  char path[PATH_LEN];
  int protocol;
  int port;

  char buf[BUF_LEN]; /* the actual data */
  char *hdr, *src; /* beginning of source, after header */
} URL;

#if 0
typedef struct _url_ds {
   int protocol;
   int port;
   char host[HOST_LEN];
   char path[PATH_LEN];
   char url[URL_LEN];
} url_ds;

typedef struct {
  char url[URL_LEN];
  char buf[BUF_LEN];
  char *hdr, *src; /* beginning of source, after header */
} *url_data, _url_data;
#endif


URL *parse_url(char *url, char *rel_url);

#if 0
url_ds *parse_url(char *url, char *rel_url);
char *form_url(char *dest, url_ds url);
char *rel_url(url_ds prev_url, char *unqualified);
#endif

#endif  /*  __URL_H__  */
