package HNS::Diary;
################################################################
# HNS::Diary
#
#   each diary class
#
# sample:
#  my $diary = new HNS::Diary(filename=>'d19990331.hnf');
#  $diary->Read;
#  $diary->Print;
#
# (*) filename attributes must be set in new() or SetFilename()
#
# $Id: Diary.pm,v 1.5 1999/05/24 13:37:43 kenji Exp $
################################################################

use strict vars;
use ObjectTemplate;
use DateTime::Date;
use HNS::Hnf::TreeBuilder;
use HNS::Hnf::UserVar;
use HNS::Hnf::Warning;
use HNS::Template;

require 'jcode.pl';

use vars qw(@ISA $Head $Foot @WeekString);
@ISA = qw(ObjectTemplate);

attributes qw(filename year month day tree user_var last_modified read_done);
	      

# template
$Head = qq(<font size="+1">
	   <a href="?%year%month%high&to=%year%month%{day}0#%year%month%{day}0"
	   name="%year%month%{day}0">
	   %year/%month/%day (%week) </a>%user{TENKI}</font><dl>\n);

$Foot = qq(</dd></dl><hr>\n);

#
@WeekString = ('Sun', 'Mon', 'Tue', 'Wed', 'Thr', 'Fri', 'Sat');

################################################################
sub initialize($)
{
    my $self = shift;

    $self->tree(new HNS::Hnf::TreeBuilder);
    $self->user_var(new HNS::Hnf::UserVar);

    $self->SetFilename($self->filename)
	if ($self->filename);
}
sub SetFilename($$)
{
    my ($self, $filename) = @_;
    my ($y, $m, $d) = $self->filename =~ /d(\d{4})(\d{2})(\d{2})\.hnf$/;
    unless ($y && $m && $d){
	die "not hnf file: " . $self->filename;
    }
    $self->year($y), $self->month($m), $self->day($d);
    # set last_modified
    $self->last_modified((stat($self->filename))[9]);

}
################################################################
sub Read($)
{
    my $self = shift;
    my $ok;
    my $warning_message;

    # open the file and read
    open(F, $self->filename) || die;
    while (<F>){
	# convert kanji charactor code to euc
	&jcode::convert(\$_, 'euc');
	# convert to entity reference
	s/&/&amp;/g;
	s/>/&gt;/g;
	s/</&lt;/g;

	# parse
	if ($ok){                # body part
	    $self->tree->Parse($_);
	} else {                      # head part
	    if (/^OK$/){                    # line 'OK'
		$ok = 1;
	    } elsif (/^([A-Z]+)\s(.*)$/){   # User Variable
		unless ($self->user_var->Account($1, $2)){
		    $warning_message .=
			&HNS::Hnf::Warning::Message('UndefinedUserVar', $1);
		}
	    } else {                        # illegal line in head part
		$warning_message .= HNS::Hnf::Warning::Message('IllegalHeader');
	    }
	}
    }
    close F;
    $self->read_done(1) if $ok;
    if ($ok && $warning_message){ # OK and warning exist
	$self->tree->{top}->UnshiftContent($warning_message);
    }
}
################################################################
sub Print($)
{
    my $self = shift;

    return unless $self->read_done;
    my ($year, $month, $day) = ($self->year, $self->month, $self->day);
    my $dateDayHi = int($day/10);

    my $date = new DateTime::Date(year=>$year, month=>$month, day=>$day);

    my $templ = new HNS::Template;
    my $abc;
    if ($day < 11) {
        $abc = "a";
    }
    elsif ($day < 21) {
        $abc = "b";
    }
    else {
        $abc = "c";
    }
    $templ->SetParamValues(year=>$year, month=>$month, day=>$day,
			   high=>int($day/10), abc=>$abc,
			   week=>$WeekString[$date->week]);
#			   w_abbr=>$date->week_string('abbr'),
#			   w_full=>$date->week_string('full'),
#			   w_jp=>$date->week_string('japanese'));
    
    # head
    my $head = $HNS::Diary::Head;
    $head =~ s/%user{([A-Z]+)}/$self->user_var->Eval($1)/ge; # user var
    $templ->SetTemplate($head);
    print $templ->Expand; 

    # diarys
    $self->tree->Print($self->year, $self->month, $self->day);

    # foot
    $templ->SetTemplate($HNS::Diary::Foot);
    print $templ->Expand;
}
1;

