;;; hnf-mode.el --- major mode for editing hnf.

;; Copyright (C) 1998-2000 by Akihiro Arisawa <ari@nijino.com>

;; Author: Akihiro Arisawa <ari@nijino.com>
;; Version: $Id: hnf-mode.el,v 3.5 2000/01/30 16:15:52 ari Exp $
;; Keywords: hnf nikki hns

;; This file is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This file is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GNU Emacs; see the file COPYING.  If not, write to
;; the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
;; Boston, MA 02111-1307, USA.

;;; Commentary:

;; ڤǤ뤳ȡ
;; 1. hnfԽTABǤ䴰Ǥޤ
;; 2. font-lockȤähnf򥫥顼ɽޤ
;; 3. M-x hnf  ~/diary/1999/d19990107.hnf hnf򳫤ޤ
;;    C-u numeric M-x hnf ǡnumerichnf򳫤ޤ
;; 4. NEWSUBΥ󥯤nameɽڤӡkill-ringǤޤ
;;    ޤΥե򥪡ץǤޤ(ХѥǻΤ)
;; 5. namazu.elnamazu_for_hnsǸ̤ե򳫤ޤ
;; 6. M-x calendarϢȤǤޤ
;; 7. ¾
;;
;; ڥ󥹥ȡ
;; 1. APEL򥤥󥹥ȡ뤷ޤ
;; 2. hnf-mode.el  load-path ̤äȤ֤ޤ
;; 
;; ʤɤʤɡ
;; ɬܤ12ǤʳϤߤǤɤ
;;
;; 1. ĥҤ.hnfʥե򳫤hnf-modeȤʤ褦~/.emacs
;;    ꤷޤ
;;    (autoload 'hnf "hnf-mode" nil t)
;;    (autoload 'hnf-mode "hnf-mode" nil t)
;;    (setq auto-mode-alist (cons '("\\.hnf$" . hnf-mode) auto-mode-alist))
;;
;; 2. hnf-diary-dir, hnf-html-dir, hnf-diary-year-directory-flagɬפ˱
;;    ꤷޤꤹ٤ͤѿΥȤ򻲾ȤƤ
;;    ) (setq hnf-diary-dir "~/diary")
;;	  (setq hnf-html-dir "~/public_html/diary")
;;	  (setq hnf-diary-year-directory-flag t)
;;
;; 3. ѿ䴰hnf-variableꤷޤ
;;    ) (setq hnf-variable '(("TENKI") ("BASHO") ("TAIJU") ("TAION")))
;;
;; 4. ޡ䴰򤷤hnf-marksꤷޤ
;;    ) (setq hnf-marks '(("(^^)") ("(-_-)") ("(^^;") ("(;_;)") ("(T_T)"))
;;
;; 5. RLINK䴰hnf-rlinkꤷޤ
;;    ) (setq hnf-rlink '(("h14m") ("ari")))
;;
;; 6. CAT䴰hnf-catꤷޤ
;;    ) (setq hnf-cat '(("Linux") ("Nikki")))
;;
;; 7. ALIAS䴰hnf-aliasꤷޤ
;;    ) (setq hnf-alias '(("Be") ("hns")))
;;
;; 8. M-x hnfˤƿե򳫤ˡ¹Ԥؿhnf-initial-function
;;    ꤷޤ"OK"ưаʲΤ褦ˤޤ
;;    ) (setq hnf-initial-function '(lambda () (insert "OK\n\n")))
;;
;; 9. 28:00ޤǤ򤷤Ƥϡʲ򤷤ƤߤƤ
;;         (setq hnf-hour-not-today 4)
;;     ܺ٤hnf-hour-not-today򻲾ȤƤ
;;
;; 10. NEWSUBιԤǡ󥯤nameɽʤ hnf-get-link(C-c=) 
;;     Υե򥪡ץ󤷤ʤ hnf-link-find-file(C-cC-f) 
;;     ȤޤޤC-uC-c= ǥ󥯤namekill-ringޤ
;;
;;    (1) hns-1.03pl0ǤϥǥեȤΥ󥯤nameۤʤޤ
;;          ηɽϰʲԤäƤ
;;          (setq hnf-get-link-name-function 'hnf-get-link-name)
;;    (2) hns-2.1ʹ(?)ǤϥǥեȤΥ󥯤̾ۤʤޤ
;;          ηɽϰʲԤäƤ
;;          (setq hnf-get-link-name-function 'hnf-get-link-name-with-abc)
;;
;; 11. ֤ʤ hnf-insert-time(C-cC-t) Ȥޤ
;;     եޥåȤ hnf-time-format ѹǤޤ
;;     C-uC-cC-t ǥʹߤ˴Ƥ֤򸽺ߤλ֤
;;     ѹޤ
;;
;;     ޤ hnf-write-file-insert-time(C-cC-s)ɾȡե
;;     ֤ե¸ޤ
;;
;; 12. hnf-newline(C-cC-m)ǡԤƱĤ륿ʤɤԤޤ
;;     "\C-m"˥ХɤƤ̵Ȼפޤ
;;     ) (add-hook 'hnf-mode-load-hook
;;                   '(lambda ()
;;                      (define-key hnf-mode-map "\C-m" 'hnf-newline)))
;;
;; 13. namazu.elˤnamazu_for_hnsθ̤ե򳫤ʤС
;;     hnf-namazu-find-filenamazu-mode-mapŬꤹ뤳Ȥ򤹤ޤ
;;     ) (setq namazu-command (expand-file-name "~/diary/namazu/bin/namazu"))
;;	   (add-hook 'namazu-mode-hook
;;		     '(lambda ()
;;		       (define-key namazu-mode-map "f" 'hnf-namazu-find-file)))
;;	   (autoload 'hnf-namazu-edit "hnf-mode" nil t)
;;
;;     ޤhnf-modeC-cC-nnamazu.el¹ԤǤޤ
;;
;; 14. M-x calendarϢȤʤСhnf-insert-diary-entryŬХ
;;     ޤ礦
;;     ) (autoload 'hnf-insert-diary-entry "hnf-mode" nil t)
;;         (add-hook 'calendar-load-hook
;;             '(lambda ()
;;                (define-key calendar-mode-map "iD" 'hnf-insert-diary-entry)))
;;     ޤhnf-mark-diary-entries¹ԤȡϤƤ
;;     ޡդޤ
;;     ) (autoload 'hnf-mark-diary-entries "hnf-mode" nil t)
;;         (add-hook 'today-visible-calendar-hook 'hnf-mark-diary-entries)
;;         (add-hook 'today-invisible-calendar-hook 'hnf-mark-diary-entries)
;;
;; 15. Web BrowserϢȤϡhnf-diary-urlURLꤷ
;;     
;;     hnf-browse-recent-diary(C-cC-b) ޤ hnf-browse-diary 
;;     Web Browserưޤ
;;     ) (setq hnf-diary-url "http://www.nijino.com/ari/diary/")
;;
;;     ޤhnf-preview-diary(C-cC-p)Ǥϡhttpd ͳɽǤޤ
;;
;; 27,9customȤäǤϤǤ(ư̤ǧ(^^;)
;;
;; Emacsen
;; ưǧϼemacs-20ǹԤäƤޤXEmacs-20/21¿ʬ̵Ǥ礦
;; mule-2.3@emacs-19.34Ǥcustom-1.9962򥤥󥹥ȡ뤹лȤȻפޤ
;; mule-2.3@emacs-19.28ǤϤʤĥɬפǤ礦(^^;
;;
;; ʤmule-2.3@19.34custom-1.9962Ȥϡhttp://www.jpl.org/elips/
;; ǤѥåƤɬפޤ
;;
;; To do
;; 1. calendarbrowse-urlƤ٤褦ˤ褦ʡ
;; 2. (hnf-write-file-insert-time)ɾˡ˺ǽԤ˻֤
;;    Ƥϡ񤭤Ǥ
;; 3. Ū˥顼ŤΤľ٤ʡ
;;
;; ڼռ
;; ϥѡƥκԤ˴դޤϥѡƥ̵Ƥ
;; hnf-modeޤʤäǤ礦:-)
;; Ʊνʡ﷯˴դޤ䴰β̴ؿtoali.elåäƤޤ(^^;
;; ܸ줵(http://i21x12.fuis.fukui-u.ac.jp/~ken/diary/)˴դޤ
;; M-x hnfȤǽɲäޤ(^^)
;; ޤhnf-mode˶ϤƤʲγ˴դޤ
;;	ޤ	http://symphony.sone.riec.tohoku.ac.jp/~yamaya/diary/
;;	ܺꤵ	http://zak.interwave.or.jp/diary/
;;	JUN		http://jun.misao.gr.jp/diary/
;;	saw		http://www.be-in.org/~mas/diary/

;;; Code:

(defconst hnf-mode-version "2.0")

(require 'poe)
(require 'custom)

(defgroup hnf nil
  "Hyper Nikki File"
  :group 'hypermedia)

(defcustom hnf-diary-dir "~/diary"
  "ǥ쥯ȥꤷޤ"
  :group 'hnf
  :type 'directory)

(defcustom hnf-html-dir "~/public_html/diary"
  "hnsΥ֡ǥ쥯ȥꤷޤ"
  :group 'hnf
  :type 'directory)

(defcustom hnf-hns-program (concat hnf-html-dir "/index.cgi")
  "hnsΥץ̾Ǥ"
  :group 'hnf
  :type 'file)

(defcustom hnf-document-root "/usr/local/apache/htdocs"
  "WebФDocumentRootꤷޤ"
  :group 'hnf
  :type 'directory)

(defcustom hnf-diary-year-directory-flag t
  "hnfǥ쥯ȥľ֤nilǯ˥ǥ쥯ȥ
ʬnon-nilꤷޤ"
  :group 'hnf
  :type 'boolean)

(defcustom hnf-diary-url (concat "http://" (system-name) "/"
				 "~" (user-login-name) "/diary/")
  "URLꤷޤ"
  :group 'hnf
  :type 'string)

(defcustom hnf-index-name-list '("index.html" "index.shtml" "index.phtml")
  "indexȤƳե̾ꤷޤ"
  :group 'hnf
  :type 'list)

(defcustom hnf-mode-hook nil
  "hnf-mode  hook"
  :group 'hnf
  :type 'hook)

(defcustom hnf-mode-load-hook nil
  "hnf-modeloadhook"
  :group 'hnf
  :type 'hook)

(defcustom hnf-initial-function nil
  "ե򥪡ץ󤷤˸ƤФؿ"
  :group 'hnf
  :type 'function)

(defcustom hnf-variable nil
  "hnfǻѤѿꤷޤnilꤹѿ䴰ϹԤޤ"
  :group 'hnf
  :type 'list)

(defcustom hnf-marks nil
  "hnfǻѤޡꤷޤnilꤹȥޡ䴰ϹԤޤ"
  :group 'hnf
  :type 'list)

(defcustom hnf-alias nil
  "hnfǻѤALIASꤷޤnilꤹALIAS䴰ϹԤޤ"
  :group 'hnf
  :type 'list)

(defcustom hnf-commands
  '(("NEW"	1	"NEW Υȥ")
    ("SUB"	1	"SUB Υ֡Υȥ")
    ("CAT"	1	"CAT ƥ1 [ƥ2 ...]")
    ("LNEW"	2	"LNEW url Υȥ")
    ("LSUB"	2	"LSUB url Υ֡Υȥ")
    ("LINK"	2	"LINK url ʸ")
    ("URL"	2	"URL url ʸ")
    ("RLINK"	3	"RLINK arg1 arg2 ʸ")
    ("FONT"	3	"FONT arg1 arg2 ʸ")
    ("STRIKE"	1	"STRIKE ʸ")
    ("LSTRIKE"	2	"STRIKE url ʸ")
    ("STRONG"	1	"STRONG ʸ")
    ("IMG"	3	"IMG {r|l|n} ե̾ ʸ")
    ("MARK"	1	"MARK ")
    ("UL"	0	"UL")
    ("/UL"	0	"/UL")
    ("OL"	0	"OL")
    ("/OL"	0	"/OL")
    ("LI"	1	"LI ʸ")
    ("PRE"	0	"PRE")
    ("/PRE"	0	"/PRE")
    ("CITE"	0	"CITE")
    ("/CITE"	0	"/CITE")
    ("!"	1	"! ʸ")
    ("!#"	1	"!# ʸ")
    ("FN"	0	"FN")
    ("/FN"	0	"/FN")
    ("ALIAS"	1	"ALIAS arg")
    )
  "hnfǻѤ륳ޥɤꤷޤ"
  :group 'hnf
  :type 'list)

(defcustom hnf-close-command-list
  '("UL" "OL" "PRE" "CITE" "FN")
  "hnfĤɬפΤ륳ޥɤΥꥹȤꤷޤ"
  :group 'hnf
  :type 'list)

(defcustom hnf-rlink nil
  "hnfǻѤRLINKꤷޤ"
  :group 'hnf
  :type 'list)

(defcustom hnf-cat nil
  "hnfǻѤCATꤷޤ"
  :group 'hnf
  :type 'list)

(defcustom hnf-font-lock-flag t
  "font-lockȤɤλ򤷤ޤ"
  :group 'hnf
  :type 'boolean)

(defcustom hnf-complete-command-insert-space-flag t
  "ޥɤ䴰λ˥ڡ뤫ɤλ򤷤ޤ"
  :group 'hnf
  :type 'boolean)

(defcustom hnf-complete-command-insert-newline-function 'hnf-newline
  "ɬפȤʤޥɤ䴰λˡ뤹ؿ
ꤷޤ"
  :group 'hnf
  :type 'function)

(defcustom hnf-time-format "(%H:%M)"
  "hnf-insert-timeΥեޥåȤꤷޤ
`format-time-string'򻲾ȤƤ"
  :group 'hnf
  :type 'string)

(defcustom hnf-time-regexp "([0-9][0-9]:[0-9][0-9])"
  "`hnf-insert-time' ʸɽǤ"
  :group 'hnf
  :type 'regexp)

(defcustom hnf-tab-command 'tab-to-tab-stop
  "`hnf-tab-complete'䴰Ÿ¹Ԥʤä˼¹Ԥؿ
ꤷޤ"
  :group 'hnf
  :type 'function)

(defcustom hnf-header-p-function 'hnf-header-p
  "إåȽԤؿꤷޤ"
  :group 'hnf
  :type 'function)

(defcustom hnf-font-lock-keywords
  '(("^CAT.*" . hnf-cat-face)
    ("^L?NEW.*" . hnf-new-face)
    ("^L?SUB.*" . hnf-sub-face)
    ("^\\(!\\|!#\\).*" . hnf-comment-face)
    ("^RLINK[ \t]+\\([^ \t]+[ \t]+[^ \t]+\\)" 1 hnf-link-face)
    ("^\\(URL\\|LINK\\|LNEW\\|LSUB\\)[ \t]+\\([^ \t]+\\)" 2 hnf-link-face)
    (eval . (cons (concat "^\\(" (mapconcat 'car hnf-commands "\\|") "\\)\\>")
		  hnf-command-face))
    (eval . (list (concat "^\\(" (mapconcat 'car hnf-variable "\\|") "\\)\\>")
		  '(0 (if (hnf-header-p) hnf-variable-face))))
    ("~$" . hnf-tilde-face)
    )
  "hnf⡼ɤǤfont-lockΥɡ"
  :group 'hnf
  :type 'list)

(defcustom hnf-get-link-name-function 'hnf-get-link-name-with-to
  "(hnf-get-link)ǥ󥯤̾ؿꤷޤ
hns-1.03pl0ޤǤΤ`hnf-get-link-name'hns-1.03pl1ʹߤ
`hnf-get-link-name-with-to'ꤷƤ"
  :group 'hnf
  :type 'function)

(defcustom hnf-hour-not-today 0
  "λ֤ޤǤȤߤʤޤ023ꤷޤ

: 6ꤹȡ0:005:59ޤǤǤȤߤʤ
    M-x hnf¹Իˤhnf򳫤ޤޤ(hnf-insert-time)
    \"25:00\" Ȥäɽˤʤޤ"
  :group 'hnf
  :type 'integer)

(defface hnf-cat-face '((t (:foreground "purple" :bold t)))
  "hnfCATιԤΥե"
  :group 'hnf)
(defface hnf-new-face '((t (:foreground "purple" :bold t)))
  "hnfNEWιԤΥե"
  :group 'hnf)
(defface hnf-sub-face '((t (:foreground "purple")))
  "hnfNEWιԤΥե"
  :group 'hnf)
(defface hnf-link-face '((t (:foreground "Blue")))
  "hnfΥ󥯤ιԤΥե"
  :group 'hnf)
(defface hnf-comment-face '((t (:foreground "Red")))
  "hnfΥȹԤΥե"
  :group 'hnf)
(defface hnf-command-face '((t (:foreground "firebrick")))
  "hnfΥޥɤΥե"
  :group 'hnf)
(defface hnf-tilde-face '((t (:foreground "orange")))
  "hnf\"~\"Υե"
  :group 'hnf)
(defface hnf-variable-face '((t (:foreground "DarkGoldenrod")))
  "hnfѿΥե(Դʤ)"
  :group 'hnf)

(defvar hnf-mode-map nil)

(defvar hnf-cat-face 'hnf-cat-face)
(defvar hnf-new-face 'hnf-new-face)
(defvar hnf-sub-face 'hnf-sub-face)
(defvar hnf-link-face 'hnf-link-face)
(defvar hnf-comment-face 'hnf-comment-face)
(defvar hnf-command-face 'hnf-command-face)
(defvar hnf-tilde-face 'hnf-tilde-face)
(defvar hnf-variable-face 'hnf-variable-face)

(defvar hnf-complete-ok t
  "non-nilꤹOK䴰оݤ˴ޤޤ")

(defconst hnf-completion-buffer-name "*HNF Completions*")

(if hnf-mode-map nil
  (setq hnf-mode-map (make-sparse-keymap))
  (define-key hnf-mode-map "\t" 'hnf-tab-complete)
  (define-key hnf-mode-map "\C-c\C-m" 'hnf-newline)
  (define-key hnf-mode-map "\C-c?" 'hnf-command-help)
  (define-key hnf-mode-map "\C-c=" 'hnf-get-link)
  (define-key hnf-mode-map "\C-c\C-f" 'hnf-link-find-file)
  (define-key hnf-mode-map "\C-c\C-t" 'hnf-insert-time)
  (define-key hnf-mode-map "\C-c\C-s" 'hnf-write-file-insert-time)
  (define-key hnf-mode-map "\C-c\C-b" 'hnf-browse-recent-diary)
  (define-key hnf-mode-map "\C-c\C-p" 'hnf-preview-diary)
  )

;;;###autoload
(defun hnf-mode ()
  "hnfΥ⡼ɡ"
  (interactive)
  (use-local-map hnf-mode-map)
  (setq mode-name "HNF")
  (setq major-mode 'hnf-mode)
  ; font-lock
  (if hnf-font-lock-flag
      (progn
	(require 'font-lock)
	(make-local-variable 'font-lock-defaults)
	(setq font-lock-defaults '(hnf-font-lock-keywords t))
	(turn-on-font-lock)))
  (run-hooks 'hnf-mode-hook))

;;;###autoload
(defun hnf (&optional arg)
  "hnf򳫤"
  (interactive "P")
  (let* ((days-ago (if (listp arg) nil arg))
	 (now (hnf-current-time days-ago))
	 (name (concat hnf-diary-dir "/" 
		       (and hnf-diary-year-directory-flag
			    (hnf-format-time-string "%Y/" now))
		       (if (and arg (listp arg)) nil
			 (hnf-format-time-string "d%Y%m%d.hnf" now))))
	 find-file-not-found-hooks)
    (if (and arg (listp arg)) (setq name (read-file-name "Find file: " name)))
    (if (functionp hnf-initial-function)
	(add-hook 'find-file-not-found-hooks
		  '(lambda () (funcall hnf-initial-function))))
    (find-file name)
    (hnf-mode)))

(defun hnf-tab-complete ()
  "TAB򲡤䴰ŸԤ"
  (interactive)
  (let ((spaces (hnf-count-spaces))
	(command-word (hnf-command-word)))
    (cond ((funcall hnf-header-p-function)
	   (or (and (eq spaces 0)
		    (or (and hnf-variable
			     (not (eq (hnf-complete hnf-variable) 'no-match)))
			(and hnf-complete-ok
			     (not (eq (hnf-complete '(("OK"))) 'no-match)))))
	       (funcall hnf-tab-command)))
	  ((string= "CAT" command-word)	; CATǤʣĤεҤǽ
	   (and hnf-cat (hnf-complete hnf-cat)))
	  ((and (string= "MARK" command-word) (= spaces 1))
	   (and hnf-marks (hnf-complete hnf-marks)))
	  ((and (string= "RLINK" command-word) (= spaces 1))
	   (and hnf-rlink (hnf-complete hnf-rlink)))
	  ((and (string= "ALIAS" command-word) (= spaces 1))
	   (and hnf-alias (hnf-complete hnf-alias)))
	  ((and (or (string= "LINK" command-word)
		    (string= "LNEW" command-word)
		    (string= "LSUB" command-word))
		(= spaces 1))
	   (hnf-complete-link))
	  ((and (string= "/" command-word) (= spaces 0))
	   (and hnf-close-command-list (hnf-close-command)))
	  ((and (= spaces 0)
		(not (eq (hnf-complete-command command-word) 'no-match))))
	  (t
	   (funcall hnf-tab-command)))))

;;; Ƽ拾ޥ
(defun hnf-newline ()
  "returnˤޤ"
  (interactive)
  (let ((command-word (hnf-command-word))
	(close-command-regexp
	 (concat "^\\("
		 (mapconcat 'identity hnf-close-command-list "\\|")
		 "\\)$")))
    (cond ((string-match close-command-regexp command-word) ; Ĥ륿
	   (save-excursion (insert (concat "\n/" command-word "\n")))
	   (cond ((or (string= "UL" command-word) (string= "OL" command-word))
		  (insert "\nLI "))
		 (t
		  (insert "\n"))))
	  ((string= "CAT" command-word)
	   (insert "\nNEW "))
	  (t
	   (newline)))))

(defun hnf-command-help ()
  "ޥɤδñʥإפɽޤ"
  (interactive)
  (message (nth 2 (assoc (hnf-command-word) hnf-commands))))

(defun hnf-link-find-file ()
  "LINKLSUBˤХѥǻꤵ줿ե򥪡ץ󤷤ޤ"
  (interactive)
  (let ((command-word (hnf-command-word)))
    (if (or (string= "LINK" command-word)
	    (string= "LNEW" command-word)
	    (string= "LSUB" command-word))
	(let (p fname)
	  (save-excursion
	    (beginning-of-line)
	    (skip-chars-forward "^ \t\n")
	    (skip-chars-forward " ")
	    (setq p (point))
	    (skip-chars-forward "^ \t\n#")
	    (setq fname (buffer-substring-no-properties p (point))))
	  (cond ((string-match "^\\(http\\|ftp\\)://" fname)
		 (error "Absolute-URL is not supported"))
		((string-match "^/" fname)
		 (setq fname (concat hnf-document-root fname)))
		(t
		 (setq fname (concat hnf-html-dir "/" fname))))
	  (if (file-directory-flag fname)
	      (progn
		(if (not (string-match "/$" fname))
		    (setq fname (concat fname "/")))
		(let ((index-list hnf-index-name-list))
		  (while (and index-list
			      (not (file-exists-p
				    (concat fname (car index-list)))))
		    (setq index-list (cdr index-list)))
		  (if index-list
		      (setq fname (concat fname (car index-list)))
		    (setq fname
			  (read-file-name "Find file: " fname))))))
	  (find-file fname)))))

(defun hnf-get-link (&optional arg)
  "NEWSUBΥ󥯤nameޤ"
  (interactive "P")
  (let ((date-list (hnf-buffer-hnf-p))
	year mon day day-num dayhi abc cmd-word new-cnt sub-cnt link-name)
    (if (null date-list)
	(error "hnfǤϤޤ")
      (setq year (nth 0 date-list)
	    mon (nth 1 date-list)
	    day (nth 2 date-list)
	    day-num (string-to-number day)
	    dayhi (/ day-num 10)
	    abc (cond ((< day-num 11) "a") ((< day-num 21) "b") (t "c"))
	    cmd-word (hnf-command-word))
      (save-excursion
	(if (string-match "^L?SUB$" cmd-word)
	    (progn
	      (setq sub-cnt 1)
	      (while (and (= (forward-line -1) 0)
			  (not (string-match
				"^L?NEW$"
				(setq cmd-word (hnf-command-word)))))
		(if (string-match "^L?SUB$" cmd-word)
		    (setq sub-cnt (1+ sub-cnt))))))
	(if (string-match "^L?NEW$" cmd-word)
	    (progn
	      (setq new-cnt 1)
	      (while (= (forward-line -1) 0)
		(if (string-match "^L?NEW$" (hnf-command-word))
		    (setq new-cnt (1+ new-cnt)))))))
      (if new-cnt
	  (progn 
	    (setq link-name (funcall hnf-get-link-name-function))
	    (message link-name)
	    (if arg (kill-new link-name)))))))

(defun hnf-get-link-name ()
  "hns-1.03pl0NEWΥ󥯤̾ؿǤ"
  (let ((link-name (format "?%s%s%d#%s%s%s%d" 
			   year mon dayhi year mon day new-cnt)))
    (if sub-cnt
	(concat link-name "S" (number-to-string sub-cnt))
      link-name)))

(defun hnf-get-link-name-with-to ()
  "hns-1.03pl1ʹߤNEWΥ󥯤̾ؿǤ"
  (let ((link-name (format "%s%s%s%d" year mon day new-cnt)))
    (if sub-cnt
	(setq link-name (concat link-name "S" (number-to-string sub-cnt))))
    (setq link-name (format "?%s%s%d&to=%s#%s" 
			    year mon dayhi link-name link-name))))

(defun hnf-get-link-name-with-to-abc ()
  "hns-2.1ʹ(?)NEWΥ󥯤̾ؿǤ"
  (let ((link-name (format "%s%s%s%d" year mon day new-cnt)))
    (if sub-cnt
	(setq link-name (concat link-name "S" (number-to-string sub-cnt))))
    (setq link-name (format "?%s%s%s&to=%s#%s" 
			    year mon abc link-name link-name))))

(defun hnf-get-link-name-with-abc ()
  "hns-2.1ʹ(?)NEWΥ󥯤̾ؿǤ"
  (let ((link-name (format "%s%s%s%d" year mon day new-cnt)))
    (if sub-cnt
	(setq link-name (concat link-name "S" (number-to-string sub-cnt))))
    (setq link-name (format "?%s%s%s#%s" 
			    year mon abc link-name link-name))))

(defun hnf-insert-time (&optional arg)
  "֤ޤ"
  (interactive "P")
  (if (and arg
	   (re-search-forward hnf-time-regexp nil t))
      (replace-match
       (save-match-data
	 (hnf-format-time-string hnf-time-format (hnf-current-time))))
    (insert (hnf-format-time-string hnf-time-format (hnf-current-time)))))

(defun hnf-write-file-insert-time ()
  "`(hnf-insert-time)'¹Ԥե¸ޤ"
  (interactive)
  (save-excursion
    (goto-char (point-max))
    (hnf-insert-time))
  (save-buffer))

;;; for namazu.el
(defun hnf-namazu-find-file ()
  "\*namazu\*ˤƥݥȤ֤ܤ򥨥ǥȤޤ"
  (interactive)
  (save-excursion
    (if (re-search-forward 
	 "#\\([1-9][0-9][0-9][0-9]\\)\\([0-1][0-9][0-3][0-9]\\)0" nil t)
	(find-file (concat hnf-diary-dir "/"
			   (and hnf-diary-year-directory-flag 
				(concat (match-string 1) "/"))
			   "d" (match-string 1) (match-string 2) ".hnf")))))

;;; for calendar.el
(defun hnf-filename-from-date (date)
  (concat hnf-diary-dir "/"
	  (and hnf-diary-year-directory-flag
	       (format "%d/" (extract-calendar-year date)))
	  (format "d%04d%02d%02d.hnf"
		  (extract-calendar-year date)
		  (extract-calendar-month date)
		  (extract-calendar-day date))))

;;;###autoload
(defun hnf-insert-diary-entry ()
  "ΥݥȤդhnf򳫤ޤ"
  (interactive)
  (find-file-other-window
   (hnf-filename-from-date (calendar-cursor-to-date t))))

;;;###autoload
(defun hnf-mark-diary-entries ()
  "񤤤Ƥޡޤ"
  (interactive)
  (require 'calendar)
  (let (y m first-date last-date tmp)
    (save-excursion
      (set-buffer calendar-buffer)
      (setq m displayed-month)
      (setq y displayed-year))
    (increment-calendar-month m y -1)
    (setq first-date
          (calendar-absolute-from-gregorian (list m 1 y)))
    (increment-calendar-month m y 2)
    (setq last-date
          (calendar-absolute-from-gregorian
           (list m (calendar-last-day-of-month m y) y)))
    (calendar-for-loop date from first-date to last-date do
		       (if (file-exists-p
			    (hnf-filename-from-date
			     (setq tmp
				   (calendar-gregorian-from-absolute date))))
			   (mark-visible-calendar-date tmp)))))

;;; for browse-url
(defun hnf-browse-recent-diary ()
  "browse-urlȤäƺǿɽޤ"
  (interactive)
  (browse-url hnf-diary-url))

(defun hnf-browse-diary ()
  "browse-urlȤäƸԽɽޤ"
  (interactive)
  (let ((date-list (hnf-buffer-hnf-p)))
    (if (null date-list)
	(error "hnfǤϤޤ")
      (browse-url (concat hnf-diary-url "?"
			  (mapconcat 'identity date-list ""))))))

(defvar hnf-temp-file-list '())

(defun hnf-preview-diary ()
  "browse-urlȤäƸԽɽޤ"
  (interactive)
  (let ((date-list (hnf-buffer-hnf-p)))
    (if (null date-list)
        (error "hnfǤϤޤ")
      (let ((temp-file (concat temporary-file-directory
			       "hnf" (apply 'concat date-list) ".html"))
            (default-directory (file-name-directory hnf-hns-program)))
        (with-temp-file temp-file
          (call-process hnf-hns-program nil t t (apply 'concat date-list)))
        (browse-url-of-file temp-file)
	(add-to-list 'hnf-temp-file-list temp-file)))))

(defun hnf-delete-temp-file-list ()
  "hnf-temp-file-list Υեޤ"
  (while hnf-temp-file-list
    (if (file-exists-p (car hnf-temp-file-list))
	(delete-file (car hnf-temp-file-list)))
    (setq hnf-temp-file-list (cdr hnf-temp-file-list))))
(add-hook 'kill-emacs-hook 'hnf-delete-temp-file-list)

;;; ¿ʴؿ
(defun hnf-buffer-hnf-p (&optional buffer)
  "bufferhnfɤȽꤷޤbufferά`current-buffer'
ФȽꤷޤhnfξ(year mon day)ΥꥹȤ֤ޤ"
  (let ((fname (buffer-file-name buffer)))
    (if (and fname
	     (string-match 
	      "d\\([0-9][0-9][0-9][0-9]\\)\\([0-1][0-9]\\)\\([0-3][0-9]\\)\\.hnf"
	      (setq fname (file-name-nondirectory fname))))
	(list (match-string 1 fname)
	      (match-string 2 fname)
	      (match-string 3 fname)))))

(defun hnf-header-p ()
  "إåɤĴ٤ޤ"
  (save-excursion
    (not (search-backward "\n\n" nil t))))

(defun hnf-count-spaces ()
  "֤ޤǤζޤ"
  (save-excursion
    (let ((p (point))
	  (cnt 0))
      (beginning-of-line)
      (while (re-search-forward "[ \t]+" p t)
	(setq cnt (+ cnt 1)))
      cnt)))

(defun hnf-cur-word (&optional erase)
  "֤ñФޤ"
  (save-excursion
    (let ((p (point))
	  string)
      (skip-chars-backward "^ \t\n")
      (setq string (buffer-substring-no-properties p (point)))
      (if erase (delete-region p (point)))
      string)))

(defun hnf-command-word ()
  "ιԤΥޥ(Ȼפ)ޤ"
  (save-excursion
    (beginning-of-line)
    (let ((p (point)))
      (skip-chars-forward "^ \t\n")
      (buffer-substring-no-properties p (point)))))

(defun hnf-close-command ()
  "Ĥ륳ޥɤޤ
(ޥɤΥͥȤˤ̤б)"
    (if (save-excursion
	  (re-search-backward
	   (concat "^\\("
		   (mapconcat 'identity hnf-close-command-list "\\|")
		   "\\)$")
	   nil t))
	(insert (match-string 0))))

(defun hnf-current-time (&optional days-ago)
  "`current-time'֤ޤ`hnf-hour-not-today'ꤵƤ
λʬλ֤֤ޤ"
  (let ((time (current-time)))
    (if (not (numberp days-ago)) (setq days-ago 0))
    (hnf-time-float (- (hnf-float-time time)
		       (* days-ago 24 60 60)
		       (* (or hnf-hour-not-today 0) 60 60)))))

(defun hnf-format-time-string (time-format &optional time)
  "`format-time-string'ƱǤ%H`hnf-hour-not-today'ʬ
̤λ֤Ȥʤޤ"
  (let ((case-fold-search nil)
	sub-format hour)
    (while (string-match "%[a-zA-Z]" time-format)
      (setq sub-format (match-string 0 time-format))
      (setq time-format
	    (replace-match
	     (if (string= sub-format "%H")
		 (format "%d" (+ (or hnf-hour-not-today 0)
				 (nth 2 (decode-time time))))
	       (format-time-string sub-format time))
	     nil nil time-format)))
    time-format))

(defun hnf-float-time (&optional tm)
  (let ((time (or tm (current-time))))
    (+ (* (float (ash 1 16)) (nth 0 time)) (float (nth 1 time)))))
  
(defun hnf-time-float (num)
  (let* ((most-time (floor num 65536))
	 (least-time (floor (- num (* 65536.0 most-time)))))
    (list most-time least-time 0)))


;;; 䴰ξ̴ؿ
(defun hnf-complete (alist)
  "䴰Ԥޤ"
  (hnf-complete-string (hnf-cur-word t) alist))

(defun hnf-complete-link ()
  "LINK䴰Ԥޤ"
  (let* ((cur (hnf-cur-word t))
	 (dname (file-name-directory cur))
	 (fname (file-name-nondirectory cur))
	 (files (file-name-all-completions
		 fname
		 (if (char-equal (string-to-char cur) ?/)
		     (concat hnf-document-root dname)
		   (concat hnf-html-dir "/" dname)))))
    (if dname (insert dname))
    (hnf-complete-string fname (mapcar 'list files))))

(defun hnf-complete-command (command-word)
  "ޥɤ䴰Ԥޤ"
  (let ((sts (hnf-complete hnf-commands)))
    (if (or (eq sts 'match)
	    (and (eq sts 'match1) (setq command-word (hnf-command-word))))
	(if (eq (cadr (assoc command-word hnf-commands)) 0)
	    (and hnf-complete-command-insert-newline-function
		 (funcall hnf-complete-command-insert-newline-function))
	  (and hnf-complete-command-insert-space-flag (insert " "))))
    sts))

;;; 䴰β̴ؿ
(defun hnf-complete-string (string alist)
  (let* ((completion-ignore-case t)
	 (completions (all-completions string alist))
	 (cur (current-buffer))
	 comp)
    (cond 
     ((= (length completions) 1) ; 䴰䤬1Ĥ
      (if (string= (car completions) string)
	  (progn
	    (insert string)
	    (hnf-delete-completion-window)
	    'match)
	(insert (car completions))
	'match1))
     ((and (setq comp (try-completion string alist))
	   (not (string= comp string))) ; ޤ䴰
      (insert comp)
      'complete)
     (t
      (insert string)
      (if (not comp) 
	  (progn ; 䤬ʤ
	    (hnf-delete-completion-window)
	    'no-match)
	; ɽ
	(buffer-disable-undo (get-buffer-create hnf-completion-buffer-name))
	(with-output-to-temp-buffer
	    hnf-completion-buffer-name
	  (display-completion-list (sort completions 'string<)))
	'complete-list)))))
  
(defun hnf-delete-completion-window ()
  (and
   (get-buffer hnf-completion-buffer-name)
   (let ((w (get-buffer-window hnf-completion-buffer-name)))
     (and w
	  (delete-window w))
     (kill-buffer hnf-completion-buffer-name))))

(run-hooks 'hnf-mode-load-hook)

(provide 'hnf-mode)
;;; hnf-mode.el ends here
