<?php

##
## Copyright (c) 1998,1999 NetUSE GmbH
##                    Boris Erdmann, Kristian Koehntopp
##
## Copyright (c) 1998,1999 Sascha Schumann <sascha@schumann.cx>
## 
## $Id: ct_sql.inc,v 1.1.2.1 2000/04/09 19:50:33 chuck Exp $
##
## PHPLIB Data Storage Container using a SQL database
##

class CT_Sql {
  ##
  ## Define these parameters by overwriting or by
  ## deriving your own class from it (recommened)
  ##
    
  var $database_table = "active_sessions";
  var $database_class = "DB_Sql";
  var $database_lock_semaphore = "";

  var $enc_methods = array(
    "base64"  => array("enc" => "base64_encode", "dec" => "base64_decode"),
    "slashes" => array("enc" => "addslashes",    "dec" => "strval")
  );
  var $encoding_mode = "base64";

  ## end of configuration

  var $db;

  function ac_start() {
    $name = $this->database_class;
    $this->db = new $name;
  }

  function ac_get_lock() {
    if ( "" != $this->database_lock_semaphore ) {
      $query = sprintf("SELECT get_lock('%s')", $this->database_lock_semaphore);
      while ( ! $this->db->query($query)) {
        $t = 1 + time(); while ( $t > time() ) { ; }
      }
    }
  }

  function ac_release_lock() {
    if ( "" != $this->database_lock_semaphore ) {
      $query = sprintf("SELECT release_lock('%s')", $this->database_lock_semaphore);
      $this->db->query($query);
    }
  }

  function ac_gc($gc_time, $name) {
    $timeout = time();
    $sqldate = date("YmdHis", $timeout - ($gc_time * 60));
    $this->db->query(sprintf("DELETE FROM %s WHERE changed < '%s' AND name = '%s'",
                    $this->database_table, 
                    $sqldate,
                    addslashes($name)));
    }

  function ac_store($id, $name, $str) {
    $ret = true;

    #encode > string='method:result'
    $cmd  = $this->enc_methods[$this->encoding_mode]["enc"];
    $str  = sprintf("%s:%s", $this->encoding_mode, $cmd($str));
    
    $name = addslashes($name);

    /* Fix by Thomas R. Shemanske <trs@hecke.dartmouth.edu> */
    //$now = date("YmdHis", time());
    $utime = explode(" ", microtime());
    $mtime = ereg_replace("^0", "", $utime[0]);
    $time = $utime[1];
    $now = date("YmdHis", $time) . $mtime;   
    /* End of fix */

    $uquery = sprintf("update %s set val='%s', changed='%s' where sid='%s' and name='%s'",
      $this->database_table,
      $str,
      $now,
      $id,
      $name);
    $iquery = sprintf("insert into %s ( sid, name, val, changed ) values ('%s', '%s', '%s', '%s')",
      $this->database_table,
      $id,
      $name,
      $str,
      $now);

    # This may look wierd, but SELECTing first and then doing the
    # right thing would nonatomic (in MySQL, where we cannot SELECT
    # FOR UPDATE). This is nonatomic, too, but keeps the window small.
    $this->db->query($uquery);
    if (  $this->db->affected_rows() == 0 
      && !$this->db->query($iquery)) {
        $ret = false;
    }
    return $ret;
  }

  function ac_delete($id, $name) {
    $this->db->query(sprintf("delete from %s where name = '%s' and sid = '%s'",
      $this->database_table,
      addslashes($name),
      $id));
  }

  function ac_get_value($id, $name) {

    $str = '';  
    $this->db->query( sprintf(
          "SELECT val FROM %s WHERE sid  = '%s' AND name = '%s'",
           $this->database_table, $id,  addslashes($name)) );

    if ( $this->db->next_record() ) {

      $str = $this->db->f('val');

      # get encoding method from (method:value) pair
      $colon_pos = strpos($str,':');
      $str_method = substr ( $str , 0 , $colon_pos );
      if( empty($str_method) ) { 
          // For compatibility with old sessions
          $str_method = "base64";
          $str_value  = $str;
      } else {
          // New format case
          $str_value  = substr ( $str , $colon_pos + 1 );
      }
      $cmd  = $this->enc_methods[$str_method]["dec"];

      $str  = $cmd($str_value);
    }

    return $str;
  }

  function ac_newid($str, $name) {
    return $str;
  }

  function ac_halt($s) {
    $this->db->halt($s);
  }

  ## provide your own encoding/decoding method(s)
  function set_enc_meth($name, $enc_func, $dec_func) {
    if (!isset($this->enc_methods[$name])) {
      $this->enc_methods[$name] = array ('enc'=> $enc_func, 'dec'=> $dec_func) ;
    }
  }

  function get_enc_meth($name) {
    return $this->enc_methods[$name];
  }
}
?>
