/* 
 *    XSitecopy, for managing remote web sites with a GNOME interface.
 *    Copyright (C) 1999, Lee Mallabone <lee0@callnetuk.com
 *                                                                      
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *   
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *    GNU General Public License for more details.
 *   
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "config.h"
#include <stdio.h>
#include <gnome.h>
#include "sites.h"
#include "rcfile.h"
#include "common.h"
#include "gcommon.h"
#include "init.h"
#include "misc.h"

/* The main gnome_app struct */
GtkWidget *sitecopy;

extern struct site_t *all_sites;
#ifdef DEBUGGING
extern int debug_mask;
#endif
gchar *current_name;
bool prompting = false;

/* Pixmaps that are used throughout. */

GdkPixmap *closed_dir, *open_dir;
GdkPixmap *red_file, *green_file, *orange_file;
GdkBitmap *dir1_map, *dir2_map;
GdkBitmap *red_file_map, *green_file_map, *orange_file_map;
/* Not very good naming, but it's legacy stuff. Only really for debugging 
   anyway. */
gint fancy_tree = 0;

int generate_pixmaps (void) {
   GtkStyle *style;
#include "Directory.xpm"
#include "Directory2.xpm"
#include "green_file.xpm"
#include "orange_file.xpm"
#include "red_file.xpm"
   
   style = gtk_widget_get_style (sitecopy);
   closed_dir = gdk_pixmap_create_from_xpm_d (sitecopy->window,
					      &dir1_map,
					      &style->bg[GTK_STATE_NORMAL],
					      (gchar **) DIRECTORY_CLOSE_XPM);
   open_dir = gdk_pixmap_create_from_xpm_d (sitecopy->window,
					    &dir2_map,
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar **) DIRECTORY_OPEN_XPM);
   green_file = gdk_pixmap_create_from_xpm_d (sitecopy->window,
					      &green_file_map,
					      &style->bg[GTK_STATE_NORMAL],
					      (gchar **) green_file_xpm);
   orange_file = gdk_pixmap_create_from_xpm_d (sitecopy->window,
					       &orange_file_map,
					       &style->bg[GTK_STATE_NORMAL],
					       (gchar **) orange_file_xpm);
   red_file = gdk_pixmap_create_from_xpm_d (sitecopy->window,
					    &red_file_map,
					    &style->bg[GTK_STATE_NORMAL],
					    (gchar **) red_file_xpm);
   return 1;
}

int
main (int argc, char *argv[]) {

   static const struct poptOption options[] = {
#ifdef DEBUGGING
     {"debug", 'd', POPT_ARG_INT, &debug_mask, 0, N_("Debugging level (sum of: 1=socket, 2=files, 4=rcfile, 8=WebDAV, 16=FTP, 32=XML, 64=GNOME )"), "LEVEL"},
#endif
     {"flat-tree", '\0', POPT_ARG_NONE, &fancy_tree, 0, N_("Flat Tree - all files are displayed only one level below their site."), NULL},

     {NULL, '\0', 0, NULL, 0}
   };
   gnome_init_with_popt_table ("Sitecopy", VERSION, argc, argv,
			       options, 0, NULL);

   DEBUG (64, "flat_tree arg is %d.\n", fancy_tree);
   if (fancy_tree) {
     fancy_tree = FALSE;
   } else {
     fancy_tree = TRUE;
   }

   /* Configuration / Gnome initialisation */
   fe_gnome_init ();
   sitecopy = gnome_app_new ("xsc", "XSitecopy");
   gtk_signal_connect (GTK_OBJECT (sitecopy), "delete_event",
		       GTK_SIGNAL_FUNC(quit_please), NULL);
   gtk_widget_realize (sitecopy);
   generate_pixmaps ();

   /* Blurb that is probably deprecated */
   current_name = malloc (BUFSIZ);
   strcpy (current_name, "none");
   
   /* Create the GUI and hit the main loop */
   create_main_window();   

   gtk_main ();
   return 1;
}
 
