#include <sys/stat.h>
#include <unistd.h>
#include <string.h>

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <gdk/gdkkeysyms.h>
#include <gnome.h>
#include "sites.h"

#include "misc.h"
#include "new_site.h"
#include "mguru.h"

struct create_site_widget_set *new_site_widgets;
GtkWidget *new_wizard, *vbox1, *vbox2, *vbox3, *vbox4, *vbox5, *vbox10, *vbox12;
GtkWidget *dia = NULL;
gint valid_fields;
gchar *new_proto = "ftp";
gchar *new_perms = "ignore";
gchar *new_sym = "ignore";

void name_done (GtkWidget *name_entry, GdkEvent *event, gpointer data) {
  printf ("focus just left the name entry.\n");
}

void set_proto (GtkWidget *menu_item, gpointer data) {
  new_proto = (char *) data;
}
void set_perms (GtkWidget *menu_item, gpointer data) {
  new_perms = (char *) data;
}
void set_sym (GtkWidget *menu_item, gpointer data) {
  new_sym = (char *) data;
}

GtkWidget*
create_new_wiz_book (void)
{

  GtkWidget *notebook2;

  GtkWidget *label10;
  GtkWidget *label11;
  GtkWidget *frame2;
  GtkWidget *vbox7;
  GtkWidget *hbox1;
  GtkWidget *label16;

  GtkWidget *hbox2;
  GtkWidget *label19;
  GtkWidget *glade_menuitem;

  GtkWidget *label14;
  GtkWidget *label15;
  GtkWidget *frame3;
  GtkWidget *vbox8;
  GtkWidget *hbox3;
  GtkWidget *label20;

  GtkWidget *hbox4;
  GtkWidget *label21;

  GtkWidget *label22;
  GtkWidget *label23;
  GtkWidget *frame4;
  GtkWidget *hbox5;
  GtkWidget *label26;


  GtkWidget *label25;
  GtkWidget *label27;
  GtkWidget *frame5;
  GtkWidget *vbox9;
  GtkWidget *hbox6;
  GtkWidget *label28;

  GtkWidget *hbox7;
  GtkWidget *label29;

  GtkWidget *label31;
  GtkWidget *label32;
  GtkWidget *frame1;
  GtkWidget *vbox6;

  GtkWidget *label34;
  GtkWidget *label35;
  GtkWidget *frame6;
  GtkWidget *vbox11;
  GtkWidget *hbox8;
  GtkWidget *label36;
  GtkWidget *hbox9;
  GtkWidget *label37;

  GtkWidget *label39;
  GtkWidget *label40;
  GtkWidget *frame7;
  GtkWidget *vbox13;
  GSList *vbox13_group = NULL;
  GtkWidget *radiobutton1;
  GtkWidget *radiobutton2;
  GtkWidget *label7;
  GtkWidget *label8;
  GtkWidget *label9;
  GtkWidget *label24;
  GtkWidget *label30;
  GtkWidget *label33;
  GtkWidget *label38;

  struct create_site_widget_set *widgets;
  new_site_widgets = malloc (sizeof (struct create_site_widget_set));
  widgets = new_site_widgets;

  notebook2 = gtk_notebook_new ();
  gtk_widget_show (notebook2);

  vbox1 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox1);
  /*  gtk_container_add (GTK_CONTAINER (notebook2), vbox1);*/
  gtk_container_set_border_width (GTK_CONTAINER (vbox1), 5);

  label10 = gtk_label_new (_("Create a new site definition!"));
  gtk_widget_show (label10);
  gtk_box_pack_start (GTK_BOX (vbox1), label10, FALSE, FALSE, 0);
  gtk_widget_set_usize (label10, 208, 24);

  label11 = gtk_label_new (_("This wizard will help you create a new website definition that XSitecopy can use.\n\nThis involves getting details about your remote web server,\nand information about how you store the website locally.\n\nFirst, I need to know the hostname of the remote site, and the protocol I should use\nto connect to it."));
  gtk_widget_show (label11);
  gtk_box_pack_start (GTK_BOX (vbox1), label11, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label11), GTK_JUSTIFY_FILL);

  frame2 = gtk_frame_new (_("Remote server details"));
  gtk_widget_show (frame2);
  gtk_box_pack_start (GTK_BOX (vbox1), frame2, FALSE, TRUE, 10);

  vbox7 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox7);
  gtk_container_add (GTK_CONTAINER (frame2), vbox7);
  gtk_container_set_border_width (GTK_CONTAINER (vbox7), 3);

   hbox1 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox1);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox1), 3);

  label16 = gtk_label_new (_("Hostname: "));
  gtk_widget_show (label16);
  gtk_box_pack_start (GTK_BOX (hbox1), label16, FALSE, FALSE, 0);

  widgets->hostname_choice = gtk_entry_new ();
  gtk_widget_show (widgets->hostname_choice);
  gtk_box_pack_end (GTK_BOX (hbox1), widgets->hostname_choice, TRUE, TRUE, 0);

  hbox2 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (vbox7), hbox2, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox2), 2);

  label19 = gtk_label_new (_("Protocol: "));
  gtk_widget_show (label19);
  gtk_box_pack_start (GTK_BOX (hbox2), label19, FALSE, FALSE, 0);

  widgets->protocol_choice = gtk_option_menu_new ();
  gtk_widget_show (widgets->protocol_choice);
  gtk_box_pack_start (GTK_BOX (hbox2), widgets->protocol_choice, FALSE, FALSE, 0);
  widgets->protocol_choice_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("FTP"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		      GTK_SIGNAL_FUNC (set_proto), "ftp");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (widgets->protocol_choice_menu), glade_menuitem);
#ifdef USE_DAV
  glade_menuitem = gtk_menu_item_new_with_label (_("WebDAV"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		      GTK_SIGNAL_FUNC (set_proto), "webdav");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (widgets->protocol_choice_menu), glade_menuitem);
#endif
  gtk_option_menu_set_menu (GTK_OPTION_MENU (widgets->protocol_choice), widgets->protocol_choice_menu);

  vbox2 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox2);
  /*  gtk_container_add (GTK_CONTAINER (notebook2), vbox2);*/
  gtk_container_set_border_width (GTK_CONTAINER (vbox2), 5);

  label14 = gtk_label_new (_("Authentication Details"));
  gtk_widget_show (label14);
  gtk_box_pack_start (GTK_BOX (vbox2), label14, FALSE, FALSE, 0);

  label15 = gtk_label_new (_("In order to connect to your remote web server, I need to know\nyour user name and password. At this point you should also\ngive the site a 'friendly' name that you can reference it by.\n\nThe password will not be visible on-screen."));
  gtk_widget_show (label15);
  gtk_box_pack_start (GTK_BOX (vbox2), label15, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label15), GTK_JUSTIFY_FILL);

  frame3 = gtk_frame_new (_("Login details"));
  gtk_widget_show (frame3);
  gtk_box_pack_start (GTK_BOX (vbox2), frame3, FALSE, TRUE, 10);

  vbox8 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox8);
  gtk_container_add (GTK_CONTAINER (frame3), vbox8);
  gtk_container_set_border_width (GTK_CONTAINER (vbox8), 3);

   hbox3 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox3), 3);

  label20 = gtk_label_new (_("Friendly name: "));
  gtk_widget_show (label20);
  gtk_box_pack_start (GTK_BOX (hbox3), label20, FALSE, FALSE, 0);

  widgets->name = gtk_entry_new ();
  /*  gtk_signal_connect (GTK_OBJECT (widgets->name), "focus-out-event",
      GTK_SIGNAL_FUNC (name_done), NULL);*/
  gtk_widget_show (widgets->name);
  gtk_box_pack_start (GTK_BOX (hbox3), widgets->name, TRUE, TRUE, 0);

  hbox3 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox3);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox3, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox3), 3);

  label20 = gtk_label_new (_("Username: "));
  gtk_widget_show (label20);
  gtk_box_pack_start (GTK_BOX (hbox3), label20, FALSE, FALSE, 0);

  widgets->username_choice = gtk_entry_new ();
  gtk_widget_show (widgets->username_choice);
  gtk_box_pack_start (GTK_BOX (hbox3), widgets->username_choice, TRUE, TRUE, 0);

  hbox4 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox4);
  gtk_box_pack_start (GTK_BOX (vbox8), hbox4, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox4), 3);

  label21 = gtk_label_new (_("Password: "));
  gtk_widget_show (label21);
  gtk_box_pack_start (GTK_BOX (hbox4), label21, FALSE, FALSE, 0);

  widgets->password_choice = gtk_entry_new ();
  gtk_widget_show (widgets->password_choice);
  gtk_box_pack_start (GTK_BOX (hbox4), widgets->password_choice, TRUE, TRUE, 0);
  gtk_entry_set_visibility (GTK_ENTRY (widgets->password_choice), FALSE);

  vbox3 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox3);
  /*  gtk_container_add (GTK_CONTAINER (notebook2), vbox3);*/
  gtk_container_set_border_width (GTK_CONTAINER (vbox3), 5);

  label22 = gtk_label_new (_("Hard drive information"));
  gtk_widget_show (label22);
  gtk_box_pack_start (GTK_BOX (vbox3), label22, FALSE, FALSE, 0);

  label23 = gtk_label_new (_("I now need to know the directory where you store the files for your website.\nThis should be an absolute directory path (and end with a trailing '/' character)."));
  gtk_widget_show (label23);
  gtk_box_pack_start (GTK_BOX (vbox3), label23, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label23), GTK_JUSTIFY_FILL);

  frame4 = gtk_frame_new (_("Filing details"));
  gtk_widget_show (frame4);
  gtk_box_pack_start (GTK_BOX (vbox3), frame4, FALSE, TRUE, 10);

  hbox5 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox5);
  gtk_container_add (GTK_CONTAINER (frame4), hbox5);
  gtk_container_set_border_width (GTK_CONTAINER (hbox5), 3);

  label26 = gtk_label_new (_("Local website root: "));
  gtk_widget_show (label26);
  gtk_box_pack_start (GTK_BOX (hbox5), label26, FALSE, FALSE, 0);

  widgets->local_choice = gnome_file_entry_new ("hello", 0);
  gtk_widget_show (widgets->local_choice);
  gtk_box_pack_start (GTK_BOX (hbox5), widgets->local_choice, TRUE, TRUE, 0);
  gnome_file_entry_set_title (GNOME_FILE_ENTRY (widgets->local_choice), _("Locate the website's local directory"));
  gnome_file_entry_set_directory (GNOME_FILE_ENTRY (widgets->local_choice), TRUE);

  vbox4 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox4);
  /*  gtk_container_add (GTK_CONTAINER (notebook2), vbox4);*/
  gtk_container_set_border_width (GTK_CONTAINER (vbox4), 5);

  label25 = gtk_label_new (_("Remote information"));
  gtk_widget_show (label25);
  gtk_box_pack_start (GTK_BOX (vbox4), label25, FALSE, FALSE, 0);

  label27 = gtk_label_new (_("Now I need to know something about where on the remote server you store your files.\nThe directory they are stored in can be specified as either \nan absolute location, (ie. relative to the hostname itself), or\nrelative to the current working directory. \n(This is where you normally start after logging into your\nremote server manually).\n\nHence, the remote directory path should begin with a '/' or '~/' respectively.\n\nYour site's \"root URL\" is the actual web address you use to access your site's start page.\nThis is used in creation of reports only."));
  gtk_widget_show (label27);
  gtk_box_pack_start (GTK_BOX (vbox4), label27, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label27), GTK_JUSTIFY_FILL);
  gtk_misc_set_padding (GTK_MISC (label27), 0, 5);

  frame5 = gtk_frame_new (_("Network Information"));
  gtk_widget_show (frame5);
  gtk_box_pack_start (GTK_BOX (vbox4), frame5, FALSE, FALSE, 10);

  vbox9 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox9);
  gtk_container_add (GTK_CONTAINER (frame5), vbox9);
  gtk_container_set_border_width (GTK_CONTAINER (vbox9), 3);

  hbox6 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox6);
  gtk_box_pack_start (GTK_BOX (vbox9), hbox6, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox6), 3);

  label28 = gtk_label_new (_("Remote directory: "));
  gtk_widget_show (label28);
  gtk_box_pack_start (GTK_BOX (hbox6), label28, FALSE, FALSE, 0);

  widgets->remotedir_choice = gtk_entry_new ();
  gtk_widget_show (widgets->remotedir_choice);
  gtk_box_pack_start (GTK_BOX (hbox6), widgets->remotedir_choice, TRUE, TRUE, 0);

  hbox7 = gtk_hbox_new (FALSE, 6);
  gtk_widget_show (hbox7);
  gtk_box_pack_start (GTK_BOX (vbox9), hbox7, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (hbox7), 3);

  label29 = gtk_label_new (_("Site's root URL:"));
  gtk_widget_show (label29);
  gtk_box_pack_start (GTK_BOX (hbox7), label29, FALSE, FALSE, 0);

  widgets->url_choice = gtk_entry_new ();
  gtk_widget_show (widgets->url_choice);
  gtk_box_pack_start (GTK_BOX (hbox7), widgets->url_choice, TRUE, TRUE, 0);

  vbox5 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox5);

  gtk_container_set_border_width (GTK_CONTAINER (vbox5), 5);

  label31 = gtk_label_new (_("Update options"));
  gtk_widget_show (label31);
  gtk_box_pack_start (GTK_BOX (vbox5), label31, FALSE, FALSE, 0);

  label32 = gtk_label_new (_("When uploading your web site's changes, there are various\n'tweakable' things that XSitecopy can do. Those options are\nprovided below, with sensible defaults.\n"));
  gtk_widget_show (label32);
  gtk_box_pack_start (GTK_BOX (vbox5), label32, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label32), GTK_JUSTIFY_FILL);

  frame1 = gtk_frame_new (_("Update behaviour"));
  gtk_widget_show (frame1);
  gtk_box_pack_start (GTK_BOX (vbox5), frame1, FALSE, FALSE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (frame1), 4);

  vbox6 = gtk_vbox_new (TRUE, 2);
  gtk_widget_show (vbox6);
  gtk_container_add (GTK_CONTAINER (frame1), vbox6);
  gtk_container_set_border_width (GTK_CONTAINER (vbox6), 3);

  widgets->checkdelete_choice = gtk_check_button_new_with_label (_("Delete a remote file if the corresponding local file is deleted."));
  gtk_widget_show (widgets->checkdelete_choice);
  gtk_box_pack_start (GTK_BOX (vbox6), widgets->checkdelete_choice, FALSE, FALSE, 0);

  widgets->checkmove_choice = gtk_check_button_new_with_label (_("Move a remote file if its local equivalent is moved."));
  gtk_widget_show (widgets->checkmove_choice);
  gtk_box_pack_start (GTK_BOX (vbox6), widgets->checkmove_choice, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widgets->checkmove_choice), TRUE);

  widgets->passiveftp_choice = gtk_check_button_new_with_label (_("Use passive mode FTP, (recommended)."));
  gtk_widget_show (widgets->passiveftp_choice);
  gtk_box_pack_start (GTK_BOX (vbox6), widgets->passiveftp_choice, FALSE, FALSE, 0);
  gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (widgets->passiveftp_choice), TRUE);

  widgets->deletefirst_choice = gtk_check_button_new_with_label (_("When uploading changed files, first delete them."));
  gtk_widget_show (widgets->deletefirst_choice);
  gtk_box_pack_start (GTK_BOX (vbox6), widgets->deletefirst_choice, FALSE, FALSE, 0);

  vbox10 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox10);

  gtk_container_set_border_width (GTK_CONTAINER (vbox10), 5);

  label34 = gtk_label_new (_("File handling"));
  gtk_widget_show (label34);
  gtk_box_pack_start (GTK_BOX (vbox10), label34, FALSE, FALSE, 0);

  label35 = gtk_label_new (_("XSitecopy is capable of ensuring that the permission \nsettings of all your files are fully maintained. Alternatively,\nyou may only wish executable files to remain executable, or\nmay not care about permissions at all.\n\nSymbolic links are also handled according to your choice. "));
  gtk_widget_show (label35);
  gtk_box_pack_start (GTK_BOX (vbox10), label35, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label35), GTK_JUSTIFY_FILL);

  frame6 = gtk_frame_new (_("File options"));
  gtk_widget_show (frame6);
  gtk_box_pack_start (GTK_BOX (vbox10), frame6, FALSE, FALSE, 10);

  vbox11 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox11);
  gtk_container_add (GTK_CONTAINER (frame6), vbox11);
  gtk_container_set_border_width (GTK_CONTAINER (vbox11), 3);

  hbox8 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox8);
  gtk_box_pack_start (GTK_BOX (vbox11), hbox8, TRUE, TRUE, 0);

  label36 = gtk_label_new (_("File permissions: "));
  gtk_widget_show (label36);
  gtk_box_pack_start (GTK_BOX (hbox8), label36, FALSE, FALSE, 0);

  widgets->perms_choice = gtk_option_menu_new ();
  gtk_widget_show (widgets->perms_choice);
  gtk_box_pack_start (GTK_BOX (hbox8), widgets->perms_choice, FALSE, FALSE, 0);
  widgets->perms_choice_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("Ignore all"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		      GTK_SIGNAL_FUNC (set_perms), "ignore");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (widgets->perms_choice_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Executables only"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		      GTK_SIGNAL_FUNC (set_perms), "exec");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (widgets->perms_choice_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Maintain for all"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		      GTK_SIGNAL_FUNC (set_perms), "maintain");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (widgets->perms_choice_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (widgets->perms_choice), widgets->perms_choice_menu);

  hbox9 = gtk_hbox_new (FALSE, 0);
  gtk_widget_show (hbox9);
  gtk_box_pack_start (GTK_BOX (vbox11), hbox9, TRUE, TRUE, 0);

  label37 = gtk_label_new (_("Symbolic links: "));
  gtk_widget_show (label37);
  gtk_box_pack_start (GTK_BOX (hbox9), label37, FALSE, FALSE, 0);

  widgets->sym_choice = gtk_option_menu_new ();
  gtk_widget_show (widgets->sym_choice);
  gtk_box_pack_start (GTK_BOX (hbox9), widgets->sym_choice, FALSE, FALSE, 0);
  widgets->sym_choice_menu = gtk_menu_new ();
  glade_menuitem = gtk_menu_item_new_with_label (_("Ignore links"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		      GTK_SIGNAL_FUNC (set_sym), "ignore");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (widgets->sym_choice_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Follow all"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		      GTK_SIGNAL_FUNC (set_sym), "follow");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (widgets->sym_choice_menu), glade_menuitem);
  glade_menuitem = gtk_menu_item_new_with_label (_("Maintain links"));
  gtk_signal_connect (GTK_OBJECT (glade_menuitem), "activate",
		      GTK_SIGNAL_FUNC (set_sym), "maintain");
  gtk_widget_show (glade_menuitem);
  gtk_menu_append (GTK_MENU (widgets->sym_choice_menu), glade_menuitem);
  gtk_option_menu_set_menu (GTK_OPTION_MENU (widgets->sym_choice), widgets->sym_choice_menu);

  vbox12 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox12);

  gtk_container_set_border_width (GTK_CONTAINER (vbox12), 5);

  label39 = gtk_label_new (_("State of the remote site"));
  gtk_widget_show (label39);
  gtk_box_pack_start (GTK_BOX (vbox12), label39, FALSE, FALSE, 0);

  label40 = gtk_label_new (_("In order to keep your remote website totally in sync with the local site, \nI need to know if you have uploaded your local site yet, or if that task\nis still to be completed.\n\nIf you give the wrong answer, don't worry - a site can be 'caught up' \nor initialised at any time."));
  gtk_widget_show (label40);
  gtk_box_pack_start (GTK_BOX (vbox12), label40, TRUE, TRUE, 0);
  gtk_label_set_justify (GTK_LABEL (label40), GTK_JUSTIFY_FILL);

  frame7 = gtk_frame_new (_("Remote site is currently"));
  gtk_widget_show (frame7);
  gtk_box_pack_start (GTK_BOX (vbox12), frame7, FALSE, FALSE, 10);

  vbox13 = gtk_vbox_new (FALSE, 0);
  gtk_widget_show (vbox13);
  gtk_container_add (GTK_CONTAINER (frame7), vbox13);
  gtk_container_set_border_width (GTK_CONTAINER (vbox13), 3);

  widgets->init_choice = gtk_radio_button_new_with_label (vbox13_group, _("Empty"));
  vbox13_group = gtk_radio_button_group (GTK_RADIO_BUTTON (widgets->init_choice));
  gtk_widget_show (widgets->init_choice);
  gtk_box_pack_start (GTK_BOX (vbox13), widgets->init_choice, FALSE, FALSE, 0);

  widgets->catchup_choice = gtk_radio_button_new_with_label (vbox13_group, _("Uploaded"));
  vbox13_group = gtk_radio_button_group (GTK_RADIO_BUTTON (widgets->catchup_choice));
  gtk_widget_show (widgets->catchup_choice);
  gtk_box_pack_start (GTK_BOX (vbox13), widgets->catchup_choice, FALSE, FALSE, 0);

  label7 = gtk_label_new (_("host/protocol"));
  gtk_widget_show (label7);

  gtk_label_set_justify (GTK_LABEL (label7), GTK_JUSTIFY_LEFT);

  label8 = gtk_label_new (_("user/pass"));
  gtk_widget_show (label8);


  label9 = gtk_label_new (_("local"));
  gtk_widget_show (label9);


  label24 = gtk_label_new (_("remote"));
  gtk_widget_show (label24);


  label30 = gtk_label_new (_("updateopts"));
  gtk_widget_show (label30);


  label33 = gtk_label_new (_("File handling"));
  gtk_widget_show (label33);


  label38 = gtk_label_new (_("state"));
  gtk_widget_show (label38);


  return notebook2;
}

void close_wizard (void) {
  gtk_widget_destroy (dia);
  dia = NULL;
}

void start_new_site_wizard(void) {

  /*#include "sidebar.xpm"*/
  GtkWidget *side_image;

   /* Bring the wizard to the front if it already exists */

   printf ("started function.\n");
   if (dia) {
      gdk_window_raise (dia->window);
      gdk_window_show (dia->window);
      return;
   }
   printf ("creating...");
   create_new_wiz_book();
   printf ("boxes...");
   dia = gnome_dialog_new("Fill out details about your website.", NULL);
   printf ("dialog...");
   
   /*   side_image = gnome_pixmap_new_from_xpm_d (sidebar_xpm);
   printf ("image... ");
   
   gtk_widget_show (side_image);*/
  new_wizard = gnome_mguru_new(TRUE, GNOME_DIALOG(dia), NULL);

  gnome_mguru_append_page (GNOME_MGURU (new_wizard), vbox1,
			   "Welcome to the new site wizard.");
  gnome_mguru_append_page (GNOME_MGURU (new_wizard), vbox2,
			   "Authentication.");
  gnome_mguru_append_page (GNOME_MGURU (new_wizard), vbox3,
			   "Local information.");
  gnome_mguru_append_page (GNOME_MGURU (new_wizard), vbox4,
			   "Remote details.");
  gnome_mguru_append_page (GNOME_MGURU (new_wizard), vbox5,
			   "Update options.");
  gnome_mguru_append_page (GNOME_MGURU (new_wizard), vbox10,
			   "File handling.");
  gnome_mguru_append_page (GNOME_MGURU (new_wizard), vbox12,
			   "State of the remote site.");
  gtk_signal_connect_object (GTK_OBJECT (new_wizard), "next",
			     gnome_mguru_next_page, (gpointer) new_wizard);
  gtk_signal_connect (GTK_OBJECT (GNOME_MGURU(new_wizard)->button[MGURU_BUTTON_APPLY]), "clicked",
		      GTK_SIGNAL_FUNC (add_site), new_site_widgets);
  /*  gtk_signal_connect_after (GTK_OBJECT (GNOME_MGURU(new_wizard)->button[MGURU_BUTTON_APPLY]), "clicked",
      GTK_SIGNAL_FUNC (close_wizard), NULL);*/
  
  gtk_signal_connect (GTK_OBJECT (new_wizard), "prev",
		      gnome_mguru_prev_page, NULL);
  gtk_signal_connect (GTK_OBJECT (new_wizard), "cancel",
		      close_wizard, NULL);
  gtk_widget_show_all (dia);
}




