# Note that this is NOT a relocatable package
%define ver     0.8.4
%define rel     1
%define prefix  /usr

Summary:   Local->Remote website synchronizer.
Name:      sitecopy
Version:   %ver
Release:   %rel
Copyright: GPL
Group:     Applications/Networking
Source0:   http://www.lyra.org/sitecopy/sitecopy-%{PACKAGE_VERSION}.tar.gz
URL:       http://www.lyra.org/sitecopy
BuildRoot: /var/tmp/sitecopy-%{PACKAGE_VERSION}-root

%description
sitecopy is for copying locally stored websites to remote web servers.
The program will upload files to the server which have changed
locally, and delete files from the server which have been removed
locally, to keep the remote site synchronized with the local site,
with a single command.  The aim is to remove the hassle of uploading
and deleting individual files using an FTP client.

%package -n xsitecopy
Summary:  Sitecopy website synchronization utility. (GNOME version)
Group:    X11/Applications/Networking
%description -n xsitecopy
XSitecopy is the gnome version of sitecopy. Currently it does not support
"fetch mode" or "resynch", but it does have the advantage of providing full
configuration editing facilities.

%prep
%setup

%build
# vanilla sitecopy.
CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ./configure \
	--prefix=%{prefix} \
	--enable-debugging
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi
make prefix=$RPM_BUILD_ROOT%{prefix} install-sitecopy
# xsitecopy.
CFLAGS="$RPM_OPT_FLAGS" LDFLAGS="-s" ./configure \
	--prefix=%{prefix} \
	--enable-gnomefe \
	--enable-debugging
if [ "$SMP" != "" ]; then
  (make "MAKE=make -k -j $SMP"; exit 0)
  make
else
  make
fi

%install
echo $RPM_BUILD_ROOT
install -d $RPM_BUILD_ROOT
#install -d $RPM_BUILD_ROOT/usr/{share,share/gnome,share/gnome/apps,share/gnome/apps/Internet}
#install -d $RPM_BUILD_ROOT/usr/{share/gnome/help,share/gnome/help/xsitecopy,share/gnome/help/xsitecopy/C}

make prefix=$RPM_BUILD_ROOT%{prefix} install-xsitecopy

%clean
rm -rf $RPM_BUILD_ROOT

%files -n sitecopy
%defattr(-, root, root)
%{prefix}/bin/sitecopy
%doc COPYING README ChangeLog
%{prefix}/man/man1/*

%files -n xsitecopy
%defattr(-, root, root)
%dir %{prefix}/share/gnome/help/xsitecopy
%dir %{prefix}/share/gnome/help/xsitecopy/C
%{prefix}/share/gnome/help/xsitecopy/C/*.html
%{prefix}/share/gnome/help/xsitecopy/C/topic.dat
%{prefix}/share/gnome/apps/Internet/*.desktop
%{prefix}/bin/xsitecopy

%changelog
* Mon Jul 26 1999 Joe Orton <joe@orton.demon.co.uk>
- Enabled debugging for sitecopy and xsitecopy.

* Fri May 28 1999 Dobrica Pavlinusic <dpavlin@foi.hr>
- integrated into GNU configure to automaticly pick up version number

* Sat Apr 3 1999 Lee Mallabone <lee0@callnetuk.com>
- After a few tweaks, it now actually works. :)

* Thu Apr 1 1999 Lee Mallabone <lee0@callnetuk.com>
- first attempt.

