// 
// $Id: main.cpp,v 1.7 1999/08/15 01:57:54 amos Exp $
//
// Main body implementation
//
// Jan Borsodi <amos@abn.hibu.no>
// Created on: <14-Jul-1999 19:14:44 amos>
//

#include <qapplication.h>
#include "qaregexp.hpp"
#include "qaregexperror.hpp"
#include <qstring.h>
#include <qfile.h>
#include <qtextstream.h>
#include <unistd.h>

int main( int, char ** )
{
    // Will not match the wanted subexpression
    try
    {
        QaRegExp reg( "([a-zA-Z]+)[ \t]+([a-z]+)(::)([a-zA-Z]+)" );
        if ( reg.match( "blah aaaa:::bbbb", 2 ) )
        {
            QaRegExpMatch m = reg.matches();
            int i = 0;
            for ( QStringList::ConstIterator it = m.toString().begin(); it != m.toString().end(); ++it, ++i )
            {
                qDebug( "%d# = \"%s\", [%d-%d]", i, (*it).ascii(), m[i].start(), m[i].end() );
            }
        }
        else
            qDebug( "No match found" );
    }
    catch ( QaRegExpError &e )
    {
        qDebug( e.error() );
    }

    // Matches multiple times against a regexp and extracts the given subexpression each time.
    try
    {
        QaRegExp reg( "(([a-zA-Z0-9.]+)@([a-zA-Z0-9.]+))[ \t]*,?[ \t]*" );
        int matches;
        if ( ( matches = reg.matchMultiple( "amos@abn.hibu.no, amos@agurk, a2b@d.2, lot of bullshit", 1 ) ) > 0 )
        {
            qDebug( "Found %d matches", matches );
            QaRegExpMatch m = reg.matches();
            int i = 0;
            for ( QStringList::ConstIterator it = m.toString().begin(); it != m.toString().end(); ++it, ++i )
            {
                qDebug( "\"%s\", [%d-%d]", (*it).ascii(), m[i].start(), m[i].end() );
            }
        }
    }
    catch ( QaRegExpError &e )
    {
        qDebug( e.error() );
    }

    // This example splits up the using a html like tag (<>) for delimiter.
    try
    {
        QaRegExp reg( "<[^>]*>" );
        reg.split( "first value<b>2. in line<href=\"/\">last to go" );
        QaRegExpMatch m = reg.matches();
        int i = 0;
        for ( QStringList::ConstIterator it = m.toString().begin(); it != m.toString().end(); ++it, ++i )
        {
            qDebug( "\"%s\", [%d-%d]", (*it).ascii(), m[i].start(), m[i].end() );
        }
    }
    catch ( QaRegExpError &e )
    {
        qDebug( e.error() );
    }

    // Matches against a typical assignment, variable = value.
    try
    {
        QaRegExp reg( "([a-zA-Z]+)[ \t]*=[ \t]*([a-zA-Z]+)" );
        if ( reg.match( "RegTest = SomeValue" ) )
        {
            QaRegExpMatch m = reg.matches();
            int i = 0;
            for ( QStringList::ConstIterator it = m.toString().begin(); it != m.toString().end(); ++it, ++i )
            {
                qDebug( "%d# = \"%s\", [%d-%d]", i, (*it).ascii(), m[i].start(), m[i].end() );
            }
        }
    }
    catch ( QaRegExpError &e )
    {
        qDebug( e.error() );
    }

    // A bigger example, reads out the user, nice, system and idle ticks from /proc/stat
    // Supports SMP ( 2 or more processors).
    // The output is cpu <user> <nice> <system> <idle>
    // if you have more than one processor the output is also
    // cpu number # <user> <nice> <system> <idle>
    // for each processor
    try
    {
        int i = 0;
        while ( i < 10 )
        {
            QFile f( "/proc/stat" );
            if ( f.open( IO_ReadOnly ) )
            {
                QTextStream s( &f );
                QaRegExp reg( "(cpu[0-9]*)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]+)[ \t]+([0-9]+)" );
                bool ok = true;
                while ( ok )
                {
                    QString tmp = s.readLine();
                    if ( reg.match( tmp ) )
                    {
                        QaRegExpMatch m = reg.matches();
                        QStringList l = m.toString();
                        QString cpuid = l[1];
                        int user = l[2].toInt();
                        int nice = l[3].toInt();
                        int system = l[4].toInt();
                        int idle = l[5].toInt();
                        if ( cpuid == "cpu" )
                            qDebug( "total cpu %d, %d, %d, %d", user, nice, system, idle );
                        else
                        {
                            QaRegExp cpureg( "cpu([0-9]+)" );
                            if ( cpureg.match( cpuid, 1 ) )
                            {
                                int id = cpureg.matchString( 1 ).toInt();
                                qDebug( "cpu number %d, %d, %d, %d, %d", id, user, nice, system, idle );
                            }
                        }
                    }
                    else
                        ok = false;
                }
                sleep( 2 );
            }
            else
                qDebug( "Error opening file /dev/stat" );
            f.close();
            i++;
        }
    }
    catch ( QaRegExpError &e )
    {
        qDebug( e.error() );
    }

    return 0;
}
