;; transient.jl -- support transient windows
;; $Id: transient.jl,v 1.29 1999/12/02 16:57:28 john Exp $

;; Copyright (C) 1999 John Harper <john@dcs.warwick.ac.uk>

;; This file is part of sawmill.

;; sawmill is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; sawmill is distributed in the hope that it will be useful, but
;; WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with sawmill; see the file COPYING.  If not, write to
;; the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

(provide 'transient)

(defcustom focus-windows-when-mapped nil
  "Focus each window when first displayed."
  :type boolean
  :group focus)

(defcustom transients-get-focus t
  "Transient windows inherit focus from their parent."
  :group focus
  :type boolean)


;; hooks

(defun transient-map-window (w)
  (let
      ((set-focus nil))
    (when (window-transient-p w)
      (let
	  ((parent (get-window-by-id (window-transient-p w))))
	(when parent
	  (when (and transients-get-focus
		     (eq (input-focus) parent)
		     (window-really-wants-input-p w))
	    (set-input-focus w)
	    (setq set-focus t)))))
    (when (and (not set-focus)
	       focus-windows-when-mapped
	       (window-really-wants-input-p w))
      (set-input-focus w))))

;; If a transient window gets unmapped that currently has the input
;; focus, pass it (the focus) to its parent. Otherwise, pass the focus
;; to the topmost window if click-to-focus, otherwise the window under
;; the mouse
(defun transient-unmap-window (w)
  (when (eq (input-focus) w)
    (let
	((parent (and (window-transient-p w)
		      (get-window-by-id (window-transient-p w)))))
      (unless parent
	;; if no parent, choose the topmost window (if in click-to-focus
	;; mode) or the window under the pointer otherwise
	(unless (eq focus-mode 'click)
	  (setq parent (query-pointer-window)))
	(unless (or parent (eq focus-mode 'enter-exit))
	  (setq parent (car (window-order current-workspace)))))
      (when (or (null parent) (window-really-wants-input-p parent))
	(set-input-focus parent)))))

(add-hook 'map-notify-hook transient-map-window)
(add-hook 'unmap-notify-hook transient-unmap-window)
(add-hook 'iconify-window-hook transient-unmap-window)
