/*
 * Copyright (c) 1999 Ivo van der Wijk
 * 
 * The tux image is (c) Larry Ewing (lewing@isc.tamu.edu)
 * The dustpuppy image is (c) Illiad (http://www.userfriendly.org)
 * The bsd daemon ("Chuck") is (c) Eric Green
 * The luxus image is (c) Urs M. E. Streidl (http://www.gigaperls.org/linux/)
 * 
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 * notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote products
 * derived from this software without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _FIGURE_H
#define _FIGURE_H

#include <qimage.h>
#include <qpixmap.h>

class	figure
{
protected:
	// these values have to determined by examining the picture
	int	leftEyeX;
	int	leftEyeY;
	int	rightEyeX;
	int	rightEyeY;
	int	leftPupilRadius;
	int	rightPupilRadius;
	int	eyeXOffset;
	int	eyeYOffset;
	// xpm's - original
	QPixmap	tuxOrig;
	QPixmap tuxMaskXPM;
	QPixmap	leftPupilOrig;
	QPixmap	rightPupilOrig;
	QPixmap eyeRegionOrig;
	QPixmap	eyeMaskXPM;
	QPixmap	leftPupilMaskXPM;
	QPixmap	rightPupilMaskXPM;

	// xpm's - scaled (masks don't have to be scaled, as their bitmap
	// equivalent will be)
	QPixmap	mainImg;
	QPixmap	leftPupil;
	QPixmap	rightPupil;
	QPixmap eyeRegion;	

	// protected constructor
	figure(): nullBitmap()
	{
		leftPupilMaskXPM = nullBitmap;
		rightPupilMaskXPM = nullBitmap;
	}
private:
	// bitmaps/masks, initially loaded as xpm's
	QBitmap	tuxMask;
	QBitmap	eyeMask;
	QBitmap	leftPupilMask;
	QBitmap	rightPupilMask;


	QBitmap nullBitmap;

public:
	void	postInit()
	{
		mainImg = tuxOrig;
		leftPupil = leftPupilOrig;
		rightPupil = rightPupilOrig;
		eyeRegion = eyeRegionOrig;

		tuxMask = tuxMaskXPM; // convert XPM to bitmap

		eyeMask = eyeMaskXPM; // convert XPM to bitmap
		eyeRegion.setMask(eyeMask);

		if(!leftPupilMaskXPM.isNull())
		{
			leftPupilMask = leftPupilMaskXPM;
			leftPupil.setMask(leftPupilMask);
		}
		if(!leftPupilMaskXPM.isNull())
		{
			rightPupilMask = rightPupilMaskXPM;
			rightPupil.setMask(rightPupilMask);
		}

	}
	void	rescale(float xScale, float yScale)
	{
		QWMatrix	m;

		m.scale(xScale, yScale);
		mainImg = tuxOrig.xForm(m);
		leftPupil = leftPupilOrig.xForm(m);
		rightPupil = rightPupilOrig.xForm(m);

		// masks etc
		eyeRegion = eyeRegionOrig.xForm(m);
		tuxMask = tuxMaskXPM.xForm(m);
		eyeMask = nullBitmap;
		eyeMask = eyeMaskXPM.xForm(m);

		if(!leftPupilMaskXPM.isNull())
		{
			leftPupilMask = nullBitmap;
			leftPupilMask = leftPupilMaskXPM.xForm(m);
			leftPupil.setMask(leftPupilMask);
		}
		if(!leftPupilMaskXPM.isNull())
		{
			rightPupilMask = nullBitmap;
			rightPupilMask = rightPupilMaskXPM.xForm(m);
			rightPupil.setMask(rightPupilMask);
		}
		eyeRegion.setMask(eyeMask);
	}

	static	void	loadImage(QPixmap &pixmap, char **xpm)
	{
		QImage image((const char **)xpm);
		if (!image.isNull())
        		pixmap.convertFromImage( image );
	}

	int	getWidth() const
	{
		return mainImg.width();
	}

	int	getHeight() const
	{
		return mainImg.height();
	}

	int	getLeftEyeX() const
	{
		return leftEyeX;
	}
	int	getRightEyeX() const
	{
		return rightEyeX;
	}
	int	getLeftEyeY() const
	{
		return leftEyeY;
	}
	int	getRightEyeY() const
	{
		return rightEyeY;
	}
	int	getLeftPupilRadius() const
	{
		return leftPupilRadius;
	}

	int	getRightPupilRadius() const
	{
		return rightPupilRadius;
	}
	int	getEyeXOffset() const
	{
		return eyeXOffset;
	}
	int	getEyeYOffset() const
	{
		return eyeYOffset;
	}

	QBitmap	getMainMask() const
	{
		return tuxMask;
	}

	QPixmap	getEyeRegion() const
	{
		return eyeRegion;
	}

	QPixmap	getLeftPupil() const
	{
		return leftPupil;
	}

	QPixmap getRightPupil() const
	{
		return rightPupil;
	}
	QPixmap	getMainImg() const
	{
		return mainImg;
	}
};

#endif // FIGURE_H
