%{
#include <stdlib.h>
#include <stdio.h>
#include "xwin.h"

int det_patterns_num;
int configs_num;


enum tokens {ENDOFINPUT=0, LIBPATHtoken, PATTERNBEGINtoken, 
PATTERNENDtoken, AUTOREFRESHtoken,AUTOANSWERtoken,AUTORUNtoken,
TITLEtoken,PATTERNtoken,PICTUREtoken,SOUNDtoken,SOUNDHANDLERtoken,
MENUBEGINtoken,MENUENDtoken,FILEtoken, CONFIGBEGINtoken,CONFIGENDtoken,
IDENTIFIERtoken,CRAP,SOLUTIONtoken,COMMANDtoken,DETERMINEDtoken,
DEFAULTPICtoken,MAILENDtoken,BOXtoken,MAILBEGINtoken,READtoken,TOUCHtoken};
/*
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
    { \
    int c = fgetc(c_input_stream); \
    result = (c == EOF) ? YY_NULL : (buf[0] = c, 1); \
    }

FILE *c_input_stream=NULL;
*/

%}
whitespace			[ \t\n]	
alpha 				[[:graph:]]
%%
"#".*							;
{whitespace}+					;
SOUNDHANDLER					return(SOUNDHANDLERtoken);
SOUNDCLIP						return(SOUNDtoken);
MAILBOX							return(BOXtoken);
CHECKMAIL_END					return(MAILENDtoken);
CHECKMAIL_BEGIN					return(MAILBEGINtoken);
ACCEPT_EXTERNAL_READ			return(READtoken);
TOUCH                           return(TOUCHtoken);
AUTOREFRESH						return(AUTOREFRESHtoken);
AUTOANSWER						return(AUTOANSWERtoken);
AUTORUN 						return(AUTORUNtoken);
LIBPATH							return(LIBPATHtoken);
PIXPATH							return(LIBPATHtoken);
PATTERN_BEGIN					return(PATTERNBEGINtoken);
PATTERN_END						return(PATTERNENDtoken);
TITLE							return(TITLEtoken);
PATTERN 						return(PATTERNtoken);
COMMAND 						return(COMMANDtoken);
PICTURE 						return(PICTUREtoken);
DETERMINED                      return(DETERMINEDtoken);
MENU_BEGIN 						return(MENUBEGINtoken);
MENU_END						return(MENUENDtoken);
FILE							return(FILEtoken);
CONFIGS_BEGIN					return(CONFIGBEGINtoken);
CONFIGS_END						return(CONFIGENDtoken);
DEFAULTPIC						return(DEFAULTPICtoken);
"="{whitespace}*.*				return(SOLUTIONtoken);
{alpha}{alpha}*					return(IDENTIFIERtoken);
.								return(CRAP);
%%
#if 0
int main (void)
    {
    node patterns;
    node *temp2=&patterns;
    det_node det_patterns;
    det_node *temp3=&det_patterns;
    config_node configs;
	mail_node mail;
    config_node *temp4 = &configs;
    init_info init;


    FILE *temp;
    if (NULL == (temp = fopen ("sample.xinitrc", "r")))
        {
        fprintf (stderr, "couldnt open ~/.xinitrc\n");
        return (1);
        }
    Parse (temp, &patterns, &det_patterns, &configs,&init,&mail);
    fclose (temp);
    fprintf(stderr,"\n\n\n\n");
    while (temp2 != NULL)
        {
        fprintf(stderr,"QWER %s\n",temp2->title);
        temp2 = temp2->next; 
        }

    while (temp3 != NULL)
        {
        fprintf(stderr,"QWER2 %s\n",temp3->title);
        temp3 = temp3->next; 
        }

    while (temp4 != NULL)
        {
        fprintf(stderr,"QWER3 %s\n",temp4->title);
        temp4 = temp4->next; 
        }

    }
#endif


int Parse (FILE * incoming, node * patterns, det_node * det_patterns, config_node * configs, init_info *init,mail_node *mail)
    {
    int i,j;
    char *begin;
    char *yycopy;
    enum tokens CurrentToken;
    mail_node *mtemp2 = mail;
    mail_node *mtemp = mail;
    node *temp = patterns;
    node *temp2= patterns;
    det_node *det_temp = det_patterns;
    det_node *det_temp2 = det_patterns;
    config_node *config_temp = configs;
    config_node *config_temp2 = configs;

/*
    c_input_stream = incoming;
*/

    yyin = incoming;

    do
        {
        CurrentToken = yylex ();
        switch (CurrentToken)
            {
			case DEFAULTPICtoken:
				CurrentToken = yylex();
				switch(CurrentToken)
					{
	                case SOLUTIONtoken:
		    			begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        for (i=0;i<strlen(begin);i++)
                            begin[i] = tolower(begin[i]);
                        istrncpy (init->defaultpic , begin, MAXFILELEN);
                        break;
					 default:
                        break;
					}
				break;
            case SOUNDHANDLERtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (init->soundhandler, begin, MAXFILELEN);
                        break;
                    default:
                        break;
                    }
                break;
            case LIBPATHtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (init->libpath, begin, MAXFILELEN);
                        break;
                    default:
                        break;
                    }
                break;
            case AUTOREFRESHtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        for (i=0;i<strlen(begin);i++)
                            begin[i] = tolower(begin[i]);
                        if (!(strcmp(begin,"yes")))
                            init->autorefresh = 1;
                        else if ((strcmp(begin,"no")))
                            fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    default:
                        fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    }
                break;
            case AUTOANSWERtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        for (i=0;i<strlen(begin);i++)
                            begin[i] = tolower(begin[i]);
                        if (!(strcmp(begin,"yes")))
                            init->autoanswer = 1;
                        else if ((strcmp(begin,"no")))
                            fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    default:
                        fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    }
                break;
            case AUTORUNtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        for (i=0;i<strlen(begin);i++)
                            begin[i] = tolower(begin[i]);
                        if (!(strcmp(begin,"yes")))
                            init->autorun = 1;
                        else if ((strcmp(begin,"no")))
                            fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    default:
                        fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    }
                break;
            case MAILBEGINtoken:
				if (mtemp == NULL)
                    mtemp = malloc (sizeof (mail_node));
                if (mtemp == NULL)
                    {
                    fprintf (stderr, "1not enough memory!\naborting\n");
                    exit (-1);
                    }
                strcpy(mtemp->title,"Untitled");
                mtemp->picture[0] = '\0';
                mtemp->mailfile[0] = '\0';
                mtemp->soundclip[0] = '\0';
                mtemp->allowread = 1;
                mtemp->touch = 0;
                mtemp->next = NULL;
                if (0 != ParseMail(mtemp))
                    return (1);
                mtemp2->next = mtemp;
                mtemp2 = mtemp2->next;
                mtemp2->next=NULL;
                mtemp = NULL;
                break;
                break;
            case PATTERNBEGINtoken:
                if (temp == NULL)
                    temp = malloc (sizeof (node));
                if (temp == NULL)
                    {
                    fprintf (stderr, "1not enough memory!\naborting\n");
                    exit (-1);
                    }
                strcpy(temp->title,"Untitled");
                temp->command[0] = '\0';
                temp->pattern[0] = '\0';
                temp->picture[0] = '\0';
                temp->soundclip[0] = '\0';
                temp->next = NULL;
                if (0 != ParsePattern (temp))
                    return (1);
                temp2->next = temp;
                temp2 = temp2->next;
                temp2->next=NULL;
                temp = NULL;
                break;
            case MENUBEGINtoken:
                if (det_temp == NULL)
                    det_temp = malloc (sizeof (det_node));
                if (det_temp == NULL)
                    {
                    fprintf (stderr, "2not enough memory!\naborting\n");
                    exit (-1);
                    }
                strcpy(det_temp->title,"Untitled");
                det_temp->determined_command[0] = '\0';
                det_temp->next = NULL;
                det_patterns_num++;
                if (0 != ParseMenu (det_temp))
                    return (1);
                det_temp2->next = det_temp;
                det_temp2 = det_temp2->next;
                det_temp2->next=NULL;
                det_temp = NULL;
                break;
            case CONFIGBEGINtoken:
                if (config_temp == NULL)
                    config_temp = malloc (sizeof (config_node));
                if (config_temp == NULL)
                    {
                    fprintf (stderr, "3not enough memory!\naborting\n");
                    exit (-1);
                    }
                strcpy(config_temp->title,"Untitled");
                config_temp->filename[0] = '\0';
                config_temp->next = NULL;
                configs_num++;
                if (0 != ParseConfig (config_temp))
                    return (1);
                config_temp2->next = config_temp;
                config_temp2 = config_temp2->next;
                config_temp2->next=NULL;
                config_temp = NULL;
                break;
            case ENDOFINPUT:
                break;
            case IDENTIFIERtoken:
            case CRAP:
            default:
                fprintf (stderr,"malformed initfile\n");
                fprintf (stderr,"barf1 at \" %s \"", yytext);
                return (1);
                break;





            }
        }
    while (CurrentToken != ENDOFINPUT);
    return (0);
    }




int ParsePattern (node * temp)
    {
    enum tokens CurrentToken;
    char *begin;

    do
        {
        CurrentToken = yylex ();
        switch (CurrentToken)
            {
			case SOUNDtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->soundclip, begin, MAX_PICTURE- 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a soundclip\n");
                        return (1);
                        break;
                    }
                break;
            case TITLEtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->title, begin, MAX_TITLE - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a title \n");
                        return (1);
                        break;
                    }
                break;
            case PATTERNtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->pattern, begin, MAX_PATTERN - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a pattern \n");
                        return (1);
                        break;
                    }
                break;

            case COMMANDtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->command, begin, MAX_COMMAND - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a command \n");
                        return (1);
                        break;
                    }
                break;
            case PICTUREtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->picture, begin, MAX_PICTURE - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected the name of a picture \n");
                        return (1);
                        break;
                    }
                break;
            case ENDOFINPUT:
                return (1);
                break;
            case PATTERNENDtoken:
                break;
            case IDENTIFIERtoken:
            case CRAP:
            default:
                fprintf (stderr,"malformed initfile\n");
                fprintf (stderr,"barf2 at \" %s \"", yytext);
                return (1);
                break;
            }
        }
    while (CurrentToken != PATTERNENDtoken);
    return (0);
    }

int ParseMenu (det_node * temp)
    {
    char *begin;
    enum tokens CurrentToken;

    do
        {
        CurrentToken = yylex ();

        switch (CurrentToken)
            {
            case TITLEtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->title, begin, MAX_TITLE - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a title \n");
                        return (1);
                        break;
                    }
                break;
            case DETERMINEDtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->determined_command, begin, MAX_COMMAND - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a command\n");
                        return (1);
                        break;
                    }
                break;
            case MENUENDtoken:
                break;
            case ENDOFINPUT:
                return (1);
                break;
            case IDENTIFIERtoken:
            case CRAP:
            default:
                fprintf (stderr,"malformed initfile\n");
                fprintf (stderr,"barf3 at \" %s \"", yytext);
                return (1);
                break;
            }
        }
    while (CurrentToken != MENUENDtoken);
    return (0);
    }

int ParseConfig (config_node * temp)
    {
    char *begin;
    enum tokens CurrentToken;


    do
        {
        CurrentToken = yylex ();

        switch (CurrentToken)
            {
            case TITLEtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->title, begin, MAX_TITLE - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a title \n");
                        return (1);
                        break;
                    }
                break;

            case FILEtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->filename, begin, MAXFILELEN);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a file name \n");
                        return (1);
                        break;
                    }
                break;
            case CONFIGENDtoken:
                break;
            case ENDOFINPUT:
                return (1);
                break;
            case IDENTIFIERtoken:
            case CRAP:
            default:
                fprintf (stderr,"malformed initfile\n");
                fprintf (stderr,"barf4 at \" %s \"", yytext);
                return (1);
                break;
            }
        }
    while (CurrentToken != CONFIGENDtoken);
    return (0);
    }


int ParseMail(mail_node *temp)
	{
    char *begin;
    enum tokens CurrentToken;
    int i;
	char *tempp;

	do
        {
        CurrentToken = yylex ();

        switch (CurrentToken)
			{
			case SOUNDtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->soundclip, begin, MAX_PICTURE- 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a soundclip\n");
                        return (1);
                        break;
                    }
                break;
            case TITLEtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->title, begin, MAX_TITLE - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a title \n");
                        return (1);
                        break;
                    }
                break;
            case PICTUREtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->picture, begin, MAX_PICTURE - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected the name of a picture \n");
                        return (1);
                        break;
                    }
                break;
            case BOXtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->mailfile, begin, MAXFILELEN);
						if (NULL == (tempp = process_for_variables(temp->mailfile,MAXFILELEN)))
							return(1);
                        istrncpy (temp->mailfile, tempp, MAXFILELEN);
						free(tempp);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a file name \n");
                        return (1);
                        break;
                    }
                break;
			case MAILENDtoken:
				break;
            case READtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        for (i=0;i<strlen(begin);i++)
                            begin[i] = tolower(begin[i]);
                        if (!(strcmp(begin,"no")))
                            temp->allowread = 0;
                        else if ((strcmp(begin,"yes")))
                            fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    default:
                        fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    }
                break;
            case TOUCHtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        for (i=0;i<strlen(begin);i++)
                            begin[i] = tolower(begin[i]);
                        if (!(strcmp(begin,"yes")))
                            temp->touch = 1;
                        else if ((strcmp(begin,"no")))
                            fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    default:
                        fprintf (stderr, "\nExpected \" = YES\" or \" = NO\" \n");
                        break;
                    }
                break;
            case COMMANDtoken:
                CurrentToken = yylex ();
                switch (CurrentToken)
                    {
                    case SOLUTIONtoken:
                        begin = yytext+1;
                        while ((isspace(*begin)) && (yytext+strlen(yytext)-begin > 0))
                            begin++;
                        istrncpy (temp->command, begin, MAX_COMMAND - 1);
                        break;
                    default:
                        fprintf (stderr, "\nExpected a command \n");
                        return (1);
                        break;
                    }
                break;
        	default:
                fprintf (stderr,"malformed initfile\n");
                fprintf (stderr,"barf14 at \" %s \"", yytext);
                return (1);
                break;
			}
    	}
	while (CurrentToken != MAILENDtoken);
	return(0);
	}

#ifdef yywrap
#undef yywrap
#endif

int yywrap ()
    {
    return (1);
    }
