#ifndef DBMATCH_H
#define DBMATCH_H

#include <db.h>
#include <sys/types.h>

#include "objects.h"


/*
 *	Global garbage object.
 */
extern xsw_object_struct garbage_object;


extern int DBIsObjectGarbage(long object_num);
extern int DBIsObjectNameIndex(char *name);
extern double DBGetObjectVisibility(long object_num);
extern double DBGetObjectVisibilityPtr(xsw_object_struct *obj_ptr);
extern long MatchWeaponsLock(
	long ref_obj,
	long start_obj,
	double range
);
extern long MatchIntercept(long object_num, char *arg);
extern long MatchInterceptByNumber(long ref_obj, long tar_obj);
extern long MatchObjectByName(char *name, int type);
extern int MatchIFF(long ref_obj, long tar_obj);
extern int MatchIFFPtr(
	xsw_object_struct *ref_obj_ptr,
	xsw_object_struct *tar_obj_ptr
);
extern void DBSetupGarbageObject();


#endif	/* DBMATCH_H */
