/*----------------------------------------------------
 * stripheader.c Tom Green Sun Dec 12 16:17:30 1993
 *
 * Copyright 1993
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 * SCRI representatives make no claims about the
 * suitability of this software for any purpose.
 * It is provided "as is" without express or
 * implied warranty.
 *
 *--------------------------------------------------*/

#include "../SRC/h.h"

FILE *f;
int  i=0;
int  n=0;
int  N=0;
u_long Started,Finished,Total=0;
typedef char string[80];
struct job_el {
        u_long  pid;
        u_long  started; 
        u_long  finished;
	u_long  total;
        u_long  status;
        string  host;
        string  directory;
	string  output;
	string  command;
        struct  job_el *next;
      };
typedef struct job_el job_list;
string OUT;
string MAKEFILE;
struct stat buf;

job_list *head=NULL;
job_list *jobptr=NULL;
job_list job;
char     *ptr;

job_list *insert();
job_list *locate();
job_list *delete_list();
int reap();
int fd,fd_out;

/************************************************************************/

main(argc, argv,envp)
int argc;
char **argv;
char **envp;

{

     int j;

      bzero(OUT,sizeof(OUT));
      bzero(MAKEFILE,sizeof(MAKEFILE));
      sprintf(MAKEFILE,argv[1]);
      sprintf(OUT,argv[2]);
     
      f=fopen(MAKEFILE,"r");
      if (!f) {
         printf("couldn't open %s\n",MAKEFILE);
         exit(-1);
      }

     Started=time((time_t *)0);
     bzero(&job,sizeof(job));
     while ((i=fscanf(f,"%s %s\n",job.host,job.directory))==2) {
           if (job.host[0]=='#') {
              bzero(&job,sizeof(job));
              continue;
	    }
           sprintf(job.output,"%s.out",job.host);
           sprintf(job.command,"(cd %s;make",job.directory);
	   for (j=3;j<argc;j++)
	   {
		if (!strcmp(argv[j],"PALlL"))
		continue;
		strcat(job.command," ");
		strcat(job.command,argv[j]);
	   }
	   strcat(job.command,")");
           head=insert(&job,head);
           bzero(&job,sizeof(job));
     }

     fclose(f);

     jobptr=head;
     while (jobptr) {
           if (start_job(jobptr)) {
                printf("ERROR:starting %s on %s\n",jobptr->command,jobptr->host);
	    }
            else {
                jobptr->started=time((time_t *)0);
                printf("%s started on %s\n",jobptr->command,jobptr->host);
                N++;
	    }
           jobptr=jobptr->next;
     }

     signal(SIGCLD,reap);

     while(n<N)
          sleep(2);

     Finished=time((time_t *)0);
     printf("Jobs Completed - %d Elapsed Seconds\n",(Finished-Started));
     printf("Creating file %s",OUT);
     fflush(stdout);

     fd_out=creat(OUT,0755);
     if (fd_out<0) {
       printf("\nError opening file\n",OUT);
       exit(-1);
     }

     jobptr=head;
     while(jobptr) {
          if(stat(jobptr->output, &buf)) {
             printf("\nThe file %s does not exist\n",jobptr->output);
             exit(-1);
          }

          fd=open(jobptr->output,O_RDONLY,0755);
          if (fd<0) {
	    printf("\nError opening file\n",jobptr->output);
	    exit(-1);
          }

	  ptr=malloc(buf.st_size);
	  if (!ptr) {
            printf("\nMalloc() failure\n");
            exit(-1);
	  }
	  
	  if (readnbytes(fd,ptr,buf.st_size)) {
            printf("\nError reading in file\n",jobptr->output);
            exit(-1);
	  }
	  
	  close(fd);

	  if (writenbytes(fd_out,ptr,buf.st_size)) {
	    printf("\nError writing file %s\n",OUT);
	    exit(-1);
	  }
	  
          unlink(jobptr->output);

          free(ptr);
          jobptr=jobptr->next;

     }
     head=delete_list(head);
     printf(" Done\n");
     Finished=time((time_t *)0);
     printf("Jobs Completed - %d Elapsed Seconds\n",(Finished-Started));
     printf("                 %d Elapsed CPU Seconds\n",Total);
     printf("Output in %s\n",OUT);
     exit(0);
}

/**********************************************************************/

int reap(sig)

{

int pid;
job_list *job;
        struct rusage rusage;

#if ( _AIX || __hpux || __osf__)
        int status;
#else
        union wait status;
#endif

#ifndef __hpux
                pid=wait3(&status,WNOHANG,(struct rusage *) &rusage);
#else
                pid=waitpid(-1,&status,WNOHANG);
#endif

                if (pid==0){
                        signal(SIGCLD,reap);
                        return;
		      }

                if (WIFSTOPPED(status)) {
                        signal(SIGCLD,reap);
                        return;
		      }
                job=locate(head,pid);
                if (!job) {
                   printf("Unable to locate job associated with pid %d\n",pid);
                   signal(SIGCLD,reap);
                   return;
		 }
                 else {
#if (_AIX | __hpux || __osf__)
                   job->status=status;
#else
                   job->status=status.w_retcode;
#endif
                   job->finished=time((time_t *)0);
                   job->total=job->finished-job->started;
                   Total+=job->total;
                   printf("%s Finished - %d Elapsed Seconds\n",job->host,job->total);
                   n++;
	       }
               signal(SIGCLD,reap);
}

/**********************************************************************/

int start_job(job)
job_list *job;

{

int in,out;
struct stat statbuf;

     job->pid=fork();
     if (job->pid)
        return(0);
     for (i=0;i<10;i++)
        close(i);
     in=open("/",O_RDONLY);
     out=open(job->output,O_WRONLY|O_CREAT|O_TRUNC,0744);
     if (out<0)
        exit(-1005);
     dup2(1,2);
     printf("\n***************************************************\n");
     fflush(stdout);
     printf("%s\n",job->host);
     fflush(stdout);
     if (stat("/usr/ucb/rsh",&statbuf))
     execl("/usr/bin/rsh","rsh",job->host,job->command, 0);
     else
     execl("/usr/ucb/rsh","rsh",job->host,job->command, 0);
     exit(-1);

}                

/**********************************************************************/

job_list *locate(head,pid)
job_list *head;
int      pid;

{
        if (head==NULL)
                return(NULL);
        else if (head->pid==pid)
                return(head);
        else
                return(locate(head->next,pid));
      }

/**********************************************************************/

job_list *insert(job,head)
job_list *job;
job_list *head;

{
job_list *last=NULL;
job_list *start,*old;
job_list *tmp;

       tmp=head;
       head=(job_list *) malloc(sizeof(job_list));
       if (!head) {
           printf("ERROR: malloc failure\n");
           exit(-1);
       }
       bzero(head,sizeof(job_list));
       bcopy(job,head,sizeof(job_list));
       head->next=tmp;
       return(head);
}

/**********************************************************************/

job_list *delete_list(head)
job_list *head;

{

        if (head) {
                delete_list(head->next);
                free((char *) head);
	      }
        return(NULL);
}

/***************************************************************/

int writenbytes(sfd,ptr,n)
register int sfd;
register char *ptr;
register int n;

{

        int i,nleft;
        nleft = n;

        while (nleft>0)
	  {
                i = write(sfd,ptr,nleft);
                if (i<=0) {
                        return(i);
		      }
                nleft-=i;
                ptr+=i;
	      }
        return(0);

}

/***************************************************************/

int readnbytes(sfd,ptr,n)
register int sfd;
register char *ptr;
register int n;

{

        int i,j;

        i=n;
        while (i>0)
	  {
                j=read(sfd,ptr,i);
                if(j<0) {
                        return(j);
		      }
                else if (j==0)
                        break;
                i-=j;
                ptr+=j;
	      }
        return(i);
      }
