static char     qmon_rcsid[] = "qmon.c,v 1.2 1994/11/28 16:55:43 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qmon.c,v
 * Revision 1.2  1994/11/28  16:55:43  kerce
 * *** empty log message ***
 *
 * Revision 1.6  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.5  1994/08/21  03:02:43  raju
 * *** empty log message ***
 *
 * Revision 1.4  1994/07/20  01:01:35  raju
 * working version of cell_list and current_cell
 *
 * Revision 1.3  1994/07/15  18:12:20  raju
 * indented and made it to work
 *
 * Revision 1.2  1994/07/15  17:34:39  raju
 * none
 *
 * Revision 1.1  1994/07/11  15:29:02  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"
#include "qmonerrs.h"
#ifdef NOPROTO
int myhandler();
int showusage ();
int logerr();
#else
int myhandler(Display *dpy, XErrorEvent *myerr);
int showusage ();
int logerr(char *errmsg);
#endif


static String   Fallbacks[] = {
			       "AQmon*foreground: wheat",
			       "AQmon*background: MediumSlateBlue",
			       "AQmon*keyboardFocusPolicy: pointer",
			       "AQmon*highlightOnEnter:  True",
			       "AQmon*topShadowColor: light blue",
			       "AQmon*bottomShadowColor: midnight blue",
			       "AQmon.geometry: 810x790+0+0",
			       "AQmon*menubar.preferredPaneSize: 70",
			       "AQmon*viewicon.preferredPaneSize: 500",
			       "AQmon*outputwin.preferredPaneSize: 20",
			       "AQmon*font: fixed",
			       NULL
};


XtAppContext    app_context;
Widget          toplevel;
char           *grpfile = NULL;
char           current_cell[MAX_STRING_SIZE];

#ifdef NOPROTO
XtAppContext get_app_context()
#else
XtAppContext get_app_context(void)
#endif
{
return app_context;
}

/***********************************************************
 * main - Main function for qmon
 */
#ifdef NOPROTO
void main(argc,**argv)
int argc;
char  **argv;
#else
void main(int argc,char  **argv)
#endif
{
	Widget          paned;
	Arg             args[32];
	int             ii;
	char            file[MAX_STRING_SIZE];

	printf("%s %s\n", PROGNAME, VERSION);
	printdate();


	/*
	 * Check command line arguments 
	 */
	for (ii = 0; ii < argc; ii++) {
		if (!strcmp(argv[ii], "-sfile")) {
			if (ii == (argc - 1))
				showusage();
			else {
				strcpy(file, argv[++ii]);
				grpfile = malloc(strlen(file) + 1);
				strcpy(grpfile, file);
			}
		}
	}

	/*
	 * Initialize application 
	 */
	toplevel = XtAppInitialize( &app_context, 
				    (String) "AQmon",
				    (XrmOptionDescList) NULL, 
				    (Cardinal) 0,
#ifdef R4
				   (Cardinal *) &argc,
#else
				   (int *) &argc,
#endif
				   (String *) argv,
				   Fallbacks,
				   (ArgList) NULL, 
			  	   (Cardinal ) 0);
	/*
	 * Initialize display. 
	 */
	initdisplay();

	/*
	 * Fill in the data structures before building the GUI
	 */

	Qmon_data_init ();


	/*
	 * Set up error handler 
	 */
	XSetErrorHandler(myhandler);

	if (isblackandwhite()) {
		printf(ERROR_100);
		exit(0);
	}
	/*
	 * Get colors 
	 */
	initcolors();

	/*
	 * Create main window 
         */
	initmainwindow();

	ii = 0;
	XtSetArg(args[ii], XtNallowResize, True);
	ii++;
	paned = XtCreateManagedWidget("paned", panedWidgetClass,
				      (Widget) getmainwindow(), args, ii);

       /* generate the pixmaps for the sub-panels here */
        createpixmaps ();


	/*
	 * Create main menu 
	 */
	initmainmenu(paned);

	/*
	 * Create icon window 
	 */
	initiconwin(paned);

	/*
	 * Create scrolled text region for output 
	 */
	initoutputwin(paned);

	/*
	 * Setup timer routine to refresh icon window 
	 */
	XtAppAddTimeOut(app_context,
			(unsigned long) 1,
			(XtTimerCallbackProc) initproc,
			(XtPointer) NULL);

	printf("Hello and welcome to %s %s\t", PROGNAME, VERSION);
	printdate();

	settitlebar();


	/*
	 * Loop 
	 */
	XtRealizeWidget(toplevel);
	XtAppMainLoop(app_context);
}


/***********************************************************
 * myhandler - Traps any X Server errors
 */
int myhandler(Display *dpy, XErrorEvent *myerr)
{
	char            msg[80];
	XGetErrorText(dpy, myerr->error_code, msg, 80);
	logerr(msg);
}


/***********************************************************
 * showusager - Shows command line options
 */
int showusage()
{
	logerr("usage: -sfile <setup file>");
	exit(-1);
}


/***********************************************************
 * logerr - Since we redirect stdout/stderr to qmon's 
 *          output window, we need a way to examine error
 *          messages
 */
int logerr(char *errmsg)
{
	FILE           *fp;
	char            errfile[MAX_STRING_SIZE];
	int             uid;
	struct passwd  *pwent;

	fprintf(stderr, "%s: %s\n", PROGNAME, errmsg);

	/*
	 * Attempt to append to the file $HOME/.qmonerrlog 
	 */

	uid = getuid();

	pwent = getpwuid(uid);

	sprintf(errfile, "%s/%s", pwent->pw_dir, ERRORFILE);

	if (!(fp = fopen(errfile, "a"))) {
		fprintf(stderr, ERROR_101, PROGNAME, errfile);
		return (0);
	}
	fprintf(fp, "%s\n", errmsg);
	fclose(fp);

}
