static char qsig_rcsid[]="qsig.c,v 1.2 1994/11/28 16:56:05 kerce Exp";
/***********************************************************
 *
 * Written By: Raju R. Lakhamraju 
 * Date: 7/2/94, 4/01/94, 6/17/94
 *
 * Based on Motif qmon by Jeff Snyder
 *
 * Major modifications: Removed motif calls and replaced
 *                     with athena widget set calls.
 *      Added several modules for new DQS commands.
 *
 * Copyright 1992, 1993, 1994
 *
 *
 * SUPER COMPUTER COMPUTATIONS RESEARCH INSTITUTE
 *            FLORIDA STATE UNIVERSITY
 *
 *
 *  SCRI representatives make no claims about the
 *  suitability of this software for any purpose.
 *  It is provided "as is" without express or
 *  implied warranty.
 *
 *  qsig.c,v
 * Revision 1.2  1994/11/28  16:56:05  kerce
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/13  18:03:59  raju
 * *** empty log message ***
 *
 * Revision 1.2  1994/08/21  03:00:05  raju
 * *** empty log message ***
 *
 * Revision 1.1  1994/07/11  15:29:02  raju
 * Initial revision
 *
 *
 *
 **********************************************************/
#include "globals.h"

static Widget           qsig_popup;
static Widget           widget_qsigrc;
static Widget           widget_qsiglabel;
static Widget           widget_qsigframe;
static Widget           widget_qsigmenu;
static Widget           widget_qsigmain;
static Widget           widget_qsigexec;
static Widget           widget_qsigclear;
static Widget           widget_qsigclose;
static Widget           widget_qsigseparator;
static Widget           widget_qsigopt;

struct optionstruct qsigmenu[]={
  0,"Cell       ","-cell",INPUTTYPE,NULL,NULL,
  0,"Help       ","-help",FLAGTYPE,"False",NULL,
  0,"Signal     ","-s",INPUTTYPE,NULL,NULL,
  0,"Verify     ","-verify",FLAGTYPE,"False",NULL,
  0,"Job ID List",NULL,INPUTTYPE,NULL,NULL,
  0,NULL,NULL,(int)NULL,NULL,NULL
};


/***********************************************************
 * pb_qsigexec - Activate callback for exec
 */
XtCallbackProc pb_qsigexec(Widget w, caddr_t client_data, caddr_t call_data)
{
  buildcommand(QSIG_BINARY,qsigmenu,0);
  sleep(1);
  UnMapIconWin ();
  refreshicons();
  MapIconWin ();
}


/***********************************************************
 * pb_qsigclear - Activate callback for clear
 */
XtCallbackProc pb_qsigclear(Widget w, caddr_t client_data, caddr_t call_data)
{
  clearsubmenu(qsigmenu);
}


/***********************************************************
 * pb_qsigclose - Activate callback for close
 */

XtCallbackProc pb_qsigclose(Widget w, caddr_t client_data, caddr_t call_data)
{
  closemainmenuwin();
}


/***********************************************************
 * create_qsig_dialog - Create widgets used for the qsig menu
 */
int create_qsig_dialog(Widget w,XtPointer client_data, XtPointer call_data)
{
  int             ii;
  Arg             args[32];
  Widget        qsig_form;
  Position    x, y;
  Dimension   width, height;
  Widget exec, clear, close;

  ii = 0;
  XtSetArg(args[0], XtNwidth, &width); ii++;
  XtSetArg(args[1], XtNheight, &height); ii++;
  XtGetValues(w, args, ii);
  XtTranslateCoords(w, (Position) (width / 2), (Position) (height / 2),
                    &x, &y);

  ii = 0;
  XtSetArg(args[ii], XtNx, x);                         ii++;
  XtSetArg(args[ii], XtNy, y);                         ii++;

  qsig_popup = XtCreatePopupShell("popup", transientShellWidgetClass, w,
                             args, ii);

  ii = 0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  qsig_form = XtCreateManagedWidget("form", formWidgetClass, qsig_popup,args,
ii);

  ii=0;
  XtSetArg(args[ii], XtNborderWidth, (Dimension) 0); ii++;
  widget_qsiglabel=
	XtCreateManagedWidget("Qsig",labelWidgetClass,qsig_form,args,ii);

  ii=0;
  XtSetArg(args[ii], XtNresizable,True); ii++;
  XtSetArg(args[ii], XtNfromVert, widget_qsiglabel); ii++;
  widget_qsigmain=XtCreateManagedWidget("box",formWidgetClass,qsig_form,
                                        args,ii);
  exec=QmonAddButtonN(widget_qsigmain,NULL,"Exec",(XtCallbackProc)pb_qsigexec,NULL);
  clear=QmonAddButtonN(widget_qsigmain,exec,"Clear",(XtCallbackProc)pb_qsigclear,NULL);
  close=QmonAddButtonN(widget_qsigmain,clear,"Close",(XtCallbackProc)pb_qsigclose,NULL);

  widget_qsigopt=createmenuoptions(qsig_form,widget_qsigmain,qsigmenu,(XtCallbackProc)NULL);
  
}


/***********************************************************
 * openwidget_qsig - Open the qsig menu
 */
int openwidget_qsig()
{
  XtPopup(qsig_popup,XtGrabNone);
}


/***********************************************************
 * closewidget_qsig - Close the qsig menu
 */
int closewidget_qsig()
{
  XtPopdown(qsig_popup);
}
