package biss;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

/**
 * Set container based on standard java.lang.Hashtable (preliminary, other
 * implementations could be more effective)
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class Set
  extends Hashtable
{

public Set () {
}

public Set ( Vector v ) {
	super( v.size());

	for ( int i = v.size()-1; i>= 0; i-- )
		add( v.elementAt( i));
}

public Set ( int initialCapacity ) {
	super( initialCapacity);
}

public void add ( Object obj ) {
	put( obj, obj);
}

public boolean contains ( Object obj ) {
	return ( get( obj) != null );
}

public Vector toSortedVector () {
	return toSortedVector( null);
}

public Vector toSortedVector ( VectorSorter sorter ) {
	Vector list = new Vector( size());
	for ( Enumeration e=elements(); e.hasMoreElements(); )
		VectorLib.sortIn( list, e.nextElement(), sorter);
	return list;    
}

public Vector toVector () {
	Vector list = new Vector( size());
	for ( Enumeration e=elements(); e.hasMoreElements(); )
		list.addElement( e.nextElement());
	return list;
}
}
