package biss.awt;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;

/**
 * static decoration image
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class DecoImage
  extends DecoBox
{
	boolean Stretch = false;
	Image Img;

public DecoImage () {
}

public DecoImage (String gifPath) {
	setImage ( gifPath);
}

public DecoImage (String gifPath, boolean stretch) {
	Stretch = stretch;
	setImage ( gifPath);
}

public void blank (Graphics g, Color cb) {
	g.setColor( cb);
	g.fillRect( X, Y, Width+1, Height+1);
}

public void paint (Graphics g) {
	if ( ! isShowing() )
		return;
	if ( Img != null){
		int iw = Stretch ? Width : Img.getWidth( this);
		int ih = Stretch ? Height : Img.getHeight( this);
		if ( (iw > 0) && (ih > 0) )
			GraphicsLib.drawImageCentered( g, Img, iw, ih, X, Y,
		                               Width, Height, this);
	}
	drawBorder( g);
}

public void setImage ( Image img) {
	if ( img != null) {
		Img = img;

		if ( isShowing() ){
			Graphics g = getGraphics();
			if ( g != null ) {
				blank( g, getParent().getBackground() );
				paint(g);
				g.dispose();
			}
		}
	}
}

public void setImage (String gifPath) {
	setImage( Awt.getImage( gifPath));
}

public void setImageClass( String imgCls){
	setImage( ClassImageSource.getImage( imgCls));
}

public void setStretch ( boolean s) {
	Stretch = s;
	repaint();
}
}
