package biss.awt;


/**
 * helper class for handling / controlling mouse input 
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author J.H.Mehlitz
 */
public class Mouse
{
	static int ActiveButton = 0;
	static int ClickCount = 0;
	static int ClickTime = 200;
	static int DblClickTime = 400;
	static long LastDown = 0;
	static long LastUp = 0;

public static void down ( int active, int cc) {
	LastDown = System.currentTimeMillis();
	ClickCount = cc;
	ActiveButton = active;
}

public static boolean is1Active() {
	return ActiveButton == 1;
}

public static boolean is2Active() {
	return ActiveButton == 2;
}

public static boolean isAnyActive() {
	return (ActiveButton != 0);
}

public static void reset () {
	ActiveButton = 0;
}

public static void up () {
	long dt = System.currentTimeMillis();
	if ( dt - LastUp < DblClickTime)
		ClickCount = 2;
	else if ( dt - LastDown < ClickTime)
		ClickCount = 1;
	else
		ClickCount = 0;

	LastUp = dt;
}

public static boolean wasClicked() {
	return ClickCount == 1;
}

public static boolean wasDblClicked() {
	return ClickCount == 2;
}
}
