package biss.awt.kernel;


/**
 * auxiliary class to do logging of Java events. To remove all debug code
 * from biss.awt.kernel classes, comment out the body of the log() method
 * and recompile the classes with -O (optimization turned on -> log would
 * be inlined). 
 *
 * (C) 1996,97 BISS GmbH Germany, see file 'LICENSE.BISS-AWT' for details
 * @author P.C.Mehlitz
 */
public class Dbg
{
	static int Level = 0;
	final static int LOG_JAVA = 16;

static {
	String val = System.getProperty( "debug");

	if ( val != null )
		Level = Integer.parseInt( val);
}

static void log ( String message ) {
	if ( (Level & LOG_JAVA) > 0 ) {
		System.err.print( "# ");
		System.err.print( Thread.currentThread());
		System.err.print( ": " );
		System.err.println( message);
	}
}
}
