/* file: "os.h" */

/* Copyright (C) 1994-1998 by Marc Feeley, All Rights Reserved. */

#ifndef ___OS_H
#define ___OS_H

/*---------------------------------------------------------------------------*/

/* Select OS routines to use. */

#ifdef sparc
#ifndef __linux__
#define USE_UNIX
#define USE_dlopen
#define USE_sigaction_SIGINT
#define USE_sigaction_setitimer
#endif
#endif

#ifdef sgi
#define USE_UNIX
#define USE_dlopen
#define USE_signal_SIGINT
#define USE_signal_setitimer
#endif

#ifdef __alpha
#define USE_UNIX
#define USE_dlopen
#define USE_sigaction_SIGINT
#define USE_sigaction_setitimer
#endif

#ifdef hpux
#define USE_UNIX
#define USE_shl_load
#define USE_sigaction_SIGINT
#define USE_sigaction_setitimer
#endif

#ifdef _AIX
#define USE_UNIX
#define USE_sigaction_SIGINT
#define USE_sigaction_setitimer
#endif

#ifdef __linux__
#define USE_UNIX
#define USE_dlopen
#define USE_sigaction_SIGINT
#define USE_sigaction_setitimer
#endif

#ifdef __NetBSD__
#ifdef i386
#define USE_UNIX
#define USE_dlopen
#define USE_sigaction_SIGINT
#define USE_sigaction_setitimer
#endif
#endif

#ifdef __FreeBSD__
#ifdef i386
#define USE_UNIX
#define USE_dlopen
#define USE_sigaction_SIGINT
#define USE_sigaction_setitimer
#endif
#endif

#ifdef __DJGPP__
#ifdef __i386__
#define USE_DJGPP
#define USE_signal_SIGINT
#define USE_signal_setitimer
#endif
#endif

#ifdef _MSC_VER
#ifndef __MWERKS__
#if _MSC_VER < 1000
#ifdef _M_I86
#define USE_WINDOWS
#define USE_fullpath
#define USE_ftime
#endif
#else
#ifdef _M_IX86
#define USE_WINDOWS
#define USE_fullpath
#define USE_ftime
#endif
#endif
#ifndef S_ISDIR
#define S_ISDIR(mode)(mode&_S_IFDIR)
#endif
#define popen(command,mode)_popen(command,mode)
#define pclose(stream)_pclose(stream)
#define isatty(descr)_isatty(descr)
#endif
#endif

#ifdef __BORLANDC__
#ifdef _M_IX86
#define USE_WINDOWS
#define USE_fullpath
#define USE_ftime
#define popen(command,mode)_popen(command,mode)
#define pclose(stream)_pclose(stream)
#endif
#endif

#ifdef __WATCOMC__
#ifdef __386__
#define USE_WINDOWS
#define USE_fullpath
#define USE_ftime
#ifdef __SW_BW
#define INCLUDE_wdefwin_h
#endif
#define popen(command,mode)_popen(command,mode)
#define pclose(stream)_pclose(stream)
#endif
#endif

#ifdef __MWERKS__
#ifdef __INTEL__
#define USE_WINDOWS
#define USE_time
#define fileno(stream)_fileno(stream)
#define isatty(descr)_isatty(descr)
#else
#define USE_MACOS
#define USE_GetDateTime
#define USE_TickCount
#define USE_CWIDE
#define EIO (EINTR+1)
#define BUFFERED_STDOUT
#if __MWERKS__ < 0x2000
#define kPrivateCFragCopy kNewCFragCopy
#endif
#if __MWERKS__ < 0x1800
#define USE_SIOUX
#else
#define USE_mac_gui
#endif
#endif
#define EINTR 9999
#define popen(command,mode) 0
#define pclose(stream) -1
#endif

#ifdef __MACHTEN__
#define USE_UNIX
#endif

/*---------------------------------------------------------------------------*/

/* Determine which header files to include. */

#ifdef USE_UNIX
#define USE_getrusage
#define USE_gettimeofday
#define INCLUDE_unistd_h
#define INCLUDE_pwd_h
#define INCLUDE_sys_types_h
#define INCLUDE_sys_time_h
#define INCLUDE_time_h
#endif

#ifdef USE_DJGPP
#define USE_gettimeofday
#define USE_times
#define USE_DOS_PATHS
#define USE_dxe_load
#define USE_control87
#endif

#ifdef USE_WINDOWS
#define USE_clock
#define USE_DOS
#define USE_LoadLibrary
#define USE_signal_SIGINT
#define USE_CreateThread
#define INCLUDE_windows_h
#define INCLUDE_io_h
#define USE_control87
#endif

#ifdef USE_OS2
#define USE_DOS
#define USE_fullpath
#define USE_DosStartTimer
#define USE_DosLoadModule
#define INCLUDE_sys_types_h
#define INCLUDE_sys_stat_h
#define INCLUDE_signal_h
#define INCL_DOSPROCESS
#define INCL_DOSERRORS
#define INCL_DOSFILEMGR
#define INCL_DOSMISC
#define INCL_DOSDATETIME
#define INCLUDE_os2_h
#endif

#ifdef USE_DOS
#define USE_DOS_PATHS
#ifndef USE_WINDOWS
#define INCLUDE_dos_h
#endif
#define INCLUDE_direct_h
#define INCLUDE_time_h
#endif

#ifdef USE_MACOS
#define USE_GetDiskFragment
#define USE_signal_SIGINT
#define USE_VInstall
#define INCLUDE_Retrace_h
#define INCLUDE_Files_h
#define INCLUDE_Finder_h
#define INCLUDE_Errors_h
#define INCLUDE_Folders_h
#define INCLUDE_OSUtils_h
#define INCLUDE_Power_h
#define INCLUDE_CodeFragments_h
#define INCLUDE_signal_h
#define INCLUDE_stat_h
#ifdef USE_SIOUX
#define INCLUDE_SIOUX_h
#define INCLUDE_unistd_h
#define INCLUDE_unix_h
#endif
#ifdef USE_mac_gui
#define INCLUDE_mac_gui_h
#endif
#endif

#ifdef USE_time
#define INCLUDE_time_h
#endif

#ifdef USE_ftime
#define INCLUDE_sys_types_h
#define INCLUDE_sys_timeb_h
#endif

#ifdef USE_gettimeofday
#define INCLUDE_sys_time_h
#endif

#ifdef USE_times
#define INCLUDE_sys_times_h
#endif

#ifdef USE_clock_gettime
#define INCLUDE_time_h
#endif

#ifdef USE_getclock
#define INCLUDE_sys_timers_h
#endif

#ifdef USE_getrusage
#define INCLUDE_sys_resource_h
#endif

#ifdef USE_dlopen
#define INCLUDE_dlfcn_h
#endif

#ifdef USE_shl_load
#define INCLUDE_dl_h
#endif

#ifdef USE_dxe_load
#define INCLUDE_sys_dxe_h
#endif

#ifdef USE_sigaction_SIGINT
#undef INCLUDE_signal_h
#define INCLUDE_signal_h
#endif

#ifdef USE_sigaction_setitimer
#undef INCLUDE_signal_h
#define INCLUDE_signal_h
#endif

#ifdef USE_signal_SIGINT
#undef INCLUDE_signal_h
#define INCLUDE_signal_h
#endif

#ifdef USE_signal_setitimer
#undef INCLUDE_signal_h
#define INCLUDE_signal_h
#endif

#ifdef USE_fullpath
#define INCLUDE_sys_stat_h
#endif

#ifdef USE_control87
#define INCLUDE_float_h
#endif


/*---------------------------------------------------------------------------*/

/* Inclusion of header files. */

#define _STDIO_UNLOCK_CHAR_IO

#include <stdio.h>
#include <errno.h>

#ifndef ESUCCESS
#define ESUCCESS 0
#endif

#ifndef EINTR
#define EINTR -1
#endif

#include <stdlib.h>
#include <limits.h>
#include <string.h>

#ifdef INCLUDE_unistd_h
#include <unistd.h>
#endif

#ifdef INCLUDE_pwd_h
#include <pwd.h>
#endif

#ifdef INCLUDE_dlfcn_h
#include <dlfcn.h>
#endif

#ifdef INCLUDE_dl_h
#include <dl.h>
#endif

#ifdef INCLUDE_sys_dxe_h
#include <sys/dxe.h>
#endif

#ifdef INCLUDE_sys_types_h
#include <sys/types.h>
#endif

#ifdef INCLUDE_sys_time_h
#include <sys/time.h>
#endif

#ifdef INCLUDE_sys_times_h
#include <sys/times.h>
#endif

#ifdef INCLUDE_sys_timeb_h
#include <sys/timeb.h>
#endif

#ifdef INCLUDE_sys_timers_h
#include <sys/timers.h>
#endif

#ifdef INCLUDE_time_h
#include <time.h>
#endif

#ifdef INCLUDE_sys_resource_h
#include <sys/resource.h>
#endif

#ifdef INCLUDE_sys_stat_h
#include <sys/stat.h>
#endif

#ifdef INCLUDE_stat_h
#include <stat.h>
#endif

#ifdef INCLUDE_signal_h
#include <signal.h>
#endif

#ifdef INCLUDE_windows_h
#include <windows.h>
#endif

#ifdef INCLUDE_io_h
#include <io.h>
#endif

#ifdef INCLUDE_float_h
#include <float.h>
#endif

#ifdef INCLUDE_os2_h
#include <os2.h>
#endif

#ifdef INCLUDE_dos_h
#include <dos.h>
#endif

#ifdef INCLUDE_direct_h
#include <direct.h>
#endif

#ifdef INCLUDE_Retrace_h
#include <Retrace.h>
#endif

#ifdef INCLUDE_Files_h
#include <Files.h>
#endif

#ifdef INCLUDE_Finder_h
#include <Finder.h>
#endif

#ifdef INCLUDE_Errors_h
#include <Errors.h>
#endif

#ifdef INCLUDE_Folders_h
#include <Folders.h>
#endif

#ifdef INCLUDE_OSUtils_h
#include <OSUtils.h>
#endif

#ifdef INCLUDE_Power_h
#include <Power.h>
#endif

#ifdef INCLUDE_CodeFragments_h
#include <CodeFragments.h>
#endif

#ifdef INCLUDE_SIOUX_h
#include <SIOUX.h>
#endif

#ifdef INCLUDE_mac_gui_h
#include "mac_gui.h"
#endif

#ifdef INCLUDE_unix_h
#include <unix.h>
#endif

#ifdef INCLUDE_wdefwin_h
#include <wdefwin.h>
#endif


/*---------------------------------------------------------------------------*/

/* Time between each timer interrupt, in msecs. */

#define ___DEFAULT_TIMER_INTERVAL 100


/* Max length of a path, not including null. */

#define ___PATH_MAX_LENGTH 1024


/* Max length of a shell command, not including null. */

#define ___CMD_MAX_LENGTH 1024


/*
 * Does "___alloc_mem" allocate upwards (___ALLOC_MEM_UP) or downwards
 * (___ALLOC_MEM_DOWN).  This setting only affects performance.
 */

#define ___ALLOC_MEM_UP


/* Low-level memory allocation. */

extern void *___alloc_mem ___P((unsigned long bytes),());
extern void ___free_mem ___P((void *ptr),());


/* Timer interrupt handling. */

extern void ___set_timer_interval ___P((unsigned long msecs),());


/* OS event handling. */

extern ___WORD ___os_event_get ___PVOID;
extern ___WORD ___os_event_handler ___P((___WORD event),());


/* Access to environment variables. */

extern char *___getenv ___P((char *name),());


/* Shell command. */

extern int ___shell_command ___P((char *cmd),());


/* Dynamic loading. */

extern void *___dynamic_load ___P((char *path, char *name, char **errmsg),());


/* Dynamic C compilation. */

extern int ___dynamic_cc
   ___P((char *cc_cmd,
         char *ld_cmd,
         char *root_path,
         char *output_path,
         int ld_flip,
         char **errmsg),
        ());


/* Elapsed real time. */

extern void ___real_time ___P((___U64 *rt),());


/* Elapsed cpu time (user time and system time). */

extern void ___cpu_time ___P((___U64 *user, ___U64 *sys),());


/* Virtual memory statistics. */

extern void ___vm_stats ___P((long *minflt, long *majflt),());


/* Filesystem path expansion. */

#define ___PATH_ABSOLUTE 0
#define ___PATH_RELATIVE 1
#define ___PATH_SHORTEST -1

extern int ___path_expand
   ___P((char *path, char *new_path, long max_length, int format),());
extern int ___path_absolute ___P((char *path),());
extern int ___path_extension
   ___P((char *path, char *ext, long max_length),());
extern int ___path_strip_extension
   ___P((char *path, char *new_path, long max_length),());
extern int ___path_directory
   ___P((char *path, char *dir, long max_length),());
extern int ___path_strip_directory
   ___P((char *path, char *new_path, long max_length),());
extern int ___path_drive
   ___P((char *path, char *drive, long max_length),());
extern int ___path_strip_drive
   ___P((char *path, char *new_path, long max_length),());


/* Formatting of source code position. */

extern char *___format_filepos
   ___P((char *path, long filepos, ___BOOL pinpoint),());


/* Low-level I/O. */

typedef struct
  {
    FILE *stdio_stream;
    int kind;
    int io_encoding;
    int force_tty;
    ___WORD lookahead;
  } ___STREAM;

#define ___IO_INPUT        -1
#define ___IO_INPUT_OUTPUT 0
#define ___IO_OUTPUT       1

#define ___IO_FILE 0
#define ___IO_PIPE 1

extern ___STREAM *___io_stdin ___PVOID;
extern ___STREAM *___io_stdout ___PVOID;
extern ___STREAM *___io_stderr ___PVOID;

extern ___STREAM *___io_open_file
   ___P((char *path, int direction, int encoding),());
extern ___STREAM *___io_open_pipe
   ___P((char *command, int direction, int encoding),());
extern ___WORD ___io_close ___P((___STREAM *stream),());
extern ___WORD ___io_free ___P((___STREAM *stream),());

extern ___WORD ___io_getc ___P((___STREAM *stream),());
extern ___WORD ___io_peek ___P((___STREAM *stream),());
extern ___WORD ___io_ready ___P((___STREAM *stream),());
extern ___WORD ___io_putc ___P((___STREAM *stream, ___UCS4 unicode),());
extern ___WORD ___io_flush ___P((___STREAM *stream),());
extern ___WORD ___io_width ___P((___STREAM *stream),());
extern ___WORD ___io_isatty ___P((___STREAM *stream),());


/* Fatal error handling. */

/* 
 * The procedure "___fatal_error" is called by the runtime system when
 * an unrecoverable error has occured.
 */

extern void (*___fatal_error) ___P((char *msg),());


/* OS initialization/finalization. */

extern void ___setup_os ___P((___setup_params_struct *setup_params),());
extern void ___cleanup_os ___PVOID;


/* Utilities for machine encoding of characters. */

/*
 * For now a LATIN-1 encoding of characters is assumed for 'unsigned char'.
 * This means that the mapping to and from Unicode is the identity function.
 * To support other machine representations, e.g. EBCDIC, these macros
 * would have to actually translate the characters.
 */

#define unicode_to_uchar(u)u
#define uchar_to_unicode(c)c


/*---------------------------------------------------------------------------*/

#endif
