CORBA_INTERFACES = echo

.ifdef INITIALIZE_MMS

all ::
	@ $(CreateMms) eg1 .obj .cc
	@ $(CreateMms) eg2_impl .obj .cc
	@ $(CreateMms) eg2_clt .obj .cc
	@ $(CreateMms) eg3_impl .obj .cc
	@ $(CreateMms) eg3_clt .obj .cc
 	@ $(CreateMms) eg3_tieimpl .obj .cc

.else

CXXSRCS = greeting.cc eg1.cc -
          eg2_impl.cc eg2_clt.cc -
          eg3_impl.cc eg3_clt.cc -
          eg3_tieimpl.cc

# uncomment this line if your compiler is 5.5 or older:
# NoTieExample=1
.ifdef NoTieExample
.else NoTieExample
DIR_IDLFLAGS = -t
.endif

eg1        = eg1$(DebugSuffix).exe
eg2_impl   = eg2_impl$(DebugSuffix).exe
eg2_clt    = eg2_clt$(DebugSuffix).exe
eg3_impl   = eg3_impl$(DebugSuffix).exe
eg3_clt    = eg3_clt$(DebugSuffix).exe
eg3_tieimpl = eg3_tieimpl$(DebugSuffix).exe

.ifdef NoTieExample
all :: $(eg1) $(eg2_impl) $(eg2_clt)  $(eg3_impl) $(eg3_clt)
.else
all :: $(eg1) $(eg2_impl) $(eg2_clt)  $(eg3_impl) $(eg3_clt) $(eg3_tieimpl)
.endif

clean ::
	$(RM) $(eg1) $(eg2_impl) $(eg2_clt) $(eg3_impl) $(eg3_clt) $(eg3_tieimpl)

export :: $(eg1)
	@ $(ExportExecutable)
export :: $(eg2_impl) 
	@ $(ExportExecutable)
export :: $(eg2_clt) 
	@ $(ExportExecutable)
export :: $(eg3_impl) 
	@ $(ExportExecutable)
export :: $(eg3_clt)
	@ $(ExportExecutable)

.ifdef NoTieExample
.else
export :: $(eg3_tieimpl)
	@ $(ExportExecutable)
.endif

OBJ_LIBS = $(CORBA_LIB)
OBJ_LIB_DEPEND = $(CORBA_LIB_DEPEND)

$(eg1) : eg1.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg2_impl) : eg2_impl.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg2_clt) : eg2_clt.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg3_impl) : eg3_impl.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg3_clt) : eg3_clt.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

$(eg3_tieimpl) : eg3_tieimpl.obj $(OBJ_LIB_DEPEND)
	@ $(CXXExecutable)

.include eg1.mms
.include eg2_impl.mms
.include eg2_clt.mms
.include eg3_impl.mms
.include eg3_clt.mms
.include eg3_tieimpl.mms

.endif
