# dir.mms for omniORB2.
#

.ifdef INITIALIZE_MMS
SUBDIRS = orbcore dynamic lifecycle
all ::
	@ $(MakeSubdirs)
.else

.IFDEF VAX
SUBDIRS = orbcore dynamic lifecycle
.ELSE
.IFDEF CXX6
SUBDIRS = orbcore dynamic lifecycle
.ELSE
SUBDIRS = orbcore dynamic lifecycle\
	orbcore.sharedlib dynamic.sharedlib lifecycle.sharedlib
.ENDIF
.ENDIF

all :: Naming.hh bootstrap.hh ir_defs.hh corbaidl_defs.hh omniLifeCycle.hh
	@ $(MakeSubdirs)
.endif

clean ::
	@ $(MakeSubdirs)

OmniORB2Include=$(top)include.omniORB2]

Naming_header = $(OmniORB2Include)Naming.hh
bootstrap_header = $(OmniORB2Include)bootstrap.hh
ir_defs_header = $(OmniORB2Include)ir_defs.hh
ir_operators_header = $(OmniORB2Include)ir_operators.hh
corbaidl_defs_header = $(OmniORB2Include)corbaidl_defs.hh
corbaidl_operators_header = $(OmniORB2Include)corbaidl_operators.hh
omniLifeCycle_header = $(OmniORB2Include)omniLifeCycle.hh

export :: Naming.hh bootstrap.hh ir_defs.hh corbaidl_defs.hh omniLifeCycle.hh
	@ $(MakeSubdirs)

export :: $(Naming_header) $(bootstrap_header)\
	$(ir_defs_header) $(ir_operators_header)\
	$(corbaidl_defs_header) $(corbaidl_operators_header)\
	$(omniLifeCycle_header)

veryclean ::
	$(RM)	Naming.idl Naming.hh NamingSK.cc NamingDynSK.cc
	$(RM)	bootstrap.idl bootstrap.hh bootstrapSK.cc bootstrapDynSK.cc
	$(RM)	ir.idl ir_defs.hh ir_operators.hh irSK.cc irDynSK.cc
	$(RM)	corbaidl.idl corbaidl_defs.hh corbaidl_operators.hh
	$(RM)	corbaidlSK.cc corbaidlDynSK.cc
	$(RM)	omniLifeCycle.idl omniLifeCycle.hh omniLifeCycleSK.cc
	$(RM)	omniLifeCycleDynSK.cc

######################################################################
# Make rules for Stubs                                               #
######################################################################

Naming.hh NamingSK.cc NamingDynSK.cc : Naming.idl
	omniidl2 -a "Naming.idl"

bootstrap.hh bootstrapSK.cc bootstrapDynSK.cc : bootstrap.idl
	omniidl2 -a "bootstrap.idl"

ir_defs.hh ir_operators.hh irSK.cc irDynSK.cc : ir.idl corbaidl_defs.hh
	omniidl2 -a -m "-F" "-I[]" ir.idl

corbaidl_defs.hh corbaidl_operators.hh corbaidlSK.cc corbaidlDynSK.cc : corbaidl.idl
	omniidl2 -a -m "-F" corbaidl.idl

omniLifeCycle.hh omniLifeCycleSK.cc omniLifeCycleDynSK.cc : omniLifeCycle.idl
	omniidl2 -a -m omniLifeCycle.idl

# Make rules to import idls from ['top'.idl]

Naming.idl : $(top)idl]Naming.idl
	copy $(mms$source) $(mms$target)

bootstrap.idl : $(top)idl]bootstrap.idl
	copy $(mms$source) $(mms$target)

ir.idl : $(top)idl]ir.idl
	copy $(mms$source) $(mms$target)

corbaidl.idl : $(top)idl]corbaidl.idl
	copy $(mms$source) $(mms$target)

omniLifeCycle.idl : $(top)idl]omniLifeCycle.idl
	copy $(mms$source) $(mms$target)

######################################################################
# Make rules for Exporting headers                                   #
######################################################################
$(Naming_header) : Naming.hh
	@ $(ExportHeader)

$(bootstrap_header) : bootstrap.hh
	@ $(ExportHeader)

$(ir_defs_header) : ir_defs.hh
	@ $(ExportHeader)

$(ir_operators_header) : ir_operators.hh
	@ $(ExportHeader)

$(corbaidl_defs_header) : corbaidl_defs.hh
	@ $(ExportHeader)

$(corbaidl_operators_header) : corbaidl_operators.hh
	@ $(ExportHeader)

$(omniLifeCycle_header) : omniLifeCycle.hh
	@ $(ExportHeader)
