.suffixes
# dir.mms for omniDynamic2 shared library
#
# Build a shared library in this directory
# **** DO NOT forget to update the $(VERSION) number.
#

# The Version number is constructed as follows:
#    <major version no.>.<minor version no.>.<micro version no.>
#
# The <minor version no.> changes when:
#   1. Public interfaces have been extended but remains backward compatible
#      with earlier minor version.
#   2. Internal interfaces have been changed.
#
# The <micro version no.> changes when the implementation has been changed
# but both the public and internal interfaces remain the same. This usually
# corresponds to a pure bug fix release.
#
# (Note that this is backwards from dir.mk since MMS has no $(word...).

major_version = 2
minor_version = 8
micro_version = 0

VERSION = $(major_version).$(minor_version).$(micro_version)

# assume that the parent directory is built and that therefore
# $(libpath)omniDynamic2$(DebugSuffix).olb exists.

staticlib=[-]omniDynamic2$(DebugSuffix).olb
shareableimage=omniDynamic2$(ShareableImageSuffix).exe
exportshareableimage=$(libpath)$(shareableimage)

OBJ_LIBS = \
omnilib:omni_share$(DebugSuffix).olb/include=(omnithread_rt$(DebugSuffix),\
omniORB2_rt$(DebugSuffix))

OBJ_LIBS_DEPEND = \
$(libpath)omni_share$(DebugSuffix).olb(omnithread_rt$(DebugSuffix)) \
$(libpath)omni_share$(DebugSuffix).olb(omniORB2_rt$(DebugSuffix))

all :: $(shareableimage)

$(shareableimage) : $(staticlib) $(OBJ_LIBS_DEPEND)
	$(CxxShareableImage)

export :: all
export :: $(exportshareableimage)

$(exportshareableimage) : $(shareableimage)
	$(ExportShareable)

veryclean ::
	@- $(RM) $(shareableimage)
	@- $(RM) *.opt *.dat
