/* -*- C++ -*- */
// $Id: MessagingS.h,v 1.13 1999/10/21 18:23:55 irfan Exp $

// ******  Code generated by the The ACE ORB (TAO) IDL Compiler *******
// TAO and the TAO IDL Compiler have been developed by the Center for
// Distributed Object Computing at Washington University, St. Louis.
//
// Information about TAO is available at:
//                 http://www.cs.wustl.edu/~schmidt/TAO.html

#ifndef TAO_IDL_MESSAGINGS_H
#define TAO_IDL_MESSAGINGS_H

#include "tao/orbconf.h"

#if defined (TAO_HAS_CORBA_MESSAGING)

#include "tao/TimeBaseS.h"
#include "tao/POA_CORBA.h"
#include "tao/MessagingC.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#if defined(_MSC_VER)
#pragma warning(disable:4250)
#endif /* _MSC_VER */

TAO_NAMESPACE  POA_Messaging
{
  class RebindPolicy;
  typedef RebindPolicy *RebindPolicy_ptr;
  class TAO_Export RebindPolicy : public virtual POA_CORBA::Policy,
                                  public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    RebindPolicy (void);
  public:
    RebindPolicy (const RebindPolicy& rhs);
    virtual ~RebindPolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual Messaging::RebindMode rebind_mode (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::RebindPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_RebindPolicy     : public virtual Messaging::RebindPolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_RebindPolicy (
        RebindPolicy_ptr  servant,
        TAO_Stub *stub
      );
    RebindPolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual Messaging::RebindMode rebind_mode (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    RebindPolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export RebindPolicy_tie : public RebindPolicy
  {
  public:
    RebindPolicy_tie (T &t);
    // the T& ctor
    RebindPolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    RebindPolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    RebindPolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~RebindPolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    Messaging::RebindMode rebind_mode (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    RebindPolicy_tie (const RebindPolicy_tie &);
    void operator= (const RebindPolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class SyncScopePolicy;
  typedef SyncScopePolicy *SyncScopePolicy_ptr;
  class TAO_Export SyncScopePolicy : public virtual POA_CORBA::Policy,
                                     public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    SyncScopePolicy (void);
  public:
    SyncScopePolicy (const SyncScopePolicy& rhs);
    virtual ~SyncScopePolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual Messaging::SyncScope synchronization (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::SyncScopePolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_SyncScopePolicy     : public virtual Messaging::SyncScopePolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_SyncScopePolicy (
        SyncScopePolicy_ptr  servant,
        TAO_Stub *stub
      );
    SyncScopePolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual Messaging::SyncScope synchronization (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    SyncScopePolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export SyncScopePolicy_tie : public SyncScopePolicy
  {
  public:
    SyncScopePolicy_tie (T &t);
    // the T& ctor
    SyncScopePolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    SyncScopePolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    SyncScopePolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~SyncScopePolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    Messaging::SyncScope synchronization (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    SyncScopePolicy_tie (const SyncScopePolicy_tie &);
    void operator= (const SyncScopePolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class RequestPriorityPolicy;
  typedef RequestPriorityPolicy *RequestPriorityPolicy_ptr;
  class TAO_Export RequestPriorityPolicy : public virtual POA_CORBA::Policy,
                                           public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    RequestPriorityPolicy (void);
  public:
    RequestPriorityPolicy (const RequestPriorityPolicy& rhs);
    virtual ~RequestPriorityPolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual Messaging::PriorityRange priority_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::RequestPriorityPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_RequestPriorityPolicy     : public virtual Messaging::RequestPriorityPolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_RequestPriorityPolicy (
        RequestPriorityPolicy_ptr  servant,
        TAO_Stub *stub
      );
    RequestPriorityPolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual Messaging::PriorityRange priority_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    RequestPriorityPolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export RequestPriorityPolicy_tie : public RequestPriorityPolicy
  {
  public:
    RequestPriorityPolicy_tie (T &t);
    // the T& ctor
    RequestPriorityPolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    RequestPriorityPolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    RequestPriorityPolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~RequestPriorityPolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    Messaging::PriorityRange priority_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    RequestPriorityPolicy_tie (const RequestPriorityPolicy_tie &);
    void operator= (const RequestPriorityPolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class ReplyPriorityPolicy;
  typedef ReplyPriorityPolicy *ReplyPriorityPolicy_ptr;
  class TAO_Export ReplyPriorityPolicy : public virtual POA_CORBA::Policy,
                                         public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    ReplyPriorityPolicy (void);
  public:
    ReplyPriorityPolicy (const ReplyPriorityPolicy& rhs);
    virtual ~ReplyPriorityPolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual Messaging::PriorityRange priority_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::ReplyPriorityPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_ReplyPriorityPolicy     : public virtual Messaging::ReplyPriorityPolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_ReplyPriorityPolicy (
        ReplyPriorityPolicy_ptr  servant,
        TAO_Stub *stub
      );
    ReplyPriorityPolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual Messaging::PriorityRange priority_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    ReplyPriorityPolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export ReplyPriorityPolicy_tie : public ReplyPriorityPolicy
  {
  public:
    ReplyPriorityPolicy_tie (T &t);
    // the T& ctor
    ReplyPriorityPolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    ReplyPriorityPolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    ReplyPriorityPolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~ReplyPriorityPolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    Messaging::PriorityRange priority_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    ReplyPriorityPolicy_tie (const ReplyPriorityPolicy_tie &);
    void operator= (const ReplyPriorityPolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class RequestStartTimePolicy;
  typedef RequestStartTimePolicy *RequestStartTimePolicy_ptr;
  class TAO_Export RequestStartTimePolicy : public virtual POA_CORBA::Policy,
                                            public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    RequestStartTimePolicy (void);
  public:
    RequestStartTimePolicy (const RequestStartTimePolicy& rhs);
    virtual ~RequestStartTimePolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual TimeBase::UtcT start_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::RequestStartTimePolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_RequestStartTimePolicy     : public virtual Messaging::RequestStartTimePolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_RequestStartTimePolicy (
        RequestStartTimePolicy_ptr  servant,
        TAO_Stub *stub
      );
    RequestStartTimePolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual TimeBase::UtcT start_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    RequestStartTimePolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export RequestStartTimePolicy_tie : public RequestStartTimePolicy
  {
  public:
    RequestStartTimePolicy_tie (T &t);
    // the T& ctor
    RequestStartTimePolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    RequestStartTimePolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    RequestStartTimePolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~RequestStartTimePolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    TimeBase::UtcT start_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    RequestStartTimePolicy_tie (const RequestStartTimePolicy_tie &);
    void operator= (const RequestStartTimePolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class RequestEndTimePolicy;
  typedef RequestEndTimePolicy *RequestEndTimePolicy_ptr;
  class TAO_Export RequestEndTimePolicy : public virtual POA_CORBA::Policy,
                                          public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    RequestEndTimePolicy (void);
  public:
    RequestEndTimePolicy (const RequestEndTimePolicy& rhs);
    virtual ~RequestEndTimePolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual TimeBase::UtcT end_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::RequestEndTimePolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_RequestEndTimePolicy     : public virtual Messaging::RequestEndTimePolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_RequestEndTimePolicy (
        RequestEndTimePolicy_ptr  servant,
        TAO_Stub *stub
      );
    RequestEndTimePolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual TimeBase::UtcT end_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    RequestEndTimePolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export RequestEndTimePolicy_tie : public RequestEndTimePolicy
  {
  public:
    RequestEndTimePolicy_tie (T &t);
    // the T& ctor
    RequestEndTimePolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    RequestEndTimePolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    RequestEndTimePolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~RequestEndTimePolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    TimeBase::UtcT end_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    RequestEndTimePolicy_tie (const RequestEndTimePolicy_tie &);
    void operator= (const RequestEndTimePolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class ReplyStartTimePolicy;
  typedef ReplyStartTimePolicy *ReplyStartTimePolicy_ptr;
  class TAO_Export ReplyStartTimePolicy : public virtual POA_CORBA::Policy,
                                          public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    ReplyStartTimePolicy (void);
  public:
    ReplyStartTimePolicy (const ReplyStartTimePolicy& rhs);
    virtual ~ReplyStartTimePolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual TimeBase::UtcT start_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::ReplyStartTimePolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_ReplyStartTimePolicy     : public virtual Messaging::ReplyStartTimePolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_ReplyStartTimePolicy (
        ReplyStartTimePolicy_ptr  servant,
        TAO_Stub *stub
      );
    ReplyStartTimePolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual TimeBase::UtcT start_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    ReplyStartTimePolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export ReplyStartTimePolicy_tie : public ReplyStartTimePolicy
  {
  public:
    ReplyStartTimePolicy_tie (T &t);
    // the T& ctor
    ReplyStartTimePolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    ReplyStartTimePolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    ReplyStartTimePolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~ReplyStartTimePolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    TimeBase::UtcT start_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    ReplyStartTimePolicy_tie (const ReplyStartTimePolicy_tie &);
    void operator= (const ReplyStartTimePolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class ReplyEndTimePolicy;
  typedef ReplyEndTimePolicy *ReplyEndTimePolicy_ptr;
  class TAO_Export ReplyEndTimePolicy : public virtual POA_CORBA::Policy,
                                        public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    ReplyEndTimePolicy (void);
  public:
    ReplyEndTimePolicy (const ReplyEndTimePolicy& rhs);
    virtual ~ReplyEndTimePolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual TimeBase::UtcT end_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::ReplyEndTimePolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_ReplyEndTimePolicy     : public virtual Messaging::ReplyEndTimePolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_ReplyEndTimePolicy (
        ReplyEndTimePolicy_ptr  servant,
        TAO_Stub *stub
      );
    ReplyEndTimePolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual TimeBase::UtcT end_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    ReplyEndTimePolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export ReplyEndTimePolicy_tie : public ReplyEndTimePolicy
  {
  public:
    ReplyEndTimePolicy_tie (T &t);
    // the T& ctor
    ReplyEndTimePolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    ReplyEndTimePolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    ReplyEndTimePolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~ReplyEndTimePolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    TimeBase::UtcT end_time (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    ReplyEndTimePolicy_tie (const ReplyEndTimePolicy_tie &);
    void operator= (const ReplyEndTimePolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class RelativeRequestTimeoutPolicy;
  typedef RelativeRequestTimeoutPolicy *RelativeRequestTimeoutPolicy_ptr;
  class TAO_Export RelativeRequestTimeoutPolicy : public virtual POA_CORBA::Policy,
                                                  public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    RelativeRequestTimeoutPolicy (void);
  public:
    RelativeRequestTimeoutPolicy (const RelativeRequestTimeoutPolicy& rhs);
    virtual ~RelativeRequestTimeoutPolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual TimeBase::TimeT relative_expiry (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::RelativeRequestTimeoutPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_RelativeRequestTimeoutPolicy     : public virtual Messaging::RelativeRequestTimeoutPolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_RelativeRequestTimeoutPolicy (
        RelativeRequestTimeoutPolicy_ptr  servant,
        TAO_Stub *stub
      );
    RelativeRequestTimeoutPolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual TimeBase::TimeT relative_expiry (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    RelativeRequestTimeoutPolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export RelativeRequestTimeoutPolicy_tie : public RelativeRequestTimeoutPolicy
  {
  public:
    RelativeRequestTimeoutPolicy_tie (T &t);
    // the T& ctor
    RelativeRequestTimeoutPolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    RelativeRequestTimeoutPolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    RelativeRequestTimeoutPolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~RelativeRequestTimeoutPolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    TimeBase::TimeT relative_expiry (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    RelativeRequestTimeoutPolicy_tie (const RelativeRequestTimeoutPolicy_tie &);
    void operator= (const RelativeRequestTimeoutPolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class RelativeRoundtripTimeoutPolicy;
  typedef RelativeRoundtripTimeoutPolicy *RelativeRoundtripTimeoutPolicy_ptr;
  class TAO_Export RelativeRoundtripTimeoutPolicy : public virtual POA_CORBA::Policy,
                                                    public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    RelativeRoundtripTimeoutPolicy (void);
  public:
    RelativeRoundtripTimeoutPolicy (const RelativeRoundtripTimeoutPolicy& rhs);
    virtual ~RelativeRoundtripTimeoutPolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual TimeBase::TimeT relative_expiry (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::RelativeRoundtripTimeoutPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_RelativeRoundtripTimeoutPolicy     : public virtual Messaging::RelativeRoundtripTimeoutPolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_RelativeRoundtripTimeoutPolicy (
        RelativeRoundtripTimeoutPolicy_ptr  servant,
        TAO_Stub *stub
      );
    RelativeRoundtripTimeoutPolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual TimeBase::TimeT relative_expiry (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    RelativeRoundtripTimeoutPolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export RelativeRoundtripTimeoutPolicy_tie : public RelativeRoundtripTimeoutPolicy
  {
  public:
    RelativeRoundtripTimeoutPolicy_tie (T &t);
    // the T& ctor
    RelativeRoundtripTimeoutPolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    RelativeRoundtripTimeoutPolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    RelativeRoundtripTimeoutPolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~RelativeRoundtripTimeoutPolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    TimeBase::TimeT relative_expiry (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    RelativeRoundtripTimeoutPolicy_tie (const RelativeRoundtripTimeoutPolicy_tie &);
    void operator= (const RelativeRoundtripTimeoutPolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class RoutingPolicy;
  typedef RoutingPolicy *RoutingPolicy_ptr;
  class TAO_Export RoutingPolicy : public virtual POA_CORBA::Policy,
                                   public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    RoutingPolicy (void);
  public:
    RoutingPolicy (const RoutingPolicy& rhs);
    virtual ~RoutingPolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual Messaging::RoutingTypeRange routing_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::RoutingPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_RoutingPolicy     : public virtual Messaging::RoutingPolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_RoutingPolicy (
        RoutingPolicy_ptr  servant,
        TAO_Stub *stub
      );
    RoutingPolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual Messaging::RoutingTypeRange routing_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    RoutingPolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export RoutingPolicy_tie : public RoutingPolicy
  {
  public:
    RoutingPolicy_tie (T &t);
    // the T& ctor
    RoutingPolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    RoutingPolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    RoutingPolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~RoutingPolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    Messaging::RoutingTypeRange routing_range (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    RoutingPolicy_tie (const RoutingPolicy_tie &);
    void operator= (const RoutingPolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class MaxHopsPolicy;
  typedef MaxHopsPolicy *MaxHopsPolicy_ptr;
  class TAO_Export MaxHopsPolicy : public virtual POA_CORBA::Policy,
                                   public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    MaxHopsPolicy (void);
  public:
    MaxHopsPolicy (const MaxHopsPolicy& rhs);
    virtual ~MaxHopsPolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual CORBA::UShort max_hops (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::MaxHopsPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_MaxHopsPolicy     : public virtual Messaging::MaxHopsPolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_MaxHopsPolicy (
        MaxHopsPolicy_ptr  servant,
        TAO_Stub *stub
      );
    MaxHopsPolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::UShort max_hops (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    MaxHopsPolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export MaxHopsPolicy_tie : public MaxHopsPolicy
  {
  public:
    MaxHopsPolicy_tie (T &t);
    // the T& ctor
    MaxHopsPolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    MaxHopsPolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    MaxHopsPolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~MaxHopsPolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::UShort max_hops (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    MaxHopsPolicy_tie (const MaxHopsPolicy_tie &);
    void operator= (const MaxHopsPolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

  class QueueOrderPolicy;
  typedef QueueOrderPolicy *QueueOrderPolicy_ptr;
  class TAO_Export QueueOrderPolicy : public virtual POA_CORBA::Policy,
                                      public virtual TAO_Locality_Constrained_ServantBase
  {
  protected:
    QueueOrderPolicy (void);
  public:
    QueueOrderPolicy (const QueueOrderPolicy& rhs);
    virtual ~QueueOrderPolicy (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual Messaging::Ordering allowed_orders (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;

    Messaging::QueueOrderPolicy *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_QueueOrderPolicy     : public virtual Messaging::QueueOrderPolicy,
      public virtual POA_CORBA::_tao_collocated_Policy
  {
  public:
    _tao_collocated_QueueOrderPolicy (
        QueueOrderPolicy_ptr  servant,
        TAO_Stub *stub
      );
    QueueOrderPolicy_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual Messaging::Ordering allowed_orders (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    QueueOrderPolicy_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export QueueOrderPolicy_tie : public QueueOrderPolicy
  {
  public:
    QueueOrderPolicy_tie (T &t);
    // the T& ctor
    QueueOrderPolicy_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    QueueOrderPolicy_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    QueueOrderPolicy_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~QueueOrderPolicy_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    Messaging::Ordering allowed_orders (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PolicyType policy_type (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Policy_ptr copy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void destroy (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    QueueOrderPolicy_tie (const QueueOrderPolicy_tie &);
    void operator= (const QueueOrderPolicy_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

#if defined (TAO_HAS_AMI_CALLBACK)

  class ReplyHandler;
  typedef ReplyHandler *ReplyHandler_ptr;
  class TAO_Export ReplyHandler :  public virtual PortableServer::ServantBase
  {
  protected:
    ReplyHandler (void);
  public:
    ReplyHandler (const ReplyHandler& rhs);
    virtual ~ReplyHandler (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    static void _is_a_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void _non_existent_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    CORBA::Boolean in_mult_inheritance (void);

    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    Messaging::ReplyHandler *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
  };


  class TAO_Export _tao_thru_poa_collocated_ReplyHandler     : public virtual Messaging::ReplyHandler
  {
  public:
    _tao_thru_poa_collocated_ReplyHandler (
        TAO_Stub *stub
      );
    virtual CORBA::Boolean _is_a(
        const CORBA::Char *logical_type_id,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );

    virtual CORBA::Boolean _non_existent(
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );

  };


  class TAO_Export _tao_direct_collocated_ReplyHandler     : public virtual Messaging::ReplyHandler
  {
  public:
    _tao_direct_collocated_ReplyHandler (
        ReplyHandler_ptr  servant,
        TAO_Stub *stub
      );
    virtual CORBA::Boolean _is_a(
        const CORBA::Char *logical_type_id,
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );

    ReplyHandler_ptr _get_servant (void) const;

    virtual CORBA::Boolean _non_existent(
        CORBA_Environment &ACE_TRY_ENV = TAO_default_environment ()
      );


  private:
    ReplyHandler_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export ReplyHandler_tie : public ReplyHandler
  {
  public:
    ReplyHandler_tie (T &t);
    // the T& ctor
    ReplyHandler_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    ReplyHandler_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    ReplyHandler_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~ReplyHandler_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    ReplyHandler_tie (const ReplyHandler_tie &);
    void operator= (const ReplyHandler_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */

#endif /* TAO_HAS_AMI_CALLBACK */

#if defined (TAO_HAS_AMI_POLLER)

  class Poller;
  typedef Poller *Poller_ptr;
  class TAO_Export Poller : public virtual POA_CORBA::Pollable
  {
  protected:
    Poller (void);
  public:
    Poller (const Poller& rhs);
    virtual ~Poller (void);
    virtual CORBA::Boolean _is_a (
        const char* logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void* _downcast (
        const char* logical_type_id
      );
    virtual CORBA::Object_ptr operation_target (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void _get_operation_target_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual char * operation_name (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void _get_operation_name_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual Messaging::ReplyHandler_ptr associated_handler (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void _get_associated_handler_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void associated_handler (
        Messaging::ReplyHandler_ptr associated_handler,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void _set_associated_handler_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual CORBA::Boolean is_from_poller (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void _get_is_from_poller_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual CORBA::Object_ptr target (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void _get_target_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual char * op_name (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      ) = 0;
    static void _get_op_name_skel (
        CORBA::ServerRequest &_tao_req,
        void *_tao_obj,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void _is_a_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void _non_existent_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    CORBA::Boolean in_mult_inheritance (void);

    static void is_ready_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    static void create_pollable_set_skel (
        CORBA::ServerRequest &req,
        void *obj,
        void *context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

    Messaging::Poller *_this (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual const char* _interface_repository_id (void) const;
    virtual void _dispatch (
        CORBA::ServerRequest &_tao_req,
        void *_tao_context,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
  };

  class TAO_Export _tao_collocated_Poller     : public virtual Messaging::Poller,
      public virtual POA_CORBA::_tao_collocated_Pollable
  {
  public:
    _tao_collocated_Poller (
        Poller_ptr  servant,
        TAO_Stub *stub
      );
    Poller_ptr _get_servant (void) const;
    virtual CORBA::Boolean _is_a (
        const char *logical_type_id,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::Object_ptr operation_target (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual char * operation_name (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual Messaging::ReplyHandler_ptr associated_handler (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual void associated_handler (
        Messaging::ReplyHandler_ptr associated_handler,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::Boolean is_from_poller (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual CORBA::Object_ptr target (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    virtual char * op_name (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );

  private:
    Poller_ptr servant_;
  };

#if defined (ACE_HAS_USING_KEYWORD)
  // TIE class: Refer to CORBA v2.2, Section 20.34.4
  template <class T>
  class TAO_Export Poller_tie : public Poller
  {
  public:
    Poller_tie (T &t);
    // the T& ctor
    Poller_tie (T &t, PortableServer::POA_ptr poa);
    // ctor taking a POA
    Poller_tie (T *tp, CORBA::Boolean release=1);
    // ctor taking pointer and an ownership flag
    Poller_tie (T *tp, PortableServer::POA_ptr poa, CORBA::Boolean release=1);
    // ctor with T*, ownership flag and a POA
    ~Poller_tie (void);
    // dtor

    // TIE specific functions
    T *_tied_object (void);
    // return the underlying object
    void _tied_object (T &obj);
    // set the underlying object
    void _tied_object (T *obj, CORBA::Boolean release=1);
    // set the underlying object and the ownership flag
    CORBA::Boolean _is_owner (void);
    // do we own it
    void _is_owner (CORBA::Boolean b);
    // set the ownership

    // overridden ServantBase operations
    PortableServer::POA_ptr _default_POA (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Object_ptr operation_target (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    char * operation_name (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    Messaging::ReplyHandler_ptr associated_handler (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    void associated_handler (
        Messaging::ReplyHandler_ptr associated_handler,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Boolean is_from_poller (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Object_ptr target (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    char * op_name (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::Boolean is_ready (
        CORBA::ULong timeout,
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
    CORBA::PollableSet_ptr create_pollable_set (
        CORBA::Environment &ACE_TRY_ENV =
          CORBA::Environment::default_environment ()
      );
private:
    T *ptr_;
    PortableServer::POA_var poa_;
    CORBA::Boolean rel_;

    // copy and assignment are not allowed
    Poller_tie (const Poller_tie &);
    void operator= (const Poller_tie &);
  };

#endif /* ACE_HAS_USING_KEYWORD */
#endif /* TAO_HAS_AMI_POLLER */

}
TAO_NAMESPACE_CLOSE

// #include "tao/MessagingS_T.h"

#if defined (__ACE_INLINE__)
#include "tao/MessagingS.i"
#endif /* defined INLINE */

#if defined(_MSC_VER)
#pragma warning(default:4250)
#endif /* _MSC_VER */

#endif /* TAO_HAS_CORBA_MESSAGING */

#endif /* TAO_IDL_MESSAGINGS_H */
