/***************************************************************************

 Linux libGGI driver by Gabriele Boccone - clayton@dist.unige.it

  Something is recycled (and/or tweaked) from svgalib.c. This is only
  a "Quick and Dirty Hack"(TM) to make things interesting.

  Please if you test GGI-mame send me a mail, saying: "It works on my system"
  or "It does not work on my system", and what kind of computer you tested
  GGI-mame on. If you also want to send me sugar, coffee, chocolate, etc,
  feel free to send it by e-mail.

  Adapted for xmame-0.31 by Christian Groessler - cpg@aladdin.de

  * tested with GGI 2.0 Beta2 *
***************************************************************************/
#ifdef ggi
#define __GGI_C

#include <ggi/ggi.h>
#include <signal.h>

/*#define KEY_DEBUG*/
/*#define FNCALL_DEBUG*/

#include "xmame.h"
#include "driver.h"
#include "devices.h"
#include "keyboard.h"

static int video_width;
static int video_height;
static ggi_visual_t vis;
static int screen_startx,screen_starty;
static int lastmouse[JOY_AXIS]={0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

static void ggi_cleanup(void);

/* Possible states of keys */
#define	RELEASED	0
#define	PRESSED		1

static unsigned char kstate[128];

static int first_call=TRUE;
static void (*oldsigsegvh)(int) = NULL;
static void (*oldsigbush)(int) = NULL;
static void (*oldsigquith)(int) = NULL;

/* emergency signal handler: try to restore things */

void myhandler(int signum)
{
    unsigned char *signam;
    unsigned char tmpbuf[32];
    void (*orgh)(int) = NULL;
    switch(signum) {
        case SIGSEGV:
            signam="SIGSEGV";
            orgh=oldsigsegvh;
            break;
        case SIGBUS:
            signam="SIGBUS";
            orgh=oldsigbush;
            break;
        case SIGQUIT:
            signam="SIGQUIT";
            orgh=oldsigquith;
            break;
        default:
            sprintf(tmpbuf,"unknown(%d)",signum);
            signam=tmpbuf;
    }
    fprintf(stderr_file,"%s: aborting...\n",signam);
    if (first_call) {
        first_call=FALSE;
        ggi_cleanup(); /* yeah, I had him crashing in ggi_cleanup()! */
    }
    if (orgh) orgh(signum);
    exit(255);
}

int sysdep_init(void)
{
   ggiInit();
   return OSD_OK;
}

void sysdep_close(void)
{
}

void set_video_mode(void)
{
    int err;
    ggi_mode gmode;
    int type = GT_8BIT; /* more than 8-bit visual not supported yet */
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"set_videomode called\n");
#endif

    vis = ggiOpen(NULL);

    if (!vis) {
	fprintf (stderr_file, "Cannot open GGI library. Exiting\n");
	exit(1);
    }

    ggiSetFlags(vis, GGIFLAG_ASYNC);
    ggiSetEventMask(vis, emKey | emPointer);

    err = ggiSetGraphMode(vis, visual_width, visual_height, visual_width,
			  visual_height, type);

    /* err will probably be 0 only if we are in an X-window, but we need
       to draw into something anyway. 320x200 is not much, but it works */

    /* there is room for improvement in the mode selection */
    /* much room! */
    if (err) err = ggiSetGraphMode(vis, 320, 240, 320, 240, type);
    if (err) err = ggiSetGraphMode(vis, 320, 200, 320, 200, type);
    if (err) err = ggiSetGraphMode(vis, 640, 400, 640, 400, type);
    if (err) err = ggiSetGraphMode(vis, 640, 480, 640, 480, type);

    if (err) {
	fprintf (stderr_file, "Cannot set graphics mode. Exiting\n");
        ggi_cleanup();
	exit(1);
    }

    ggiGetMode(vis, &gmode); /* Maybe we did not get what we asked for */
    if ((gmode.visible.x != visual_width)||
	(gmode.visible.y != visual_height)) {
	fprintf(stderr_file,
		"Warning: cannot get mode %dx%d, setting to %dx%d\n",
		visual_width, visual_height, gmode.visible.x,
		gmode.visible.y);
    }
    video_width = gmode.visible.x;
    video_height = gmode.visible.y;
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"set_videomode return\n");
#endif
}

/* This name doesn't really cover this function, since it also sets up mouse
   and keyboard. This is done over here, since on most display targets the
   mouse and keyboard can't be setup before the display has. */
int sysdep_create_display(void)
{
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"sysdep_create_display called\n");
#endif

    if(video_16bit)
    {
        fprintf(stderr_file, "%s doesn't support 16bpp video modes\n", title);
        return OSD_NOT_OK;
    }

    /*int sysdep_keyboard_init(void);*/
    oldsigsegvh=signal(SIGSEGV,myhandler);
    oldsigbush=signal(SIGBUS,myhandler);
    oldsigquith=signal(SIGQUIT,myhandler);
    if (oldsigsegvh == SIG_ERR || oldsigbush == SIG_ERR || oldsigquith == SIG_ERR) {
	fprintf (stderr_file, "Cannot install signal handler. Exiting\n");
        ggi_cleanup();
	exit(1);
    }
    if (ggiInit() < 0) {
        fprintf(stderr_file,"Unable to init LibGGI!\n");
        ggi_cleanup();
        exit(1);
    }
    set_video_mode();

    screen_startx = (video_width - visual_width) / 2;
    screen_starty = (video_height - visual_height) / 2;
    if (screen_startx < 0) screen_startx = 0;
    /* and screen_starty? No, we still need its real value */

    local_key=kstate;
    memset(kstate,RELEASED,sizeof(kstate));
    sysdep_mark_palette_dirty();
    osd_mark_dirty (0,0,bitmap->width-1,bitmap->height-1,1);
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"sysdep_create_display return\n");
#endif
    return(OSD_OK);
}


/*
 * not needed by ggi
 */
void sysdep_alloc_palette(void)
{
}

void sysdep_alloc_palette_16bpp(unsigned short *pens)
{
}

/* close down the display */
void osd_close_display(void)
{
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"osd_close_display called\n");
#endif
    if (oldsigsegvh) signal(SIGSEGV,oldsigsegvh);
    if (oldsigbush) signal(SIGBUS,oldsigbush);
    if (oldsigquith) signal(SIGBUS,oldsigquith);
    osd_dirty_close();
    osd_free_bitmap(bitmap);
    ggi_cleanup();
}

static void ggi_cleanup(void)
{
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"ggi_cleanup called\n");
#endif
    if (vis) {
      ggiClose(vis);
      vis=NULL;
    }
    if (bitmap) free(bitmap);
    ggiExit();
}


/* This is horrible, but seems to be the only way */

void sysdep_modify_pen(int pen,unsigned char red, unsigned char green, unsigned char blue)
{
   ggi_color gpen;
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"sysdep_modify_pen called\n");
#endif

   if (!vis) return; /* visual not initialized yet -- do nothing */
   
   gpen.r = red << 8;
   gpen.g = green << 8;
   gpen.b = blue << 8;
   ggiSetPalette(vis, pen, 1, &gpen);
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"sysdep_modify_pen return\n");
#endif
}

void sysdep_get_pen_16bpp(int pen, unsigned char* red, unsigned char *green,
   unsigned char *blue)
{
}

/*static int fcall=1;*/

/* Update the display. */
void sysdep_update_display(void)
{
    int i,j;
    int y, max_y;
    int h, max_h;
    int max_j = video_height - screen_starty;
    int y_delta = 0;
    int y_sd = screen_starty;
    int loop_a,loop_b,loop_c;

#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"sysdep_update_display called\n");
#endif

    if (screen_starty < 0) {
        y_delta = -screen_starty;
        max_j = video_height;
        y_sd = 0;
    }

#if 1
    switch (use_dirty) {
        case 0: /* non dirty */
            /*if (fcall) { fcall=0; printf("NON DIRTY!\n"); }*/
            for (i=visual.min_y+y_delta,j=0; i<=visual.max_y && j<max_j; i++,j++) {
                ggiPutHLine(vis, screen_startx, j+y_sd, visual_width,
                            bitmap->line[i]+visual.min_x);
            }
            break;
        case 1: /* dirty */
            /*if (fcall) { fcall=0; printf("DIRTY!\n"); }*/
            osd_dirty_merge();
            /* fall thru */
        case 2: /* vector */
            /*if (fcall) { fcall=0; printf("VECTOR!\n"); }*/
            max_y = (visual.max_y+1) >> 3;
            for (y=(visual.min_y+y_delta)>>3,j=0;y<max_y && j<max_j; y++, j+=8)
            {
                if (dirty_lines[y])
                {
                    int x, max_x, max_x1;
                    max_x1 = (visual.max_x+1) >> 3;
                    for(x=visual.min_x>>3; x<max_x1; x++)
                    {
                        if (dirty_blocks[y][x])
                        {
                            int min_x = x << 3;

                            do {
                                dirty_blocks[y][x]=0;
                                x++;
                            } while (dirty_blocks[y][x]);
                            max_x = x << 3;
                            h = y << 3;
                            max_h = h + 8;
#if 0
                            for( ; h < max_h; h++) {
                                ggiPutHLine(vis,
                                            screen_startx+min_x,
                                            /*h + y_sd,*/
                                            j + y_sd + h - (y<<3),
                                            max_x-min_x,
                                            bitmap->line[h]+min_x);
                            } 
#else
                            /* some calculations taken out of the loop: */
                            loop_a=screen_startx+min_x;
                            loop_b=j+y_sd-(y<<3);
                            loop_c=max_x-min_x;
                            for( ; h < max_h; h++) {
                                ggiPutHLine(vis,
                                            loop_a,
                                            loop_b+h,
                                            loop_c,
                                            bitmap->line[h]+min_x);
                            } 
#endif
                        }
                    }
                    dirty_lines[y] = 0;
                }
            }
            break;
    }
#else
    for (i=visual.min_y+y_delta,j=0; i<=visual.max_y && j<max_j; i++,j++) {
        ggiPutHLine(vis, screen_startx, j+y_sd, visual_width,
                    bitmap->line[i]+visual.min_x);
    }
#endif

    /* This can slow down game playing, but is very important.
       disable it *only* if you need to. */
    ggiFlush(vis);
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"sysdep_update_display leave\n");
#endif
}

int sysdep_mapkey(char *arg) 
{
    return OSD_OK;
}

int ggi_key(int sym,int code,int label,int pressrel)
{
    unsigned int keycode=KEY_NONE;
    unsigned int sym1=sym&255;

#ifdef KEY_DEBUG
    fprintf(stderr_file,
            "Key %s detected: sym = 0x%02x, code = 0x%02x, label = 0x%02x\n",
            pressrel==1?" press ":"release",sym,code,label);
#endif

    switch (label) { /* for now, the simple way */
        case GIIUC_Escape: keycode = KEY_ESC;   break;
        case GIIUC_Tab:    keycode = KEY_TAB;   break;
        case GIIUC_Return: keycode = KEY_ENTER; break;
        case GIIUC_Space:  keycode = KEY_SPACE; break;
        case GIIUC_0:      keycode = KEY_0;     break;
        case GIIUC_1:      keycode = KEY_1;     break;
        case GIIUC_2:      keycode = KEY_2;     break;
        case GIIUC_3:      keycode = KEY_3;     break;
        case GIIUC_4:      keycode = KEY_4;     break;
        case GIIUC_5:      keycode = KEY_5;     break;
        case GIIUC_6:      keycode = KEY_6;     break;
        case GIIUC_7:      keycode = KEY_7;     break;
        case GIIUC_8:      keycode = KEY_8;     break;
        case GIIUC_9:      keycode = KEY_9;     break;
        case GIIUC_A:      keycode = KEY_A;     break;
        case GIIUC_B:      keycode = KEY_B;     break;
        case GIIUC_C:      keycode = KEY_C;     break;
        case GIIUC_D:      keycode = KEY_D;     break;
        case GIIUC_E:      keycode = KEY_E;     break;
        case GIIUC_F:      keycode = KEY_F;     break;
        case GIIUC_G:      keycode = KEY_G;     break;
        case GIIUC_H:      keycode = KEY_H;     break;
        case GIIUC_I:      keycode = KEY_I;     break;
        case GIIUC_J:      keycode = KEY_J;     break;
        case GIIUC_K:      keycode = KEY_K;     break;
        case GIIUC_L:      keycode = KEY_L;     break;
        case GIIUC_M:      keycode = KEY_M;     break;
        case GIIUC_N:      keycode = KEY_N;     break;
        case GIIUC_O:      keycode = KEY_O;     break;
        case GIIUC_P:      keycode = KEY_P;     break;
        case GIIUC_Q:      keycode = KEY_Q;     break;
        case GIIUC_R:      keycode = KEY_R;     break;
        case GIIUC_S:      keycode = KEY_S;     break;
        case GIIUC_T:      keycode = KEY_T;     break;
        case GIIUC_U:      keycode = KEY_U;     break;
        case GIIUC_V:      keycode = KEY_V;     break;
        case GIIUC_W:      keycode = KEY_W;     break;
        case GIIUC_X:      keycode = KEY_X;     break;
        case GIIUC_Y:      keycode = KEY_Y;     break;
        case GIIUC_Z:      keycode = KEY_Z;     break;
    }

    if (keycode == KEY_NONE) {
        switch((sym>>8)&255) {
            case GII_KT_FN:
                if (sym1 && sym1 <= 10)
                    keycode = KEY_F1 + sym1 - 1;
		if (sym1 == GIIK_F11) keycode = KEY_F11;
		if (sym1 == GIIK_F12) keycode = KEY_F12;
                break;
            case GII_KT_SPEC:
                switch (sym1) {
                    case (GIIK_Up & 255):    keycode = KEY_UP;    break;
                    case (GIIK_Down & 255):  keycode = KEY_DOWN;  break;
                    case (GIIK_Left & 255):  keycode = KEY_LEFT;  break;
                    case (GIIK_Right & 255): keycode = KEY_RIGHT; break;
                    /* case (GIIK_PageUp & 255): same as next entry */
                    case (GIIK_Prior & 255): keycode = KEY_PGUP;  break;
                    /* case (GIIK_PageDown & 255):  same as next entry */
                    case (GIIK_Next & 255):  keycode = KEY_PGDN;  break;
                    case (GIIK_Home & 255):  keycode = KEY_HOME;  break;
                    case (GIIK_End & 255):   keycode = KEY_END;   break;
                    case (GIIK_NumLock & 255): keycode = KEY_NUMLOCK; break;
                    case (GIIK_ScrollLock & 255): keycode = KEY_SCRLOCK; break;
                }
                break;
            case GII_KT_MOD:
                switch (sym1) {
                    case GII_KM_SHIFT:   keycode = KEY_LSHIFT;   break;
                    case (GII_KM_SHIFT | GII_KM_RIGHT):
                                         keycode = KEY_RSHIFT;   break;
                    case GII_KM_CTRL:    keycode = KEY_LCONTROL; break;
                    case (GII_KM_CTRL | GII_KM_RIGHT):
                                         keycode = KEY_RCONTROL; break;
                    case GII_KM_ALT:
                    case GII_KM_META:    keycode = KEY_ALT;      break;
                    case (GII_KM_ALT | GII_KM_RIGHT):
                    case (GII_KM_META | GII_KM_RIGHT):
                                         keycode = KEY_ALTGR;    break;
                }
                break;

        }
    }

    if (keycode == KEY_NONE) { /* nothing found yet */
        keycode = code;
        if (keycode > 127) keycode=KEY_NONE;

        switch (keycode) {
            case 0x69:
                keycode=KEY_LEFT;
                break;
            case 0x6a:
                keycode=KEY_RIGHT;
                break;
            case 0x67:
                keycode=KEY_UP;
                break;
            case 0x6c:
                keycode=KEY_DOWN;
                break;
        }
    }

#ifdef KEY_DEBUG
    fprintf(stderr_file,"returning keycode = %d\n",keycode);
#endif
    return(keycode);
}

void sysdep_update_keyboard(void)
{
    ggi_event_mask em = emAll; /*emKeyPress | emKeyRelease;*/
    ggi_event ev;
    struct timeval to = { 0 , 0 };
    int keycode;
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"sysdep_update_keyboard called\n");
#endif

    if (vis) {
        while(ggiEventPoll(vis,em,&to)) {
            ggiEventRead(vis,&ev,em);

            switch(ev.any.type) {

              case evKeyPress:
                  keycode = ggi_key(ev.key.sym,ev.key.button,ev.key.label,1);
                  kstate[keycode]=1;
                  break;

              case evKeyRelease:
                  keycode = ggi_key(ev.key.sym,ev.key.button,ev.key.label,2);
                  kstate[keycode]=0;
                  break;
            }

            to.tv_sec=to.tv_usec=0;
        }
    }
#ifdef FNCALL_DEBUG
    fprintf(stderr_file,"sysdep_update_keyboard leave\n");
#endif
    return;
}

/* mouse not really tested */
void sysdep_mouse_poll(void)
{
    ggi_event_mask em = emPtrButtonPress | emPtrButtonRelease | emPtrMove;
    ggi_event ev;
    struct timeval to = { 0 , 0 };
    int bi;

    if (vis) {
        while(ggiEventPoll(vis,em,&to)) {
            ggiEventRead(vis,&ev,em);
            bi = 0;

            switch(ev.any.type) {

              case evPtrButtonPress:
                  bi = 1;
              case evPtrButtonRelease:
                  if (ev.pbutton.button < JOY_BUTTONS)
                     mouse_data[0].buttons[ev.pbutton.button] = bi;
                  break;
              case evPtrAbsolute:
                  mouse_data[0].deltas[0] = lastmouse[0] - ev.pmove.x;
                  mouse_data[0].deltas[1] = lastmouse[1] - ev.pmove.y;
                  lastmouse[0] = ev.pmove.x;
                  lastmouse[1] = ev.pmove.y;
                  break;
              case evPtrRelative:
                  mouse_data[0].deltas[0] = ev.pmove.x;
                  mouse_data[0].deltas[1] = ev.pmove.y;
                  lastmouse[0] += ev.pmove.x;
                  lastmouse[1] += ev.pmove.y;
                  break;
            }
            to.tv_sec=to.tv_usec=0;
        }
    }
}

void osd_led_w(int led,int on) 
{
}
#endif /* ifdef ggi */
