/*
 * X-Mame x11 input code
 *
 */
#include "xmame.h"
#include "devices.h"
#include "x11.h"
#include "xkeyboard.h"

static int current_mouse[JOY_AXIS] = {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0};

/*
 * Parse keyboard events
 */
void sysdep_update_keyboard (void)
{
  XEvent 		E;
  int	 		keycode,code;
  int			mask;
  int 			*pt;
  static int		old_grab_mouse = FALSE;
  
  /* handle winkey mappings */
  if (use_winkeys)
  {
    extended_code_table[XK_Meta_L&0x1FF] = KEY_LWIN; 
    extended_code_table[XK_Meta_R&0x1FF] = KEY_RWIN; 
  }

  /* query all events that we have previously requested */
  while ( XPending(display) )
  {
    mask = FALSE;
    
    XNextEvent(display,&E);
/*  fprintf(stderr_file,"Event: %d\n",E.type); */

    /* we don't have to check x11_video_mode or extensions like xil here,
       since our eventmask should make sure that we only get the event's matching
       the current update method */
    switch (E.type)
    {
      /* display events */
#ifdef x11
      case Expose:
  	if ( E.xexpose.count == 0 ) x11_window_refresh_screen();
	break;
#endif
      case FocusIn:
	/* to avoid some meta-keys to get locked when wm iconify xmame, we must
	perform a key reset whenever we retrieve keyboard focus */
	memset((void *)&xkey[0], FALSE, 128*sizeof(unsigned char) );
	if (old_grab_mouse)
	{
            if (!XGrabPointer(display, window, True, 0, GrabModeAsync,
                GrabModeAsync, window, None, CurrentTime))
            {
                if (show_cursor) XDefineCursor(display,window,invisible_cursor);
                x11_grab_mouse = TRUE;
            }
	}
	break;
      case FocusOut:
        if (x11_grab_mouse)
        {
            XUngrabPointer(display, CurrentTime);
            if (show_cursor) XDefineCursor(display,window,normal_cursor);
            x11_grab_mouse = FALSE;
            old_grab_mouse = TRUE;
        }
        break;
      case EnterNotify:
	if (use_private_cmap) XInstallColormap(display,colormap);
	break;	
      case LeaveNotify:
	if (use_private_cmap) XInstallColormap(display,DefaultColormapOfScreen(screen));
	break;	
#ifdef USE_XIL
      case ConfigureNotify:
	update_xil_window_size( E.xconfigure.width, E.xconfigure.height );
	break;
#endif
      /* input events */    
      case MotionNotify:
        current_mouse[0] += E.xmotion.x_root;
        current_mouse[1] += E.xmotion.y_root;
        break;
      case ButtonPress:
        mask = TRUE;
#ifdef USE_DGA
        /* Some buggy combination of XFree and virge screwup the viewport
           on the first mouseclick */
        if(xf86_dga_first_click) { xf86_dga_first_click = 0; xf86_dga_fix_viewport = 1; }
#endif          
      case ButtonRelease:
        mouse_data[0].buttons[E.xbutton.button-1] = mask;
        break;
      case KeyPress:
        mask = TRUE;
      case KeyRelease:
	keycode = XLookupKeysym ((XKeyEvent *) &E, 0);
	/* fprintf(stderr, "Keyevent key:%04X\n", keycode); */
	/* look which table should be used */
	pt=code_table;
        if ( (keycode & 0xfe00) == 0xfe00 )
        {
          pt=extended_code_table;
	  code=keycode&0x01ff;
	}
	else
	  code=keycode&0x00ff;
	/* if unnasigned key ignore it */
	if ( *(pt+code) ) xkey [ *(pt+code) ] = mask;
	break;
#ifdef X11_JOYSTICK
      /* grrr we can't use case here since the event types for XInput devices
         aren't hardcoded, since we should have caught anything else above,
         just asume it's an XInput event */
      default:
	  process_x11_joy_event(&E);
	  break;
#endif
    } /* switch */
  } /* while */
}

/*
 *  keyboard remapping routine
 *  invoiced in startup code
 *  returns 0-> success 1-> invalid from or to
 */
int sysdep_mapkey(char *arg)
{
   int from,to;
#ifdef ultrix
   /* ultrix sscanf() requires explicit leading of 0x for hex numbers */
   if ( sscanf(arg,"0x%x,0x%x",&from,&to) == 2)
#else
   if ( sscanf(arg,"%x,%x",&from,&to) == 2)
#endif
   {
      /* perform tests */
      /* fprintf(stderr_file,"trying to map %x to%x\n",from,to); */
      if ( (to>=0) || (to<=127) )
      {
         if ( (from>=0) && (from<=0x00ff) ) 
         {
            code_table[from]=to; return OSD_OK;
         }
         if ( (from>=0xfe00) && (from<=0xffff) ) 
         {
            extended_code_table[from&0x01ff]=to; return OSD_OK;
         }
      }
      /* stderr_file isn't defined yet when we're called. */
      fprintf(stderr,"Invalid keymapping %s. Ignoring...\n", arg);
   }
   return OSD_NOT_OK;
}

void sysdep_mouse_poll (void)
{
	int i;
	if(x11_video_mode == X11_DGA)
	{
		/* 2 should be JOY_AXIS but we don't support more
		   then 2 axis at the moment so this is faster */
		for (i=0; i<2; i++)
		{
		   mouse_data[0].deltas[i] = current_mouse[i];
		   current_mouse[i] = 0;
		}
	}
	else
	{
		Window root,child;
		int root_x, root_y, pos_x, pos_y;
		unsigned int keys_buttons;
	
		if (!XQueryPointer(display,window, &root,&child, &root_x,&root_y,
			&pos_x,&pos_y,&keys_buttons) )
		{
			mouse_data[0].deltas[0] = 0;
			mouse_data[0].deltas[1] = 0;
			return;
		}
	
		if ( x11_grab_mouse )
		{
			XWarpPointer(display, None, window, 0, 0, 0, 0,
				visual_width/2, visual_height/2);
			mouse_data[0].deltas[0] = pos_x - visual_width/2;
			mouse_data[0].deltas[1] = pos_y - visual_height/2;
		}
		else
		{
			mouse_data[0].deltas[0] = pos_x - current_mouse[0];
			mouse_data[0].deltas[1] = pos_y - current_mouse[1];
			current_mouse[0] = pos_x;
			current_mouse[1] = pos_y;
		}
	}
}

void osd_led_w(int led,int on) 
{
}
