#include "cthugha.h"
#include "interface.h"
#include "sound.h"
#include "AutoChanger.h"
#include "SoundProcess.h"
#include "CthughaBuffer.h"
#include "flames.h"
#include "keys.h"

#include "imath.h"


class InterfaceElementCoreOption : public InterfaceElement {
    CoreOption * option;
public:
    InterfaceElementCoreOption(const char * fmt, CoreOption * opt) : 
	InterfaceElement(fmt, TEXT_COLOR_NORMAL, TEXT_COLOR_HIGHLIGHT, 1),
	option(opt) {}

    void display(int line);
    int do_key(int key);
};


    
class InterfaceCoreOption : public InterfaceMain {

    int current;

    void updateBuffer() {
	if(elements) {
	    for(int i=0; i < nElements; i++) {
		delete elements[i];
		elements[i] = NULL;
	    }
	} else {
	    elements = new InterfaceElement *[nElements];
	}

	// using CthughaBuffer::current is NOT working, I think it has to
	// with some compiler optimizations
	CthughaBuffer & b = CthughaBuffer::buffers[ CthughaBuffer::nCurrent ];
	
	elements[0] = new InterfaceElementTitle      ("Core Options");
	elements[1] = new InterfaceElementText       ("---------------------------------------");
	elements[2] = new InterfaceElementOption     ("Current Buffer (<,>)  : %s", &CthughaBuffer::nCurrent);
	elements[3] = new InterfaceElementCoreOption ("Display (d,D)         : %s", &screen);
	elements[4] = new InterfaceElementCoreOption ("Flame (f,F)           : %s", &b.flame);
	elements[5] = new InterfaceElementCoreOption ("General Flame (g)     : %s", &b.flameGeneral);
	elements[6] = new InterfaceElementCoreOption ("Border (=)            : %s", &b.border);
	elements[7] = new InterfaceElementCoreOption ("Translate (t,T)       : %s", &b.translate);
	elements[8] = new InterfaceElementCoreOption ("Wave (w)              : %s", &b.wave);
	elements[9] = new InterfaceElementCoreOption ("Sound Processing (m,M): %s", &b.soundProcess);
	elements[10] = new InterfaceElementCoreOption("Table (b,B)           : %s", &b.table);
	elements[11] = new InterfaceElementCoreOption("WaveScale (W)         : %s", &b.waveScale);
	elements[12] = new InterfaceElementCoreOption("Palette (p,P)         : %s", &b.palette);
	elements[13] = new InterfaceElementCoreOption("PCX (x,X))            : %s", &b.pcx);
	elements[14] = new InterfaceElementCoreOption("3D-Object (j,J)       : %s", &b.object);
	elements[15] = new InterfaceElementCoreOption("Flashlight (s)        : %s", &b.flashlight);


	if((sel >= 0) && (sel < 16))
	    elements[sel]->selected = 1;
	
	current = CthughaBuffer::nCurrent;
    }
public:
    InterfaceCoreOption(int p) :
	InterfaceMain(NULL, 16, p) {
	updateBuffer();
    }
    virtual int do_key(int key) {
	key = InterfaceMain::do_key(key);

	if( current != CthughaBuffer::nCurrent)
	    updateBuffer();
	
	return key;
    }
    virtual void display();
};
    

void InterfaceElementCoreOption::display(int line) {
    char str[512];
    char fmt[512];
    char in[512];
    
    sprintf(fmt, "%%c%%-%ds%%c", min(text_size.x - 3, 77));
    sprintf(in, text, option->text());

    // make format and include the > <
    sprintf(str, fmt, selected ? '>' : ' ', in, selected ? '<' : ' ');

    // and bring it to the screen
    displayDevice->print(str, line, 'l', selected ? c2 : c1);
}

int InterfaceElementCoreOption::do_key(int key) {

    switch(key) {
    case '+':
	option->change(+1, 0);
	return 0;
    case '-':
	option->change(-1, 0);
	return 0;
    case CK_RIGHT:
	option->change(+1, 0);
	return 0;
    case CK_LEFT:
	option->change(-1, 0);
	return 0;
    case ' ': case CK_ENTER:
	option->changeRandom(1);
	return 0;
    case 'l': case 'L':
	option->lock.change(1);
	return 0;
    }
    return key;
}


void InterfaceCoreOption::display() {
    if( current != CthughaBuffer::nCurrent)
	updateBuffer();
	
    Interface::display();
}


InterfaceCoreOption  interfaceCoreOptionImpl(2);

Interface * interfaceCoreOption = &interfaceCoreOptionImpl;
    
    
    


