/*
 * Author:      Raphael S. de Moraes <raphael@land.ufrj.br> in April, 1999.
 *
 * @(#)$Header: /mm/src/tgif/v4/RCS/wb_mcast.e,v 4.3 1999/04/16 04:14:23 william Exp $
 */

#ifndef _WB_MCAST_E_
#define _WB_MCAST_E_

#define DEFAULT_MULTICAST_TTL_VALUE	255

#ifndef INADDR_NONE
#define INADDR_NONE	0xffffffff
#endif

#define PACKSIZE	51496
#define DATASIZE	51464
#define SMSIZE		8420
#define HIST_SIZE	1000
#define SM_TABLE_SIZE	20
#define GROUP_NAME_SIZE	16
#define MAX_LOST	100
#define FILENAME        10

/* Options */
#define SM_INTERVAL     0

/* Para simular read nao confiavel */
#define CONF_RECV	0.85
#define CONF_SEND       0.85

enum PCM_pack_type {TRANSMIT, RECEIVE, RETRANSMIT, NOVALUE};
enum PCM_pack_nature {SMPACK, DATAPACK, NACK};

struct PCM_pack_struct
{
	int IP_origem;
	int PID_origem;
	int Nseq;
	char Data[DATASIZE];
};

struct PCM_session_message
{
	int IP;
	int PID;
	int First;
	int Last;
	int Num_lost;
	int Lost[MAX_LOST];
};

struct PCM_log_struct
{
	int IP;
	int PID;
	int Nseq;
	time_t time;
	enum PCM_pack_type ptype;
};

struct PCM_header_struct
{
	enum PCM_pack_nature pnature;
	int Num_blocs;
	int IP;
	int PID;
        time_t timer;
};

#ifdef _TGIF_WB2

extern struct PCM_session_message	PCM_SM[SM_TABLE_SIZE];
extern struct PCM_pack_struct	PCM_hist[HIST_SIZE];
extern int	PCM_socket;
extern int	PCM_port;
extern char	PCM_group[GROUP_NAME_SIZE];
extern struct sockaddr_in	PCM_sockaddr;

extern FILE	*PCM_logfp;
extern int	PCM_myIP;
extern int	PCM_myPID;
extern int	PCM_Nseq;
extern int	PCM_pos_hist;
extern int	PCM_TSM,PCM_Tfunc;
extern int	PCM_tcount, PCM_old_tcount;
extern int	PCM_Nretrans;
extern float	PCM_conf_recv, PCM_conf_send;

extern void	(*PCM_func)();

#endif /* _TGIF_WB2 */

#ifdef _INCLUDE_FROM_WB_MCAST_C_
#undef extern
#define extern
#endif /*_INCLUDE_FROM_WB_MCAST_C_*/

#ifdef _TGIF_WB2

extern int	PCM_joinGroup ARGS_DECL((char *group, int port));
extern void	PCM_leaveGroup ARGS_DECL((int sock, char *group));
extern void	PCM_reusePort ARGS_DECL((int s));
extern void	PCM_setTTLvalue ARGS_DECL((int s, u_char *i));
extern void	PCM_setLoopback ARGS_DECL((int s, u_char loop));
extern int	PCM_sendto ARGS_DECL((
			int Socket, char *Buffer, int Bufsize, int flag,
			struct sockaddr *Dest, int Size));
extern int	PCM_recv ARGS_DECL((
			int Socket, char *Buffer, int Bufsize, int flag));		
extern void	PCM_timer_run ARGS_DECL((int sec, void (*func)()));
extern void	PCM_event ARGS_DECL((void));
extern void	PCM_log_packet ARGS_DECL((
			struct PCM_pack_struct *Pack,
			enum PCM_pack_type ptype));
extern int	PCM_cache ARGS_DECL((struct PCM_pack_struct *Pack));
extern int	PCM_good_toss ARGS_DECL((float ratio));

extern void	PCM_initialize ARGS_DECL((char *logfile));
extern void	PCM_setoption ARGS_DECL((int OptionName,int NewValue));
extern void	PCM_terminate ARGS_DECL((void));
extern void	PCM_update_SM ARGS_DECL((struct PCM_pack_struct *Pack));
extern void	PCM_initialize_SM ARGS_DECL((struct PCM_session_message *SM));
extern void	PCM_send_SM ARGS_DECL((void));
extern void	PCM_get_SM ARGS_DECL((char *Buffer));
extern void	PCM_retrans ARGS_DECL((int IP, int PID, int Nseq));
extern void	PCM_initialize_hist ARGS_DECL((void));
extern int	PCM_copy_SM_buffer ARGS_DECL((
			struct PCM_session_message *SM, char *buffer));
extern int	PCM_copy_buffer_SM ARGS_DECL((
			struct PCM_session_message *SM, char *buffer));
extern int	PCM_copy_pack_buffer ARGS_DECL((
			struct PCM_pack_struct *Pack, char *buffer));
extern int	PCM_copy_buffer_pack ARGS_DECL((
			struct PCM_pack_struct *Pack, char *buffer));

#endif /* _TGIF_WB2 */

#ifdef _INCLUDE_FROM_WB_MCAST_C_
#undef extern
#ifndef _NO_RECURSIVE_EXTERN
#define extern extern
#endif /* ~_NO_RECURSIVE_EXTERN */
#endif /*_INCLUDE_FROM_WB_MCAST_C_*/

#endif /*_WB_MCAST_E*/
