/* String equality predicate. */
#define streq(a,b) (!strcmp((a),(b)))

#define Alloc(type) 	((type *) malloc(sizeof(type)))
#define Malloc(type,n)	((type *) malloc(sizeof(type)*(n)))
#define Free(p)		(free((char *)(p)))
#define Realloc(type,p,n) ((type *) realloc(p, (n)*sizeof(type)))


/* These are the interrupt numbers used by the S48/scsh VM.
** The first three are S48 interrupts. The rest were added for
** scsh to support Unix signals. Note that not all Unixes support
** all these signals.
*/
#define scshint_alarm (0)		/* S48 Unix SIGALRM signal */
#define scshint_keyboard (1)		/* S48 Unix SIGINT signal */
#define scshint_memory_shortage (2)
#define scshint_chld (3)		/* Interrupts from here down are    */
#define scshint_cont (4)		/* Unix signals. The last ten are   */
#define scshint_hup (5)			/* non-Posix, hence not necessarily */
#define scshint_quit (6)		/* found on all Unixes.             */
#define scshint_term (7)
#define scshint_tstp (8)
#define scshint_usr1 (9)
#define scshint_usr2 (10)
#define scshint_info (11)		/* BSD        */
#define scshint_io (12)			/* BSD + SVR4 */
#define scshint_poll (13)		/*       SVR4 */
#define scshint_prof (14)		/* BSD + SVR4 */
#define scshint_pwr (15)		/*       SVR4 */
#define scshint_urg (16)		/* BSD + SVR4 */
#define scshint_vtalrm (17)		/* BSD + SVR4 */
#define scshint_winch (18)		/* BSD + SVR4 */
#define scshint_xcpu (19)		/* BSD + SVR4 */
#define scshint_xfsz (20)		/* BSD + SVR4 */
