/*
   Test AFwriteXX

   $Id: tAFwriteXX.c 1.7 1998/06/13 libtsp-v3r0 $
*/

#include <stdio.h>
#include <libtsp.h>

#define N	8

int
main (argc, argv)

     int argc;
     const char *argv[];

{
  AFILE *AFp;
  int Format;
  long int Nsamp, Nchan;
  float Sfreq;
  float xi[N+2];
  static float xo[N] = {30., 40., 60., -10., -40., 80., 60., -90.};

  sscanf (argv[2], "%d", &Format);
  sscanf (argv[3], "%ld", &Nchan);
  sscanf (argv[4], "%g", &Sfreq);

  AFsetHinfo ("\ntitle: Test file");
  AFp = AFopenWrite (argv[1], Format, Nchan, (double) Sfreq, stdout);
  AFwriteData (AFp, xo, N) ;
  AFclose (AFp) ;

  AFsetNHpar ("text");	/* Assume text file for no header files */
  AFp = AFopenRead (argv[1], &Nsamp, &Nchan, &Sfreq, stdout);
  /* Read several times to test random access */
  /* (1) samples -1 0 1 2 3 4 5 6 7 8 9  === -1 to N+1, total N+2 samples
     (2) samples        2 3 4 5 6 7 8    === 2 to N, total N-1 samples
     (3) samples          3 4            === 3 to 4, total 2 samples
     (4) samples                6 7      === 6 to 7, total 2 samples
  */
  AFreadData (AFp, -1L, xi, N+2);
  AFreadData (AFp, 2L, &xi[3], N-2);
  AFreadData (AFp, 3L, &xi[4], 2);
  AFreadData (AFp, 6L, &xi[7], 2);
  AFclose (AFp);

  VRfPrint (stdout, "Readback data:", xi, N+2);

  return 0;
}
