/*------------- Telecommunications & Signal Processing Lab -------------
                          McGill University

Routine:
  int FLexpHome (const char Fname[], char Ename[])

Purpose:
  Expand the home directory specification for a file

Description:
  This routine takes an input file name and replaces instances of "~" or
  "~USER" which appear as the first component of a directory specification.
  The first form is replaced by the home directory of the current user and the
  second form is replaced by the home directory of the named user.  If the home
  directory cannot be determined, for instance if the user is unknown, the
  output file name is copied from the input file name.

Parameters:
  <-  int FLexpHome
      Number of characters in the output string
   -> const char Fname[]
      Input character string specifying a file name path
  <-  char Ename[]
      Output string with the home directory expanded.  This string is at most
      FILENAME_MAX characters long including the terminating null character.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.16 $  $Date: 1997/10/14 14:36:32 $

----------------------------------------------------------------------*/

static char rcsid[] = "$Id: FLexpHome.c 1.16 1997/10/14 libtsp-v3r0 $";

#include <string.h>

#include <libtsp.h>
#include <libtsp/nucleus.h>
#include <libtsp/Xstdio.h>	/* FILENAME_MAX */
#include <libtsp/sysOS.h>

#ifdef MSDOS
#  ifndef unix
#    define MSDOS_SEP	/* Use MS-DOS directory separators */
#  endif
#endif

#ifdef MSDOS_SEP
#  define DIR_SEP_CHAR		'\\'
#else
#  define DIR_SEP_CHAR		'/'
#endif


int
FLexpHome (Fname, Ename)

     const char Fname[];
     char Ename[];

{
  char User[FILENAME_MAX];
  char Home[FILENAME_MAX];
  char *p;
  int n;

  if (Fname[0] == '~') {

    /* Get the user name */
    p = strchr (Fname, DIR_SEP_CHAR);
    if (p == NULL)
      STcopyMax (&Fname[1], User, FILENAME_MAX-1);
    else
      STcopyNMax (&Fname[1], User, (int) ((p-Fname)-1), FILENAME_MAX-1);

    /* Find the home directory */
    FLhomeDir (User, Home);
    if (Home[0] == '~')

      /* No home directory */
      n = STcopyMax (Fname, Ename, FILENAME_MAX-1);

    else {

      /* Form the output name */
      if (p == NULL)
	n = STcopyMax (Home, Ename, FILENAME_MAX-1);
      else
	n = FLjoinNames (Home, p+1, Ename);
    }
  }

  else

    /* No ~user specification */
    n = STcopyMax (Fname, Ename, FILENAME_MAX-1);

  return n;
}
