/*-------------- Telecommunications & Signal Processing Lab ---------------
                             McGill University

Routine:
  void UTsysMsg (const char Warnmsg[], ...)

Purpose:
  Print user and system warning messages

Description:
  This routine prints the system error message corresponding to the last system
  error encountered.  It first prints a user supplied text, and then prints
  the system error message.  Messages are written to stderr (standard error).

  The system error message is printed using perror.  The preamble to the system
  error message is either the name of this routine or the string supplied to
  UTsetProg.  An example of the use of this routine is as follows.
    UTsetProg ("XXProg");
    ...
    fp = fopen (Fname, ...);
    if (fp == NULL)
      UTsysMsg ("XXProc - Cannot open file \"%s\"", Fname);
  If fopen fails, a typical output to stderr would be: 
    XXProc - Cannot open file "abc"
    XXProg: No such file or directory

Parameters:
   -> const char Warnmsg[]
      Character string to be printed.  This string can contain optional
      formatting codes.  The arguments corresponding to the formatting codes
      appear at the end of the argument list.  The input string should not
      normally have a terminating newline character, since this routine
      supplies a newline.
   -> <args...>
      Arguments corresponding to the formatting codes.  The format string and
      the variable number of arguments is passed on to the system routine
      vprintf.

Author / revision:
  P. Kabal  Copyright (C) 1997
  $Revision: 1.4 $  $Date: 1997/10/14 16:00:06 $

-------------------------------------------------------------------------*/

static char rcsid[] = "$Id: UTsysMsg.c 1.4 1997/10/14 libtsp-v3r0 $";

#ifdef __STDC__

#include <errno.h>
#include <stdarg.h>		/* ANSI C variable-length argument list */

#include <libtsp.h>
#include <libtsp/Xstdio.h>
#include <libtsp/Xstdlib.h>


void
UTsysMsg (const char Warnmsg[], ...)

{
  va_list ap;
  char *p;

  va_start (ap, Warnmsg);

/* Print the warning message */
  vfprintf (stderr, Warnmsg, ap);
  fprintf (stderr, "\n");

  va_end (ap);

/* Print the text for the system error message */
  if (errno) {
    p = UTgetProg ();
    if (*p != '\0')
      perror (p);
    else
      perror ("UTsysMsg");
  }

  return;
}

#else /* not __STDC__ */

#include <errno.h>
#include <varargs.h>		/* K&R C variable-length argument list */

#include <libtsp.h>
#include <libtsp/Xstdio.h>
#include <libtsp/Xstdlib.h>


void
UTsysMsg (va_alist)

     va_dcl

{
  va_list ap;
  char *Warnmsg;
  char *p;

  va_start (ap);
  Warnmsg = va_arg (ap, char *);

/* Print the warning message */
  vfprintf (stderr, Warnmsg, ap);
  fprintf (stderr, "\n");

  va_end (ap);

/* Print the text for the system error message */
  if (errno) {
    p = UTgetProg ();
    if (*p != '\0')
      perror (p);
    else
      perror ("UTsysMsg");
  }

  return;
}
#endif /* __STDC__ */
