.TH x_mdialog 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
x_mdialog - Xwindow dialog
.SH CALLING SEQUENCE
.nf
result=x_mdialog(title,labels,default_inputs_vector) 
result=x_mdialog(title,labelsv,labelsh,default_input_matrix) 
.fi
.SH PARAMETERS
.TP
title   
: column vector of strings, dialog general comment 
.TP
labels  
: n column vector of strings, \fVlabels(i)\fR is the label of 
the ith required value
.TP
default_input_vector
: n  column vector of strings, \fVdefault_input_vector(i)\fR is the initial value of 
the ith required value
.TP
labelsv  
: n  vector of strings, \fVlabelsv(i)\fR is the label of 
the ith line of the required matrix
.TP
labelsh
: m  vector of strings, \fVlabelsh(j)\fR is the label of 
the jth column of the required matrix
.TP
default_input_matrix
: n x m matrix of strings, \fVdefault_input_matrix(i,j)\fR is the initial value of the (i,j) element of then required matrix
.TP
result
: n x m matrix of string if returned with "Ok" button or [] if returned with "Cancel" button
.SH DESCRIPTION
X-window vector/matrix interactive input function
.SH EXAMPLES
.nf
 txt=['magnitude';'frequency';'phase    '];
 sig=x_mdialog('enter sine signal',txt,['1';'10';'0'])
 mag=evstr(sig(1))
 frq=evstr(sig(2))
 ph=evstr(sig(3))

 rep=x_mdialog(['System Simulation';'with PI regulator'],...
                      ['P gain';'I gain '],[' ';' '])


 n=5;m=4;mat=rand(n,m);
 row='row';labelv=row(ones(1,n))+string(1:n)
 col='col';labelh=col(ones(1,m))+string(1:m)
 new=evstr(x_mdialog('Matrix to edit',labelv,labelh,string(mat)))

.fi
.SH SEE ALSO
x_dialog, x_choose, x_message , getvalue, evstr, execstr


