.TH contour 2 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
contour - level curves of surface 
.SH CALLING SEQUENCE
.nf
contour(x,y,z,nz,[theta,alpha,caption,flag,bbox,zlev])
contour2d(x,y,z,nz,[style,strf,leg,rect,nax])
.fi
.SH PARAMETERS
.TP 10
x,y 
: two real vectors of size respectively (1,n1) and (1,n2).
.TP 10
z   
: real matrix of size (n1,n2) (values)
.TP 10
nz 
: real vector of size > 1 (the level values)  or an integer ( the
number of level curves ).
.TP 10
flag
: is a real vector of size three [mode,type,box]
.TP 10
zlev
: real number
.TP 10
[theta,alpha,caption,flag,bbox,zlev]
: see \fVplot3d\fR
.TP 10 
[style,strf,leg,rect,nax]
: (see \fVplot2d\fR). The argument style gives the dash styles or colors
which are to be used for level curves. It must have the same size as the requested level 
curves. The other arguments follows the rules given in \fVplot2d\fR.
.SH DESCRIPTION
Draws level curves of a surface z=f(x,y). The level curves can be
drawn on a 3D surface or on 2D plot. For level curves on a 2d plot, the function
\fVcontour2d\fR should be preferred to the function \fVcontour\fR since
it accepts standard 2d parameters \fV[style,strf,leg,rect,nax]\fR. 
for level curves on a 3d plot, the optional arguments are the same as for the function 
\fVplot3d\fR (except \fVzlev\fR ) and their meaning are the same. They control the 
drawing of level curves on a 3D plot.
Only \fVflag(1)=mode\fR has a special meaning.
.RS
.TP 10
mode=0 
: the level curves are drawn on the surface defined by (x,y,z)
.TP
mode=1
: the level curves are drawn on a 3D plot and on the plan defined by 
equation z=zlev
.TP
mode=2 
: The level curves are drawn on a 2D plot.
.RE
Enter the command \fVcontour()\fR to see a demo.
.SH EXAMPLE
.nf
contour2d(1:10,1:10,rand(10,10),5,1:5,"011"," ",[0,0,11,11]);
.fi
.SH SEE ALSO
fcontour, fcontour2d
.SH AUTHOR
J.Ph.C..
