.TH frfit 1 "April 1993" "Scilab Group" "Scilab Function"
.so ../sci.an
.SH NAME
frfit - frequency response fit
.SH CALLING SEQUENCE
.nf
sys=frfit(w,fresp,order)
[num,den]=frfit(w,fresp,order)
sys=frfit(w,fresp,order,weight)
[num,den]=frfit(w,fresp,order,weight)
.fi
.SH PARAMETERS
.TP 10
w
: positive real vector of frequencies (Hz)
.TP
fresp
: complex vector of frequency responses (same size as \fVw\fR)
.TP
order
: integer (required order, degree of \fVden\fR)
.TP
weight
: positive real vector (default value \fVones(w)\fR).
.TP
num,den
: stable polynomials
.SH DESCRIPTION
\fVsys=frfit(w,fresp,order,weight)\fR returns a bi-stable transfer function
\fVG(s)=sys=num/den\fR, of of given \fVorder\fR such that 
its frequency response \fVG(w(i))\fR matches \fVfresp(i)\fR, i.e.
\fVfreq(num,den,%i*w)\fR should be close to \fVfresp\fR.
\fVweight(i)\fR is the weight given to \fVw(i)\fR.
.SH EXAMPLE
.nf
w=0.01:0.01:2;s=poly(0,'s');
G=syslin('c',2*(s^2+0.1*s+2), (s^2+s+1)*(s^2+0.3*s+1));
fresp=repfreq(G,w);
Gid=frfit(w,fresp,4);
frespfit=repfreq(Gid,w);
bode(w,[fresp;frespfit])
.fi
.SH SEE ALSO
frep2tf, factors, cepstrum, mrfit, freq, calfrq



